in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_typo;
uniform int tex_drawing;

#include scene_jyrevis25/common.glsl

bool getText(vec2 p, vec2 ind, vec2 range) {
    if (abs(p.x)>range.x/2.0 || abs(p.y)>range.y/2.0) return false;
    return 0.5<texture(textures[tex_typo], (p+ind+4.0+vec2(0.5)*(fract(range/2.0)*2.0))/8.0).r;
}

float box(vec2 p){vec2 q=abs(p); return max(q.x,q.y);}

float goofyFrame(vec2 p) {
    vec2 q = abs(p);
    q.x -= 0.7;

    float a = abs(box(q)-0.8);

    vec2 r = q-vec2(0.6,0.4);
    vec2 s = q-vec2(0.4,0.6);

    float b = min(abs(length(r)-0.2), abs(length(s)-0.2));
    float c = abs(box(q-vec2(0.505))-0.09);
    float d = mix(b, c, step(-0.605, min(-q.x,-q.y)));

    return mix(a, d, step(0.4, min(q.x,q.y)));
}

float freckle(vec2 p) {
    vec2 q = p*mat2(1.0,0.8,0.0,1.25);

    vec2 i_p = floor(p*8.0),
         f_q = fract(q*8.0);

    float wave = clamp(pow(1.0-abs(p.y+sin(p.x-u_t*4.0)*0.3+0.2), 2.0),0.0,1.0);
    
    return step(length(f_q*mat2(1.0,-0.8,0.0,0.8)-0.3), wave*0.3);
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_yellow;

    col = mix(col, c_red, step(goofyFrame(UV), 0.01));

    col = mix(col, c_red, freckle(UV));

    col = mix(col, c_blue, step(length(UV), 0.45));
    col = mix(col, c_red, step(length(UV), 0.4));

    if (texture(textures[tex_drawing], UV*0.4+0.5).r>0.5) {
        col = c_yellow;
    }

    for (int i=0; i<4; i++) {
        float x = (float(i)+0.5)/4.0-0.5;
        x*=1.6;
        float y = -0.5;
        col = mix(col, c_blue, step(length(UV-vec2(x,y)), 0.25));
        col = mix(col, c_red, step(length(UV-vec2(x,y)), 0.2));
        if (getText((UV-vec2(x,y))*2.5, vec2(float(i),0), vec2(1))) {
            col = c_yellow;
        }
    }

    vec2 curvedUV = UV+vec2(0,cos(UV.x*1.5+PI)*0.1);

    vec2 bannerUV = curvedUV-vec2(0,0.5);
    bannerUV.x = mix(fract(bannerUV.x*4.0)/8.0, bannerUV.x-sign(bannerUV.x)*0.7, step(0.7,abs(bannerUV.x)));

    col = mix(col, c_blue, step(box(bannerUV-vec2(0.35,-0.1)), 0.2));
    col = mix(col, c_red, step(box(bannerUV-vec2(0.35,-0.1)), 0.15));
    col = mix(col, c_blue, step(box(bannerUV-vec2(-0.35,-0.1)), 0.2));
    col = mix(col, c_red, step(box(bannerUV-vec2(-0.35,-0.1)), 0.15));
    col = mix(col, c_blue, step(box(bannerUV), 0.2));
    col = mix(col, c_red, step(box(bannerUV), 0.15));

    if (getText((curvedUV-vec2(0,0.5))*3.5, vec2(0,2), vec2(5,1))) {
        col = c_yellow;
    }

    C = vec4(col, 1.0);
}
