in vec2 uv;
in vec2 uvn;

out vec4 C;

uniform int input_tex;

void main() {
    vec2 image_res = vec2(textureSize(textures[input_tex], 0).xy);
    vec2 u = gl_FragCoord.xy/vec2(image_res);
    
    vec3 efg=texture(textures[input_tex], u).xzy;

    //calc eigenvalues
    float e=efg.x, f=efg.y, g=efg.z;
    float disc=sqrt(pow(e-g, 2.)+4.*f*f);
    float l1=.5*(e+g+disc);
    float l2=.5*(e+g-disc);

    //calc eigenvectors
    vec2 v1=vec2(f, l1-e);//maximal, gradient
    vec2 v2=vec2(l2-g, f);//minimal, tangent
    
//    int md = 40;
//    ivec2 iu = ivec2(U);
//    iu = iu % md;
//    if(iu.x == 0 && iu.y == 0)
//    for(int i = 0; i < 30; i++){
//        u += v2*0.4;
////        dbg
//        dbg_plot_ss(u);
//    }
    C=vec4(v1, v2);
}

