﻿#pragma once

#include "gl/Buffer.h"

class Texture;
class Model;

class Mesh {
public:
	std::vector<float> posList;
	std::vector<float> texCoordList;
	std::vector<float> normalsList;
	std::vector<float> coloursList;
	std::vector<int> indicesList;

	smallvec<Texture*, 16> textures;

	// Buffer* buff_normals = nullptr;
	// Buffer* bufF_verts = nullptr;
	// Buffer* buff_vert_indices = nullptr;
	// Buffer* buff_tex_coords = nullptr;

	int buff_normals_idx = 0;
	int bufF_verts_idx = 0;
	int buff_vert_indices_idx = 0;
	int buff_tex_coords_idx = 0;



	uint32_t face_count;
	uint32_t vertex_count;
	uint32_t element_count;

	Mesh(aiMesh* ai_mesh, bool is_outline, Model* model,
		int buff_normals_idx,
		int bufF_verts_idx,
		int buff_vert_indices_idx,
		int buff_tex_coords_idx
	);
};
