
uniform int curr_rendering_light;
uniform bool is_shadow;
uniform int depth_tex;

in vec3 out_pos;
out vec4 col;
in vec4 var_col;
in float obscure;

void main() {
//    if(is_shadow && lights[curr_rendering_light].type == LIGHT_TYPE_POINT){
//        gl_FragDepth = length(out_pos - lights[curr_rendering_light].pos) / lights[curr_rendering_light].far;
//    } else {
//        gl_FragDepth = gl_FragCoord.z;
//    }
//    col = vec4(1,0,0,1);
    col = var_col;

    if(depth_tex != 0 && obscure > 0.5){
        float depth_samp = texture(textures[depth_tex], U/R).x;
        float depth = gl_FragCoord.z;
        depth_samp = depth_to_linear(depth_samp);
        depth = depth_to_linear(depth);


        if(depth > depth_samp){
            bool dash = mod(gl_FragCoord.x, 10.0) < 5.0;
            float interp_fac = smoothstep(depth - depth_samp, 0.0, 0.02);

            col.a = mix(col.a, col.a * float(dash) * 0.1, interp_fac);

//            if(dash){
//                col.a *= 0.;
//            }
//            col.a -= 1.0;
        }

    }
}
