#pragma once

#include "SoundGroup.h"

static constexpr int PRELOAD_SOUNDS_CNT = 32;

struct AudioFileDescriptor {
	std::optional<SoundGroup*> sound_group = std::nullopt;
	bool spatialization_enabled = false;
};

struct AudioPlayDescriptor {
	int k = -1;
	float vol = -1.0;
	std::optional<glm::vec3> pos = std::nullopt;
	float start_offset = 0.0;
};

class AudioFile {
	public:
		ma_sound sounds[PRELOAD_SOUNDS_CNT];
		ma_splitter_node splitter_nodes[PRELOAD_SOUNDS_CNT];


		ma_engine* engine;
		bool looping = false;
		int file_idx = 0;
		float vol = 1.0f;
	  float length_seconds = 0.0f;

		AudioFile(
			ma_engine* engine,
			std::string_view name,
			AudioFileDescriptor desc = {}
			// ma_sound_group* sound_group,
			// bool spatialization_enabled = false
		);

		bool is_playing(int k = 0);
		float get_current_time();
		void set_current_time(float t, int k = 0);

		int start(AudioPlayDescriptor desc = {});

		int stop(int k = -1);

		void set_volume(float linear_volume);

		void set_looping_enabled(bool looping);

		uint64_t connect_effect(AudioEffect* m_effect);
};
