﻿#pragma once
#include "gl/Framebuffer.h"

class TexturePool {
public:
	struct TempFramebuffer {
		Framebuffer fb;
		bool free = true;
		TempFramebuffer() {
			
		};
	};
	struct TempTex{
		TempFramebuffer* fb;
		WObj<Texture> tex;
		int lifetime;
		bool used_this_frame;
	};
	bool descriptors_are_the_same( TextureDesc& a, TextureDesc& b );
	std::vector<int> tex_indices_to_remove;
	std::vector<TempFramebuffer> framebuffers;
	std::vector<TempTex> tex_pool;
	TexturePool();

	std::optional<TempTex*> find_temp_tex(TextureDesc& target_desc);
	TempTex* alloc_tex(TextureDesc& target_desc);
	Texture* get_tex(TextureDesc target_desc);
	Framebuffer* get_framebuffer(TextureDesc target_desc);

	void end_frame();
};
