﻿#pragma once

namespace Color{
	glm::vec3 okhsl_to_srgb(glm::vec3 _hsl);
	glm::vec3 srgb_to_okhsl(glm::vec3 rgb);
	glm::vec3 okhsv_to_srgb(glm::vec3 hsv);
	glm::vec3 srgb_to_okhsv(glm::vec3 rgb);
	// RGB oklab_to_srgb(Lab c){return ok_color::srgb_to_okhsv(rgb);}
	// Lab srgb_to_oklab(RGB c)
}

enum class BlendEquation{
	Add = GL_FUNC_ADD,
	Sub = GL_FUNC_SUBTRACT,
	RevSub = GL_FUNC_REVERSE_SUBTRACT,
	Min = GL_MIN,
	Multiply = GL_MULTIPLY_KHR,
	Screen = GL_SCREEN_KHR,
	Overlay = GL_OVERLAY_KHR,
	Darken = GL_DARKEN_KHR,
	Lighten = GL_LIGHTEN_KHR,
	ColorDodge = GL_COLORDODGE_KHR,
	ColorBurn = GL_COLORBURN_KHR,
	HardLight = GL_HARDLIGHT_KHR,
	SoftLight = GL_SOFTLIGHT_KHR,
	Difference = GL_DIFFERENCE_KHR,
	Exclusion = GL_EXCLUSION_KHR,
	Hue = GL_HSL_HUE_KHR,
	Saturation = GL_HSL_SATURATION_KHR,
	Color = GL_HSL_COLOR_KHR,
	Luminosity = GL_HSL_LUMINOSITY_KHR,
};
			
enum class BlendFactor{
	One = GL_ONE,
	Zero = GL_ZERO,
	SrcCol = GL_SRC_COLOR,
	DstCol = GL_DST_COLOR,
	OneMinusSrcCol = GL_ONE_MINUS_SRC_COLOR,
	OneMinusDstCol = GL_ONE_MINUS_DST_COLOR,
	SrcAlpha = GL_SRC_ALPHA,
	DstAlpha = GL_DST_ALPHA,
	OneMinusSrcAlpha = GL_ONE_MINUS_SRC_ALPHA,
	OneMinusDstAlpha = GL_ONE_MINUS_DST_ALPHA,
};
			
struct BlendState{
	BlendEquation equation = BlendEquation::Add;
	BlendFactor src_factor = BlendFactor::SrcAlpha;
	BlendFactor dst_factor = BlendFactor::OneMinusSrcAlpha;
	void use();
};

