#!/usr/bin/env bash
#
# run_demo.sh  –  Sert le dossier courant sur http://localhost:8080
#                 puis ouvre Firefox en mode plein écran (kiosk).
#
#  ▸  Usage :   ./run_demo.sh [PORT] [DIR]
#               PORT = 8080 par défaut
#               DIR  = répertoire de la démo (courant par défaut)

set -e

PORT="${1:-8080}"
DEMO_DIR="${2:-$(pwd)}"

# 1) Lance un mini‑serveur HTTP (Python ≥ 3.7 est présent sur 99 % des distros)
cd "$DEMO_DIR"
python3 -m http.server "$PORT" --bind 127.0.0.1 >/dev/null 2>&1 &
SERVER_PID=$!

# Assure la fermeture du serveur quand on quitte le script
cleanup() { kill "$SERVER_PID"; }
trap cleanup EXIT

# 2) Laisse au serveur le temps de démarrer (½ seconde devrait suffire)
sleep 0.5

URL="http://localhost:${PORT}"

# 3) Ouvre Firefox en plein écran
#    Le flag --kiosk (≥ Firefox 71) démarre directement sans chrome ni barres d’outils
#    Pour les versions plus anciennes, on retombe sur --fullscreen.
if firefox --version 2>&1 | grep -q "Firefox"; then
    firefox --kiosk "$URL" 2>/dev/null || firefox --fullscreen "$URL"
else
    echo "Firefox introuvable : installez‑le ou modifiez la ligne pour votre navigateur."
    cleanup
    exit 1
fi

# 4) Attendre que Firefox se ferme (Ctrl+Q ou Alt+F4) avant de tuer le serveur
wait
