/* ui.js
 * --------------------------------------------------------------------
 * Injecte un fragment HTML/CSS dans la page, affiche le bouton START
 * et charge/active la scène « main » quand l’utilisateur clique.
 * --------------------------------------------------------------------
 */

var Ui = pc.createScript('ui');

// --------------------------------------------------------------------
// Attributs exposés dans l’Inspector
// --------------------------------------------------------------------
Ui.attributes.add('css', {
    type: 'asset',
    assetType: 'css',
    title: 'CSS Asset'
});

Ui.attributes.add('html', {
    type: 'asset',
    assetType: 'html',
    title: 'HTML Asset'
});

// (facultatif) tu peux y faire glisser la scène directement
Ui.attributes.add('mainScene', {
    type: 'asset',
    assetType: 'scene',
    title: 'Main Scene (optionnel)'
});

// --------------------------------------------------------------------
// INITIALISATION
// --------------------------------------------------------------------
Ui.prototype.initialize = function () {
    // ---- 1) Injecte le CSS ----
    var style = document.createElement('style');
    style.innerHTML = this.css ? this.css.resource : '';
    document.head.appendChild(style);

    // ---- 2) Injecte le HTML ----
    this.div = document.createElement('div');
    this.div.classList.add('ui-container');           // ta classe racine
    this.div.innerHTML = this.html ? this.html.resource : '';
    document.body.appendChild(this.div);

    // ---- 3) Gestion du clic global sur le conteneur ----
    // Utilise une flèche pour conserver le this lexical (= le script)
    this.div.addEventListener('click', () => {
        this.launchMainScene();
    });
};

// --------------------------------------------------------------------
// Charge + active la scène "main"
// --------------------------------------------------------------------
Ui.prototype.launchMainScene = function () {
    // Si l’attribut Inspector est renseigné, on l’utilise directement
    let target = this.mainScene;

    // Sinon on cherche une scène nommée exactement "main"
    if (!target) {
        target = this.app.scenes.find('main');
    }

    if (!target) {
        console.error(
            'Impossible de trouver la scène "main". ' +
            'Vérifie son nom ou assigne‑la dans l’attribut Main Scene.'
        );
        return;
    }

    // changeScene charge (si besoin) ET active la scène
    this.app.scenes.changeScene(target, err => {
        if (err) console.error(err);
    });
};

// --------------------------------------------------------------------
// Nettoyage quand le script est détruit (facultatif mais propre)
// --------------------------------------------------------------------
Ui.prototype.destroy = function () {
    if (this.div && this.div.parentNode) this.div.parentNode.removeChild(this.div);
};
