/* StartButton.js
 * Placez ce script dans votre projet et attachez‑le (par ex. au Root).
 * Optionnel : réglez l’attribut « Main Scene » si le nom de la scène
 * n’est pas exactement “main”.
 */

var StartButton = pc.createScript('startButton');

StartButton.attributes.add('mainScene', {
    type: 'asset',
    assetType: 'scene',
    title: 'Main Scene (optionnel)'
});

StartButton.prototype.initialize = function () {
    // ---------- Écran UI plein écran ----------
    var screen = new pc.Entity('UI Screen');
    screen.addComponent('screen', {
        referenceResolution: { x: 1280, y: 720 },
        screenSpace: true
    });
    this.app.root.addChild(screen);

    // ---------- Bouton START ----------
    var button = new pc.Entity('Start Button');
    button.addComponent('element', {
        anchor: [0.5, 0.5, 0.5, 0.5],
        pivot:  [0.5, 0.5],
        type:   'image',
        width:  400,
        height: 140,
        color:  new pc.Color(0.15, 0.6, 0.95)
    });
    button.addComponent('button', { interactable: true });
    screen.addChild(button);

    var label = new pc.Entity('Label');
    label.addComponent('element', {
        anchor: [0, 0, 1, 1],
        pivot:  [0.5, 0.5],
        type:   'text',
        text:   'START',
        fontSize: 64,
        fontAsset: this.app.assets.find('Arial.json'),
        color:  new pc.Color(1, 1, 1)
    });
    button.addChild(label);

    // Click → startGame
    button.button.on('click', this.startGame, this);
};

StartButton.prototype.startGame = function () {
    // Nom de scène défini par l’attribut, sinon “main”
    var target = this.mainScene ? this.mainScene.name : 'main';

    // changeScene charge (si nécessaire) et active immédiatement la scène cible
    this.app.scenes.changeScene(target, function (err) {
        if (err) console.error(err);
    });
};
