/*  stripeMaterial.js  – compatible Model & Render Component  */
var StripeMaterial = pc.createScript('stripeMaterial');

/* vitesse de défilement (UV / seconde) */
StripeMaterial.attributes.add('speed', {
    type: 'number',
    default: 0.2,
    title: 'Speed'
});

/*──────────────────────── INITIALISE ────────────────────────*/
StripeMaterial.prototype.initialize = function () {
    const app = this.app;

    /*── Vertex ──*/
    const vs = /*glsl*/`
        attribute vec3 aPosition;
        attribute vec2 aUv0;
        uniform mat4 matrix_model;
        uniform mat4 matrix_viewProjection;
        varying vec2 vUv;
        void main () {
            vUv = aUv0;
            gl_Position = matrix_viewProjection * matrix_model * vec4(aPosition, 1.0);
        }
    `;

    /*── Fragment ──*/
    const fs = /*glsl*/`
        precision mediump float;
        varying vec2 vUv;
        uniform float uTime;
        uniform float uSpeed;
        void main () {
            float x = fract(vUv.x - uTime * uSpeed);
            const float w = 0.10;
            vec3 color = vec3(1.0);                          /* blanc */

            if (x > w && x <= 2.0*w)        color = vec3(1.0, 0.4, 0.8); /* rose/violet */
            else if (x > 2.0*w && x <= 3.0*w) color = vec3(0.4, 0.8, 1.0); /* bleu ciel */

            gl_FragColor = vec4(color, 1.0);
        }
    `;

    /*── Shader PlayCanvas ──*/
    const shader = new pc.Shader(app.graphicsDevice, {
        attributes: { aPosition: pc.SEMANTIC_POSITION, aUv0: pc.SEMANTIC_TEXCOORD0 },
        vshader: vs,
        fshader: fs
    });

    /*── Matériau ──*/
    this.material = new pc.Material();
    this.material.shader = shader;
    this.material.setParameter('uSpeed', this.speed);

    /*── Appliquer aux meshInstances de l’entité (Model ou Render) ──*/
    const applyToMeshInstances = (entity) => {
        /** @type {pc.MeshInstance[]} */
        let list = null;

        if (entity.model)  list = entity.model.meshInstances;
        if (entity.render) list = entity.render.meshInstances;

        if (list && list.length) {
            list.forEach(mi => mi.material = this.material);
            return true;
        }
        /* pas trouvé ici → on essaye sur les enfants */
        for (let i = 0; i < entity.children.length; i++) {
            if (applyToMeshInstances(entity.children[i])) return true;
        }
        return false;
    };

    if (!applyToMeshInstances(this.entity)) {
        console.warn('[stripeMaterial] Aucun meshInstance trouvé sur', this.entity.name);
    }

    /* chrono */
    this.time = 0;
};

/*──────────────────────── UPDATE ────────────────────────────*/
StripeMaterial.prototype.update = function (dt) {
    this.time += dt;
    this.material.setParameter('uTime', this.time);
};
