var StarfieldDepthMultiple = pc.createScript('starfieldDepthMultiple');

StarfieldDepthMultiple.attributes.add('cameraNames', {
    type: 'string',
    array: true,
    title: 'List of camera names'
});

StarfieldDepthMultiple.prototype.initialize = function() {
    // On stocke un tableau d'instances d'effet :
    this.effects = [];

    for (var i = 0; i < this.cameraNames.length; i++) {
        var cameraEntity = this.app.root.findByName(this.cameraNames[i]);
        if (cameraEntity && cameraEntity.camera) {
            // Créer une instance de l’effet pour cette caméra
            var effectInstance = new StarfieldDepthEffect(this.app.graphicsDevice);
            effectInstance.fade = 0; 
            // l’ajouter à la queue de cette caméra
            cameraEntity.camera.postEffects.addEffect(effectInstance);

            // Stocker l'instance pour l'update
            this.effects.push({
                cameraEntity: cameraEntity,
                effect: effectInstance
            });
        }
    }
};

StarfieldDepthMultiple.prototype.update = function(dt) {
    // Mettre à jour chaque instance
    for (var i = 0; i < this.effects.length; i++) {
        var camEntity = this.effects[i].cameraEntity;
        var effectInst = this.effects[i].effect;

        // Animation time
        effectInst.time += dt * 1.0; // (par ex. vitesse 1)

        // Fade
        if (effectInst.fade < 1) {
            effectInst.fade += dt * 0.5;
            if (effectInst.fade > 1) effectInst.fade = 1;
        }

        // On récupère l’orientation de la caméra en degrés
        var euler = camEntity.getEulerAngles();
        // Calculer un offset en se basant sur l’orientation
        var offsetX = euler.y * 0.001;
        var offsetY = euler.x * 0.001;
        effectInst.camOffset.set(offsetX, offsetY);
    }
};
