var VertexVibration = pc.createScript('vertexVibration');

VertexVibration.attributes.add('amplitude', {
    type: 'number',
    default: 0.02,
    title: 'Amplitude',
    description: 'Force de la vibration'
});

VertexVibration.attributes.add('speed', {
    type: 'number',
    default: 5,
    title: 'Vitesse',
    description: 'Vitesse de la vibration'
});

VertexVibration.prototype.initialize = function() {
    // Temps accumulé
    this.time = 0;
    
    // 1) Crée un matériau Standard
    this.material = new pc.StandardMaterial();
    
    // 2) Force la compilation initiale (ça prépare les chunks internes)
    this.material.update();
    
    // 3) Récupère le chunk transformVS
    var originalTransformVS = this.material.chunks.transformVS;
    
    if (!originalTransformVS) {
        console.warn("[vertexVibration] transformVS n’a pas été trouvé sur ce StandardMaterial.");
        return;
    }
    
    // 4) « Remplace » le code dans transformVS pour injecter notre code
    this.material.chunks.transformVS = originalTransformVS.replace(
        '#define TRANSFORMVS',
        [
            '#define TRANSFORMVS',
            'uniform float time;',
            'uniform float amplitude;',
            'uniform float speed;',
            '',
            '// On décale la position en fonction de sin/cos pour créer la vibration.',
         ' dPositionW += vec3(',
    'sin(time + dPositionW.x * speed) * amplitude',
    'cos(time + dPositionW.y * speed) * amplitude',
    '0.0',
            ');'
        ].join('\n')
    );
    
    // 5) Met à jour le matériau après la modification du chunk
    this.material.update();

    // 6) Assigne ce matériau à notre mesh
    var renderOrModel = this.entity.render || this.entity.model;
    if (renderOrModel && renderOrModel.meshInstances) {
        for (var i = 0; i < renderOrModel.meshInstances.length; i++) {
            renderOrModel.meshInstances[i].material = this.material;
        }
    } else {
        console.warn("[vertexVibration] L’entité n’a pas de meshInstances.");
    }
};

VertexVibration.prototype.update = function(dt) {
    // Incrémente le temps
    this.time += dt;
    
    // Envoie nos uniforms au shader
    this.material.setParameter('time', this.time);
    this.material.setParameter('amplitude', this.amplitude);
    this.material.setParameter('speed', this.speed);
};
