/* eslint-disable no-undef */
var MoveForward = pc.createScript('moveForward');

/*─────────────────────────────────────────────
 * ATTRIBUTS EXPOSES DANS L’INSPECTEUR
 *─────────────────────────────────────────────*/

// Vitesse d’avancement (unités PlayCanvas par seconde)
MoveForward.attributes.add('speed', {
    type: 'number',
    default: 1,
    title: 'Speed'
});

// Nom de l’évènement PlayCanvas qui déclenche le mouvement.
// Exemple : "player:startMove"  (émis ailleurs via this.app.fire(...)).
MoveForward.attributes.add('triggerEvent', {
    type: 'string',
    default: '',
    title: 'Trigger Event',
    description: 'Laisse vide pour démarrer immédiatement.'
});

/*─────────────────────────────────────────────
 * INITIALISATION
 *─────────────────────────────────────────────*/
MoveForward.prototype.initialize = function () {

    // Si aucun évènement n’est renseigné => on bouge dès la première frame
    this.isMoving = this.triggerEvent.trim() === '';

    // Si un évènement est spécifié, on s’enregistre dessus
    if (!this.isMoving) {
        this.app.on(this.triggerEvent, function () {
            this.isMoving = true;
        }, this);
    }
};

/*─────────────────────────────────────────────
 * UPDATE — appelé à chaque frame
 *─────────────────────────────────────────────*/
MoveForward.prototype.update = function (dt) {

    if (!this.isMoving) return;           // on attend encore l’évènement

    // Avance tout droit selon l’axe Z local (négatif ici)
    this.entity.translateLocal(0, 0, -this.speed * dt);
};
