var Destroyer = pc.createScript('destroyer');

// On ajoute un attribut pour définir le nom de l'évènement depuis l'éditeur
Destroyer.attributes.add('eventName', {
    type: 'string',
    default: 'supprimerEntite',
    title: 'Nom de l\'évènement'
});

// La fonction initialize est appelée une seule fois au démarrage
Destroyer.prototype.initialize = function() {
    // On écoute l'évènement spécifié
    this.app.on(this.eventName, this.onEventDestroy, this);
};

// Méthode déclenchée lorsque l’évènement est reçu
Destroyer.prototype.onEventDestroy = function() {
    // Détruit l’entité sur laquelle le script est attaché (et ses enfants)
    console.log("destruction entité!! par " + eventName)
    this.entity.destroy();
};

// Méthode appelée si l'entité elle-même est désactivée ou détruite
// pour détacher l'évènement et libérer les références
Destroyer.prototype.destroy = function() {
    this.app.off(this.eventName, this.onEventDestroy, this);
};
