var TimelineManager = pc.createScript('timelineManager');

// Ajout d'un attribut pour définir l'événement déclencheur
TimelineManager.attributes.add('startEvent', { type: 'string', default: 'startTimeline', title: "Événement de démarrage" });

TimelineManager.prototype.initialize = function() {
    this.timeElapsed = 0;
    this.isActive = false; // Désactivé au départ
    this.events = [];

    // Écoute l'événement défini dans l'attribut et démarre le compteur
    this.app.on(this.startEvent, this.start, this);
};

// Fonction pour ajouter un événement programmé
TimelineManager.prototype.addEvent = function(time, eventName) {
    this.events.push({ time: time, eventName: eventName });
    this.events.sort((a, b) => a.time - b.time); // Trie les événements par ordre chronologique
};

// Fonction pour démarrer la timeline
TimelineManager.prototype.start = function() {
    if (!this.isActive) {
        this.isActive = true;
        console.log(`TimelineManager démarré suite à l'événement '${this.startEvent}'`);
    }
};

// Update : ne fonctionne que si la timeline est active
TimelineManager.prototype.update = function(dt) {
    if (!this.isActive) return;

    this.timeElapsed += dt;

    // Vérifie et déclenche les événements
    for (let i = this.events.length - 1; i >= 0; i--) {
        let evt = this.events[i];
        if (Math.abs(this.timeElapsed - evt.time) < 0.1) { // Marge d'erreur pour éviter les problèmes de flottants
            this.app.fire(evt.eventName);
            this.events.splice(i, 1); // Supprime l'événement après déclenchement
        }
    }
};

// Fonction pour récupérer le temps écoulé
TimelineManager.prototype.getTimeElapsed = function() {
    return this.timeElapsed;
};
