var CameraLogger = pc.createScript('cameraLogger');

// Attribut pour nommer la caméra dans la console
CameraLogger.attributes.add('cameraName', {
    type: 'string',
    default: 'MaCaméra',
    title: 'Nom de la Caméra'
});

// Appelé une seule fois au démarrage, juste avant la première mise à jour
CameraLogger.prototype.initialize = function() {
    // On confirme l'initialisation
    // this.entity.name => nom de l'entité PlayCanvas
    console.log("CameraLogger initialisé sur l'entité:", this.entity.name, 
                "avec le nom personnalisé:", this.cameraName);
};

// Appelé chaque frame
CameraLogger.prototype.update = function(dt) {
    // Récupère la position de la caméra
    var position = this.entity.getPosition();
    // Récupère la direction avant de la caméra
    var direction = this.entity.forward;

    // Log dans la console
    console.log("[" + this.cameraName + "]",
                "Position:", position.toString(),
                "Direction:", direction.toString());
};
