// ----------------- SCRIPT DEFINITION ------------------ //
var Transition = pc.createScript('transition');

Transition.attributes.add('transitionColor', {
    type: 'rgb',
    default: [1, 1, 1],
    title: 'Light Color',
    description: 'Couleur de la lumière qui inonde l’écran'
});

Transition.attributes.add('progress', {
    type: 'number',
    default: 0,
    min: 0,
    max: 1,
    title: 'Progress',
    description: '0 = aucun effet, 1 = plein écran recouvert'
});

Transition.attributes.add('noiseScale', {
    type: 'number',
    default: 3,
    min: 0.1,
    max: 10,
    title: 'Noise Scale'
});

Transition.attributes.add('speed', {
    type: 'number',
    default: 0.2,
    min: 0,
    max: 3,
    title: 'Noise Speed',
    description: 'Vitesse d’évolution du motif aléatoire'
});

// Initialise l’effet et l’ajoute à la caméra
Transition.prototype.initialize = function () {
    // Crée notre PostEffect
    this.effect = new TransitionEffect(this.app.graphicsDevice);

    // Initialise ses propriétés
    this.effect.color.set(this.transitionColor.r, this.transitionColor.g, this.transitionColor.b);
    this.effect.progress = this.progress;
    this.effect.noiseScale = this.noiseScale;
    this.effect.speed = this.speed;
    
    // Quand on modifie un attribut dans l’éditeur, on met à jour l’effet
    this.on('attr', function (name, value) {
        if (name === 'transitionColor') {
            this.effect.color.set(value.r, value.g, value.b);
        } else {
            this.effect[name] = value;
        }
    }, this);

    // Ajout à la file de post-traitement de la caméra
    var queue = this.entity.camera.postEffects;
    queue.addEffect(this.effect);

    // Activation / désactivation par .enabled
    this.on('state', function (enabled) {
        if (enabled) {
            queue.addEffect(this.effect);
        } else {
            queue.removeEffect(this.effect);
        }
    });

    // Nettoyage à la destruction de l'entité
    this.on('destroy', function () {
        queue.removeEffect(this.effect);
    });
};
