var PlaceObjectBeforeCamera = pc.createScript('placeObjectBeforeCamera');

// 🎯 Nom de l'événement à écouter
PlaceObjectBeforeCamera.attributes.add('triggerEventName', {
    type: 'string',
    default: 'placeObject',
    title: "Nom de l'événement déclencheur"
});

// 🖼️ Caméra devant laquelle placer l'objet
PlaceObjectBeforeCamera.attributes.add('targetCamera', {
    type: 'entity',
    title: "Caméra cible"
});

// ↔️ Distance devant la caméra
PlaceObjectBeforeCamera.attributes.add('distance', {
    type: 'number',
    default: 2,
    title: "Distance devant la caméra"
});

// 🔄 Rotation à appliquer (en degrés)
PlaceObjectBeforeCamera.attributes.add('rotation', {
    type: 'vec3',
    default: [0, 0, 0],
    title: "Rotation appliquée (XYZ)"
});

// Initialisation
PlaceObjectBeforeCamera.prototype.initialize = function() {
    var self = this;

    // Vérifier qu'une caméra est bien définie
    if (!this.targetCamera) {
        console.warn("Aucune caméra définie dans le script PlaceObjectBeforeCamera !");
        return;
    }

    // Écoute de l'événement global défini dans l’éditeur
    if (this.triggerEventName && this.triggerEventName !== "") {
        this.app.on(this.triggerEventName, function() {
            self.placeObject();
        }, this);
    }
};

// Fonction qui place l'objet devant la caméra
PlaceObjectBeforeCamera.prototype.placeObject = function() {
    if (!this.targetCamera) return;

    // Obtenir la position et orientation de la caméra
    var cameraPos = this.targetCamera.getPosition();
    var cameraForward = this.targetCamera.forward.clone().normalize();

    // Calculer la position finale devant la caméra
    var targetPos = cameraPos.clone().add(cameraForward.scale(this.distance));

    // Appliquer la nouvelle position à l'objet
    this.entity.setPosition(targetPos);

    // Appliquer la rotation spécifiée
    var rotationQuat = new pc.Quat();
    rotationQuat.setFromEulerAngles(this.rotation.x, this.rotation.y, this.rotation.z);
    this.entity.setRotation(rotationQuat);
};
