var RotateAroundPivot = pc.createScript('rotateAroundPivot');

// Attribut pour sélectionner les entités à faire tourner
RotateAroundPivot.attributes.add('targetEntities', { type: 'entity', array: true, title: 'Target Entities' });

// Attribut pour sélectionner le point de pivot
RotateAroundPivot.attributes.add('pivotEntity', { type: 'entity', title: 'Pivot Entity' });

// Attribut pour le nom de l'événement qui déclenchera la rotation
RotateAroundPivot.attributes.add('eventName', { type: 'string', title: 'Event Name' });

// Attribut pour la vitesse de rotation
RotateAroundPivot.attributes.add('speed', { type: 'number', default: 1, title: 'Rotation Speed' });

RotateAroundPivot.prototype.initialize = function() {
    // Écouter l'événement spécifié
    this.app.on(this.eventName, function() {
        this.rotateEntities();
    }, this);
};

RotateAroundPivot.prototype.rotateEntities = function() {
    var pivotPosition = this.pivotEntity.getPosition();
    var angle = this.speed * pc.math.DEG_TO_RAD; // Convertir en radians

    this.targetEntities.forEach(function(entity) {
        var position = entity.getPosition();
        // Calcul de la nouvelle position en utilisant la rotation autour du pivot
        var x = Math.cos(angle) * (position.x - pivotPosition.x) - Math.sin(angle) * (position.y - pivotPosition.y) + pivotPosition.x;
        var y = Math.sin(angle) * (position.x - pivotPosition.x) + Math.cos(angle) * (position.y - pivotPosition.y) + pivotPosition.y;
        entity.setPosition(x, y, position.z); // Z reste le même
    });
};

RotateAroundPivot.prototype.update = function(dt) {
    // La rotation continue si nécessaire peut être gérée ici
};
