var ActivateEntityOnEvent = pc.createScript('activateEntityOnEvent');

// Attribut pour définir le nom de l'événement à écouter
ActivateEntityOnEvent.attributes.add('eventName', {
    type: 'string',
    default: 'activateEntity',
    title: 'Nom de l\'événement'
});

// Attribut pour sélectionner l'entité à activer lors de la réception de l'événement
ActivateEntityOnEvent.attributes.add('targetEntity', {
    type: 'entity',
    title: 'Entité à activer'
});

// Abonnement à l'événement lors de l'initialisation
ActivateEntityOnEvent.prototype.initialize = function() {
  //  this.barBroke = this.app.root.findByName('barBroke');
    if (this.targetEntity.enabled == true) {
        this.targetEntity.enabled=false;
    }
    this.app.on(this.eventName, this.onEventReceived, this);
};

// Callback appelée lors de la réception de l'événement
ActivateEntityOnEvent.prototype.onEventReceived = function() {
    if (this.targetEntity) {
        this.targetEntity.enabled = true;
        this.app.fire('barBroke');
        this.app.fire('explosion');
    } else {
        console.warn("Aucune entité cible n'a été définie pour l'activation.");
    }
};

// Désabonnement de l'événement lors de la destruction du script
ActivateEntityOnEvent.prototype.destroy = function() {
    this.app.off(this.eventName, this.onEventReceived, this);
};
