var EnableDepthLayer = pc.createScript("enableDepthLayer");

EnableDepthLayer.prototype.initialize = function() {
    // Récupère la layer de profondeur
    var depthLayer = this.app.scene.layers.getLayerById(pc.LAYERID_DEPTH);
    if (!depthLayer) {
        console.warn("Impossible de trouver la layer de profondeur (pc.LAYERID_DEPTH).");
        return;
    }
    // Incrémente le compteur pour forcer le rendu de la depth
    depthLayer.incrementCounter();

    // Gère l'activation / désactivation
    this.on("enable", function() {
        depthLayer.incrementCounter();
    }, this);

    this.on("disable", function() {
        depthLayer.decrementCounter();
    }, this);
};
