var BlinkOnEvent = pc.createScript('blinkOnEvent');

/**
 * Attributs configurables
 */
BlinkOnEvent.attributes.add('eventName', {
    type: 'string',
    default: 'barcamAnim',
    title: 'Nom de l’événement',
    description: 'Nom de l’événement déclencheur du clignotement'
});

BlinkOnEvent.attributes.add('delayMs', {
    type: 'number',
    default: 0,
    title: 'Délai (ms)',
    description: 'Temps avant le début du clignotement, en millisecondes'
});

BlinkOnEvent.attributes.add('blinkSpeed', {
    type: 'number',
    default: 200,
    title: 'Vitesse (ms)',
    description: 'Temps (en millisecondes) entre chaque ON/OFF'
});

BlinkOnEvent.attributes.add('blinkCount', {
    type: 'number',
    default: 3,
    title: 'Nombre de clignotements',
    description: 'Nombre de cycles ON → OFF → ON (1 clignotement = 2 basculements)'
});

/**
 * Au lieu d'un booléen, on utilise un champ texte, qui contiendra "0" ou "1"
 */
BlinkOnEvent.attributes.add('keepVisibleAtEnd', {
    type: 'string',
    default: '1',
    title: 'Rester visible à la fin (0/1)',
    description: 'Saisir "0" pour disparaître après le clignotement, "1" pour rester visible'
});

/**
 * initialize() - Appelée une fois au démarrage
 */
BlinkOnEvent.prototype.initialize = function() {
    this.barCacheEntities = this.app.root.findByTag('barCache');
    // États internes
    this.waiting = false;     
    this.waitTimer = 0;       
    this.blinking = false;    
    this.blinkTimer = 0;      
    this.currentToggle = 0;   

    // On écoute l’événement spécifié dans eventName
    this.app.on(this.eventName, this.onEventTriggered, this);
};

/**
 * Méthode appelée quand on reçoit l'événement "eventName"
 */
BlinkOnEvent.prototype.onEventTriggered = function() {
    // Réinitialise l’état à chaque nouvel événement
    this.waiting = false;
    this.waitTimer = 0;
    this.blinking = false;
    this.blinkTimer = 0;
    this.currentToggle = 0;

    for(var i = 0;i<this.barCacheEntities.length; i++ ){
        var entity=this.barCacheEntities[i];
        entity.enabled=false;
    }

    // Vérifie s’il faut attendre un délai avant de clignoter
    if (this.delayMs > 0) {
        this.waiting = true;
    } else {
        this.blinking = true;
    }
};

/**
 * update() - Appelée à chaque frame
 */
BlinkOnEvent.prototype.update = function(dt) {
    // 1) Phase d’attente (delayMs)
    if (this.waiting) {
        this.waitTimer += dt * 1000; 
        if (this.waitTimer >= this.delayMs) {
            this.waiting = false;
            this.blinking = true;
        }
    }

    // 2) Phase de clignotement
    if (this.blinking) {
        this.blinkTimer += dt * 1000; 

        // Quand on dépasse blinkSpeed, on toggler ON/OFF
        if (this.blinkTimer >= this.blinkSpeed) {
            this.blinkTimer = 0;
            this.currentToggle++;

            // Basculer l'affichage visuel (Render ou Model)
            if (this.entity.render) {
                this.entity.render.enabled = !this.entity.render.enabled;
            } else if (this.entity.model) {
                this.entity.model.enabled = !this.entity.model.enabled;
            }

            // Nombre total de basculements à effectuer
            var totalToggles = this.blinkCount * 2; 

            // Vérifie si on a fini tous les basculements
            if (this.currentToggle >= totalToggles) {
                this.blinking = false;

                // Interpréter le champ texte comme un booléen (0/1)
                var keepVisible = this.keepVisibleAtEnd === '1';

                if (keepVisible) {
                    // On force l’entité à redevenir visible
                    if (this.entity.render) {
                        this.entity.render.enabled = true;
                    } else if (this.entity.model) {
                        this.entity.model.enabled = true;
                    }
                } else {
                    // On force l’entité à rester invisible
                    if (this.entity.render) {
                        this.entity.render.enabled = false;
                    } else if (this.entity.model) {
                        this.entity.model.enabled = false;
                    }
                }
            }
        }
    }
};
