
const GlowAnimation = pc.createScript('glowAnimation');

GlowAnimation.attributes.add('alphaFrequency', {
    type: 'number',
    default: 0.5
});

GlowAnimation.attributes.add('minAlpha', {
    type: 'number',
    default: 0.4
});

GlowAnimation.attributes.add('maxAlpha', {
    type: 'number',
    default: 0.8
});

GlowAnimation.attributes.add('offsetSpeed', {
    type: 'number',
    default: 0.5
});

GlowAnimation.attributes.add('mirror', {
    type: 'boolean',
    default: false
});

GlowAnimation.prototype.initialize = function() {
    const mesh = this.entity.render.meshInstances[0];
    const material = mesh.material.clone();
    mesh.material = material;

    // make glow on the top too
    if(this.mirror) {
        material.emissiveMapTiling = new pc.Vec2(1, 2);
    }

    // animate alpha

    this.createTween({
        active: true,
        duration: 1 / this.alphaFrequency,
        loop: true,
        yoyo: true,
        from: this.minAlpha,
        to: this.maxAlpha,
        onUpdate: (tween) => {
            material.opacity = tween.value;
        }
    });

    // animate offset

    const offset = new pc.Vec2();
    this.createTween({
        active: true,
        duration: 1 / this.offsetSpeed,
        loop: true,
        from: 0,
        to: 1,
        onUpdate: (tween) => {
            offset.x = tween.value;
            material.emissiveMapOffset = offset;
            material.update();
        }
    });
};
