var FakeLoadingBar = pc.createScript('fakeLoadingBar');

// ----------------------------------------------------
// ATTRIBUTS EXISTANTS
// ----------------------------------------------------

// L’entité globale servant de "barre de chargement"
FakeLoadingBar.attributes.add('loadingBar', {
    type: 'entity',
    title: 'Cube de la barre'
});

// Taille max en X
FakeLoadingBar.attributes.add('maxScaleX', {
    type: 'number',
    default: 1,
    title: 'Taille max en X'
});

// Décalage initial (optionnel)
FakeLoadingBar.attributes.add('leftOffset', {
    type: 'number',
    default: 0,
    title: 'Décalage initial (gauche)'
});

// ----------------------------------------------------
// ATTRIBUTS POUR LES MODELS (les deux morceaux)
// ----------------------------------------------------
FakeLoadingBar.attributes.add('Lbar', {
    type: 'entity',
    title: 'Barre de gauche'
});

FakeLoadingBar.attributes.add('Rbar', {
    type: 'entity',
    title: 'Barre de droite'
});

// ----------------------------------------------------
// ATTRIBUTS POUR L'ANIMATION DE CASSURE
// ----------------------------------------------------
// Durée de l'animation de cassure (plus la valeur est élevée, plus l'animation est fluide)
FakeLoadingBar.attributes.add('breakDuration', {
    type: 'number',
    default: 2.0,
    title: 'Durée de la cassure'
});

// Position cible de la cassure pour la barre gauche (départ du centre, 0,0)
FakeLoadingBar.attributes.add('breakTargetLeft', {
    type: 'vec2',
    default: [-200.2, -80],
    title: 'Cible cassure gauche'
});

// Position cible de la cassure pour la barre droite
FakeLoadingBar.attributes.add('breakTargetRight', {
    type: 'vec2',
    default: [100, -80],
    title: 'Cible cassure droite'
});

// Rotation appliquée lors de la cassure (lerp de 0 jusqu'à cette valeur)
FakeLoadingBar.attributes.add('breakRotationLeft', {
    type: 'number',
    default: 30,
    title: 'Rotation cassure gauche'
});

FakeLoadingBar.attributes.add('breakRotationRight', {
    type: 'number',
    default: -30,
    title: 'Rotation cassure droite'
});

// ----------------------------------------------------
// ATTRIBUTS POUR LA POST-CASSURE
// ----------------------------------------------------
// Vecteur (direction et vitesse) de déplacement de la barre gauche après la cassure
FakeLoadingBar.attributes.add('postBreakLeftVector', {
    type: 'vec2',
    default: [-10, -3],
    title: 'Vecteur déplacement gauche'
});

// Vecteur de déplacement de la barre droite après la cassure
FakeLoadingBar.attributes.add('postBreakRightVector', {
    type: 'vec2',
    default: [5, -3],
    title: 'Vecteur déplacement droite'
});

// Vitesse de rotation continue (post-cassure) pour la barre gauche (en degrés par seconde)
FakeLoadingBar.attributes.add('rotationSpeedLeft', {
    type: 'number',
    default: -10,
    title: 'Vitesse rotation gauche (post)'
});

// Vitesse de rotation continue pour la barre droite
FakeLoadingBar.attributes.add('rotationSpeedRight', {
    type: 'number',
    default: 10,
    title: 'Vitesse rotation droite (post)'
});

// ----------------------------------------------------
// ATTRIBUTS POUR LE TWEENING POST-CASSURE
// ----------------------------------------------------
FakeLoadingBar.attributes.add('postBreakTweenDuration', {
    type: 'number',
    default: 1.0,
    title: 'Durée du tweening post-cassure'
});

FakeLoadingBar.attributes.add('accelerationPeakMultiplier', {
    type: 'number',
    default: 2.0,
    title: 'Multiplicateur de vitesse maximum'
});

// ----------------------------------------------------
// ATTRIBUTS POUR LE FLASHING
// ----------------------------------------------------
FakeLoadingBar.attributes.add('flashDuration', {
    type: 'number',
    default: 1.0,
    title: 'Durée du clignotement (flash)'
});
FakeLoadingBar.attributes.add('flashInterval', {
    type: 'number',
    default: 0.2,
    title: "Intervalle d'alternance du flash (s)"
});

// ----------------------------------------------------
// SEGMENTS DE PROGRESSION DU CHARGEMENT
// ----------------------------------------------------
FakeLoadingBar.prototype.segments = [
     { progress: 0.1, duration: 0.2 },
    { progress: 0.3, duration: 0.4 },
    { progress: 0.4, duration: 0.25 },
    { progress: 0.5, duration: 0.55 },
    { progress: 0.6, duration: 0.7},
    { progress: 0.7, duration: 0.3 },
    { progress: 0.8, duration: 0.9 },
    { progress: 1.0, duration: 0.8 }
   /*
    { progress: 0.1, duration: 0.4 },
    { progress: 0.1, duration: 1.2 },
    { progress: 0.3, duration: 0.6 },
    { progress: 0.32, duration: 0.1 },
    { progress: 0.5, duration: 0.8 },
    { progress: 0.53, duration: 0.3 },
    { progress: 0.8, duration: 1.0 },
    { progress: 0.95, duration: 0.3 },
    { progress: 0.95, duration: 0.5 },
    { progress: 1.0, duration: 0.6 }
    */
];

// ----------------------------------------------------
// INITIALISATION
// ----------------------------------------------------
FakeLoadingBar.prototype.initialize = function() {
    this.app.hasBroke = false;
    this.loading = true;
    this.currentSegment = 0;
    this.timer = 0;
    this.barCacheEntities = this.app.root.findByTag('barCache');
    this.barCache = this.app.root.findByName('barCache');
     // Pour éviter de lancer l'event plusieurs fois
    this.barcamFired = false;
    // on cache Lbar et Rbar
       // Trouver les entités Lbar et Rbar dans la scène
    this.lbar = this.app.root.findByName('Lbar');
    this.rbar = this.app.root.findByName('Rbar');
    
    // Cacher les deux morceaux de la barre
    if (this.lbar) {
        this.lbar.enabled = false;
    }
    
    if (this.rbar) {
        this.rbar.enabled = false;
    }

   
    
    // Récupérer les deux matériaux directement par nom
    // (assurez-vous qu’ils existent bien dans vos assets)
    var barreAsset = this.app.assets.find("barre", "material");
    var stripesAsset = this.app.assets.find("stripes2", "material");
    
    // Stocker les ressources pour usage rapide
    this.barreMat = (barreAsset && barreAsset.resource) ? barreAsset.resource : null;
    this.stripesMat = (stripesAsset && stripesAsset.resource) ? stripesAsset.resource : null;
    
  
    // Réinitialiser l'échelle de la barre de chargement
    var scale = this.loadingBar.getLocalScale();
    scale.x = 0;
    this.loadingBar.setLocalScale(scale);
    
    // On part d’un scale X = 0
    this.startScaleX = 0;
    
    // Position initiale de la barre de chargement
    var pos = this.loadingBar.getLocalPosition();
    pos.x = this.leftOffset;
    this.loadingBar.setLocalPosition(pos);
    
    // Variables pour l'animation de cassure
    this.breakTimer = 0;
    this.breaking = false;  // L'animation de cassure n'a pas encore commencé
    
    // Phase de tweening post-cassure (accélération/décélération)
    this.tweening = false;
    this.tweenTimer = 0;
    
    // Phase de flashing avant la cassure
    this.flashing = false;
    this.flashTimer = 0;
    
    // Pour éviter de switcher la caméra plusieurs fois
    this.cameraSwitched = false;
    
    // Récupérer la caméra par son nom "barCam" dans la scène
    this.barCam = this.app.root.findByName("barCam");
};

// ----------------------------------------------------
// UPDATE
// ----------------------------------------------------

FakeLoadingBar.prototype.update = function(dt) {

    // 1) PHASE DE CHARGEMENT : progression des segments
    if (this.currentSegment < this.segments.length) {
        var segment = this.segments[this.currentSegment];
        this.timer += dt;
        
        var ratio = pc.math.clamp(this.timer / segment.duration, 0, 1);
        var targetScaleX = segment.progress * this.maxScaleX;
        
        var scale = this.loadingBar.getLocalScale();
        scale.x = pc.math.lerp(this.startScaleX, targetScaleX, ratio);
        this.loadingBar.setLocalScale(scale);
        
        var pos = this.loadingBar.getLocalPosition();
        pos.x = this.leftOffset + scale.x / 2;
        this.loadingBar.setLocalPosition(pos);
        
        if (ratio >= 1) {
            this.currentSegment++;
            this.timer = 0;
            if (this.currentSegment < this.segments.length) {
                this.startScaleX = scale.x;
            } else 
            if (this.currentSegment == this.segments.length) {
                console.log("fin de l'aggrandissement -> fontaineStart")
                this.app.fire('fontaineStart');
                
                this.loading = false; 
            }
        }
        return;
    }
    
    // 2) PHASE DE FLASHING : clignotement des matériaux
    // Dès la fin du chargement, on lance immédiatement la phase de flashing
    if (!this.flashing && !this.breaking && !this.loading) {
        console.log("fakeLoadingBar.js : on flash (this.flashing==true)")
        this.flashing = true;
        this.flashTimer = 0;
    }
    
    if (this.flashing) {
       
        this.flashTimer += dt;
       // console.log(this.flashTimer)
        // Calcul d’un état binaire en fonction du temps pour basculer
        var flashState = (Math.floor(this.flashTimer / this.flashInterval) % 2 === 0);
        
        // Selon flashState, on assigne soit "barreMat", soit "stripesMat"
        // à chaque entité taguée "barCache"
        for (var i = 0; i < this.barCacheEntities.length; i++) {
            var modelComp = this.barCacheEntities[i].render;
            if (!modelComp) continue;
            
            if (flashState) {
                // Si on veut d’abord afficher le matériau "barre"
                if (this.barreMat) {
                    modelComp.material = this.barreMat;
                }
            } else {
                // Sinon on passe sur "stripes"
                if (this.stripesMat) {
                    modelComp.material = this.stripesMat;
                }
            }
        }
        
        // Une fois le temps de flashing écoulé
        if (this.flashTimer >= this.flashDuration) {
          
            // On fixe le matériau "stripes" avant de sortir du flashing
            for (var i = 0; i < this.barCacheEntities.length; i++) {
                var modelComp = this.barCacheEntities[i].model;
                if (!modelComp) continue;
                
                if (this.stripesMat) {
                    modelComp.material = this.stripesMat;
                }
            }
            
         console.log("fakeLoadingBar.js : event : bang  + supernova")
            this.app.fire('bang');
            this.app.fire('supernova')
            console.log("Fin du clignotement !");
            
            // on desactive le cache et on affiche les morceaux de barre
             this.barCache.enabled=false;
             this.Lbar.enabled = true;
             this.Rbar.enabled = true;
                  // Fin du flashing : on passe à l’étape suivante (par ex. cassure)
            this.flashing = false;
            this.breaking = true; // ou tout autre chose

            
        }
    }
    
    // 3) ANIMATION DE CASSURE
    //this.app.fire('fontaineStart')
    if (this.breaking && !this.tweening) {
        this.breakTimer += dt;
        var ratioBreak = pc.math.clamp(this.breakTimer / this.breakDuration, 0, 1);
        
        var lPos = this.Lbar.getLocalPosition();
        lPos.x = pc.math.lerp(0, this.breakTargetLeft.x, ratioBreak);
        lPos.y = pc.math.lerp(0, this.breakTargetLeft.y, ratioBreak);
        this.Lbar.setLocalPosition(lPos);
        
        var lRot = this.Lbar.getLocalEulerAngles();
        lRot.z = pc.math.lerp(0, this.breakRotationLeft, ratioBreak);
        this.Lbar.setLocalEulerAngles(lRot);
        
        var rPos = this.Rbar.getLocalPosition();
        rPos.x = pc.math.lerp(0, this.breakTargetRight.x, ratioBreak);
        rPos.y = pc.math.lerp(0, this.breakTargetRight.y, ratioBreak);
        this.Rbar.setLocalPosition(rPos);
        
        var rRot = this.Rbar.getLocalEulerAngles();
        rRot.z = pc.math.lerp(0, this.breakRotationRight, ratioBreak);
        this.Rbar.setLocalEulerAngles(rRot);
            if (!this.barcamFired && this.breakTimer >= .50) {
        this.app.fire('barcamAnim');
      //  this.app.fire('startTimeline');
        this.barcamFired = true; // Pour ne plus le relancer
    }
        if (ratioBreak >= 1) {
            this.tweening = true;
            this.tweenTimer = 0;
        }
        return;
    }
   /* 
    // 4) PHASE DE TWEENING POST-CASSURE : accélération puis décélération
    if (this.tweening) {
        this.tweenTimer += dt;
        var t = pc.math.clamp(this.tweenTimer / this.postBreakTweenDuration, 0, 1);
        var multiplier = (t < 0.5) ? 
            pc.math.lerp(0, this.accelerationPeakMultiplier, t * 2) : 
            pc.math.lerp(this.accelerationPeakMultiplier, 1, (t - 0.5) * 2);
        
        var lPos = this.Lbar.getLocalPosition();
        lPos.x += this.postBreakLeftVector.x * dt * multiplier;
        lPos.y += this.postBreakLeftVector.y * dt * multiplier;
        this.Lbar.setLocalPosition(lPos);
        
        var lRot = this.Lbar.getLocalEulerAngles();
        lRot.y += this.rotationSpeedLeft * dt * multiplier;
        this.Lbar.setLocalEulerAngles(lRot);
        
        var rPos = this.Rbar.getLocalPosition();
        rPos.x += this.postBreakRightVector.x * dt * multiplier;
        rPos.y += this.postBreakRightVector.y * dt * multiplier;
        this.Rbar.setLocalPosition(rPos);
        
        var rRot = this.Rbar.getLocalEulerAngles();
        rRot.y += this.rotationSpeedRight * dt * multiplier;
        this.Rbar.setLocalEulerAngles(rRot);
        
        if (t >= 1) {
            this.tweening = false;
        }
        return;
    }
    
    // 5) PHASE POST-CASSURE : Déplacement constant linéaire
 
    var lPos = this.Lbar.getLocalPosition();
    lPos.x += this.postBreakLeftVector.x * dt;
    lPos.y += this.postBreakLeftVector.y * dt;
    this.Lbar.setLocalPosition(lPos);
    
    var lRot = this.Lbar.getLocalEulerAngles();
    lRot.y += this.rotationSpeedLeft * dt;
    this.Lbar.setLocalEulerAngles(lRot);
    
    var rPos = this.Rbar.getLocalPosition();
    rPos.x += this.postBreakRightVector.x * dt;
    rPos.y += this.postBreakRightVector.y * dt;
    this.Rbar.setLocalPosition(rPos);
    
    var rRot = this.Rbar.getLocalEulerAngles();
    rRot.y += this.rotationSpeedRight * dt;
    this.Rbar.setLocalEulerAngles(rRot);
    */

};