#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

cbuffer PerObject : register(b0, space1)
{
  float4x4 g_world;
  float4 g_color;
  uint4 g_text[16];
};

struct CharData
{
	float2 size;
	float2 bearing;
	float2 uv0;
	float2 uv1;
	uint advance;
};

static const float4 verts[4] =
{
  float4(0.0f, 0.0f, 0.0f, 1.0f),
  float4(0.0f, 1.0f, 0.0f, 0.0f),
  float4(1.0f, 0.0f, 1.0f, 1.0f),
  float4(1.0f, 1.0f, 1.0f, 0.0f)
};

StructuredBuffer<CharData> g_char_data : register(t0, space0);

VertexTextOut main(uint id : SV_VertexID, uint instanceID : SV_InstanceID)
{
	VertexTextOut vout;
  float2 scale = float2(0.02,0.02);

  static const uint text_array[64] = (uint[64])g_text;
  uint char_index = (uint)(text_array[instanceID] & 0x0000FFFF);
  uint char_advance = (uint)((text_array[instanceID] >> 16) & 0x0000FFFF);
  CharData char_data = g_char_data[char_index];

  float xpos = (float)(char_advance)*scale.x + char_data.bearing.x*scale.x;
  float ypos = -(char_data.size.y - char_data.bearing.y)*scale.y;

  float2 size = char_data.size * scale;

  float3 pos = mul(float4(verts[id].x*size.x + xpos, verts[id].y*size.y + ypos, 0.0f, 1.0f), g_world).xyz;
  float4 clip_pos = mul(float4(pos, 1.0f), g_view_proj);

  float3 normal = float3(0,0,-1);
  normal = mul(float4(normal, 0.0f), g_world).xyz;
  vout.normal = mul(float4(normal, 0.0f), g_view).xyz;

  vout.pos_h = clip_pos;
  vout.pos_v = mul(float4(pos,1.0f), g_view).xyz;

  vout.color = g_color;
  vout.uv.x = lerp(char_data.uv0.x, char_data.uv1.x, verts[id].z);
  vout.uv.y = lerp(char_data.uv0.y, char_data.uv1.y, verts[id].w);
  return vout;
}
