#include "data\\shaders\\common.h"
#include "data\\shaders\\effectors.h"
#include "data\\shaders\\input_formats.h"

cbuffer PerFrame : register(b0)
{
  float4x4 g_light_view_proj;
}

cbuffer Constant : register(b0, space4)
{
  uint num_effectors;
};

StructuredBuffer<Instance> g_instance : register(t0, space0);
StructuredBuffer<uint> g_index_instance : register(t1, space0);

StructuredBuffer<Effector> g_force_effectors : register(t2, space0);

float4 main(VertexPNTIn vin, uint instanceID : SV_InstanceID) : SV_POSITION
{
  Instance inst = g_instance[g_index_instance[instanceID]];
	float3 world_pos = mul(float4(vin.pos, 1.0f), inst.world).xyz;

  for (uint i = 0; i < num_effectors; ++i)
  {
    Effector e = g_force_effectors[i];
    world_pos = CalcDisplacement(e, world_pos);
  }

  float4 clip_pos = mul(float4(world_pos, 1.0f), g_light_view_proj);
  return clip_pos;
}
