#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

Texture2D g_color : register(t0);
StructuredBuffer<uint2> g_light_grid_buffer : register(t1);
SamplerState g_sam_linear : register(s3);

float4 Heatmap(float2 pos_xy)
{
  const float w = g_screen_size.x;
  const uint grid_index = GridIndex(pos_xy, w);
  const uint num_lights = g_light_grid_buffer[grid_index].y;

  const float3 map_tex[] = {
    float3(0,0,0),
    float3(0,0,1),
    float3(0,1,1),
    float3(0,1,0),
    float3(1,1,0),
    float3(1,0,0),
  };

  const uint map_tex_len = 5;
  const uint max_heat = 50;

  float l = saturate((float)num_lights / max_heat) * map_tex_len;
  float3 a = map_tex[floor(l)];
  float3 b = map_tex[ceil(l)];
  return float4(lerp(a, b, l - floor(l)), 1.0);
}

//Jim Hejl filmic tone mapping operator
//already contains gamma correction
//http://filmicworlds.com/blog/filmic-tonemapping-operators/
float3 hejl(float3 col)
{
	float3 x = max(0, col-0.004);
	return (x*(6.2*x+.5))/(x*(6.2*x+1.7)+0.06);
}

//https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
float3 ACESFilm(float3 x)
{
  float a = 2.51f;
  float b = 0.03f;
  float c = 2.43f;
  float d = 0.59f;
  float e = 0.14f;
  return saturate((x*(a*x+b))/(x*(c*x+d)+e));
}

float3 RGBToYCoCg(in float3 rgb)
{
  return float3(
      0.25f * rgb.r + 0.5f * rgb.g + 0.25f * rgb.b,
      0.5f * rgb.r - 0.5f * rgb.b,
      -0.25f * rgb.r + 0.5f * rgb.g - 0.25f * rgb.b);
}

float3 YCoCgToRGB(in float3 yCoCg)
{
  return float3(
    yCoCg.x + yCoCg.y - yCoCg.z,
    yCoCg.x + yCoCg.z,
    yCoCg.x - yCoCg.y - yCoCg.z);
}

float3 ApplyGamma(float3 color)
{
    return pow(abs(color.rgb), 1.0f / 2.2f);
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 rcpFrame;
	g_color.GetDimensions(rcpFrame.x,rcpFrame.y);
	rcpFrame.x = 1.0/rcpFrame.x;
	rcpFrame.y = 1.0/rcpFrame.y;

  float4 color = g_color.Sample(g_sam_linear, pin.uv);

  color.xyz *= g_exposure;
  color.xyz = ApplyGamma(ACESFilm(color.xyz ));
  //color.xyz = hejl(color.xyz);

  //if (g_num_cullable_lights)
  //  color += Heatmap(pin.uv * g_screen_size);

  return float4(color.xyz,1.0f);
}
