#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

Texture2D g_input : register(t0);

RWTexture2D<float4> g_hdr : register(u0);
RWTexture2D<float4> g_history : register(u1);

float3 RGBToYCoCg(in float3 rgb)
{
  return float3(
      0.25f * rgb.r + 0.5f * rgb.g + 0.25f * rgb.b,
      0.5f * rgb.r - 0.5f * rgb.b,
      -0.25f * rgb.r + 0.5f * rgb.g - 0.25f * rgb.b);
}

float3 YCoCgToRGB(in float3 yCoCg)
{
  return float3(
    yCoCg.x + yCoCg.y - yCoCg.z,
    yCoCg.x + yCoCg.z,
    yCoCg.x - yCoCg.y - yCoCg.z);
}

float3 ApplySharpening(in float3 center, in float3 top, in float3 left, in float3 right, in float3 bottom)
{
  float3 result = RGBToYCoCg(center);
  float unsharpenMask = 4.0f * result.x;
  unsharpenMask -= RGBToYCoCg(top).x;
  unsharpenMask -= RGBToYCoCg(bottom).x;
  unsharpenMask -= RGBToYCoCg(left).x;
  unsharpenMask -= RGBToYCoCg(right).x;
  result.x = min(result.x + 0.25f * unsharpenMask, 1.1f * result.x);
  return YCoCgToRGB(result);
}

float3 Reinhard(in float3 hdr)
{
    return hdr / (hdr + 1.0f);
}

float3 ReinhardInverse(in float3 sdr)
{
  return sdr / max(1.0f - sdr, 1e-5f);
}

[numthreads(8, 8, 1)]
void main(uint3 globalID : SV_DispatchThreadID, uint3 localID : SV_GroupThreadID, uint localIndex : SV_GroupIndex, uint3 groupID : SV_GroupID)
{
   const float3 center = g_input[globalID.xy].xyz;
   const float3 top    = g_input[globalID.xy + uint2( 0,  1)].xyz;
   const float3 left   = g_input[globalID.xy + uint2( 1,  0)].xyz;
   const float3 right  = g_input[globalID.xy + uint2(-1,  0)].xyz;
   const float3 bottom = g_input[globalID.xy + uint2( 0, -1)].xyz;

   const float3 color = ApplySharpening(center, top, left, right, bottom);

   g_hdr[globalID.xy] = float4(center, 1.0f);
   g_history[globalID.xy] = float4(center, 1.0f);
}
