#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

Texture2D g_color : register(t0);
Texture2D g_history : register(t1);
Texture2D g_depth : register(t2);

SamplerState g_sam_linear : register(s3);
SamplerState g_sam_point : register(s1);


float4 clip_aabb(float3 aabb_min, float3 aabb_max, float4 p, float4 q)
{
	float3 p_clip = 0.5 * (aabb_max + aabb_min);
	float3 e_clip = 0.5 * (aabb_max - aabb_min) + 0.000001f;

	float4 v_clip = q - float4(p_clip, p.w);
	float3 v_unit = v_clip.xyz / e_clip;
	float3 a_unit = abs(v_unit);
	float ma_unit = max(a_unit.x, max(a_unit.y, a_unit.z));

	if (ma_unit > 1.0)
		return float4(p_clip, p.w) + v_clip / ma_unit;
	else
		return q;
}

float3 Reinhard(in float3 hdr)
{
    return hdr / (hdr + 1.0f);
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 uv = pin.uv;
  float4 color = g_color.Sample(g_sam_point, uv);
  float depth = g_depth.Sample(g_sam_point, uv).x;
  float2 texel_size = 1.0f.xx / g_screen_size;

  float4 world_pos = ScreenToView(float4(pin.uv,depth,1.0f));
  world_pos = mul(world_pos, g_inv_view);

  float4 prev_uv = mul(world_pos, g_prev_view_proj);
  prev_uv.xyz /= prev_uv.w;
  prev_uv.x = prev_uv.x * 0.5f + 0.5f;
  prev_uv.y = -prev_uv.y * 0.5f + 0.5f;

  float4 history = g_history.Sample(g_sam_linear, prev_uv.xy);

  float3 min_color = 1000000.0f.xxx;//color.xyz;
  float3 max_color = 0.0f.xxx;//color.xyz;
  float4 avg_color = 0.0f.xxxx;

  float2 du = float2(texel_size.x, 0.0);
	float2 dv = float2(0.0, texel_size.y);

	float4 ctl = g_color.Sample(g_sam_point, uv - dv - du);
	float4 ctc = g_color.Sample(g_sam_point, uv - dv);
	float4 ctr = g_color.Sample(g_sam_point, uv - dv + du);
	float4 cml = g_color.Sample(g_sam_point, uv - du);
	float4 cmc = g_color.Sample(g_sam_point, uv);
	float4 cmr = g_color.Sample(g_sam_point, uv + du);
	float4 cbl = g_color.Sample(g_sam_point, uv + dv - du);
	float4 cbc = g_color.Sample(g_sam_point, uv + dv);
	float4 cbr = g_color.Sample(g_sam_point, uv + dv + du);

  float4 cmin = min(ctl, min(ctc, min(ctr, min(cml, min(cmc, min(cmr, min(cbl, min(cbc, cbr))))))));
	float4 cmax = max(ctl, max(ctc, max(ctr, max(cml, max(cmc, max(cmr, max(cbl, max(cbc, cbr))))))));
  float4 cavg = (ctl + ctc + ctr + cml + cmc + cmr + cbl + cbc + cbr) / 9.0;

  float4 cmin5 = min(ctc, min(cml, min(cmc, min(cmr, cbc))));
	float4 cmax5 = max(ctc, max(cml, max(cmc, max(cmr, cbc))));
	float4 cavg5 = (ctc + cml + cmc + cmr + cbc) / 5.0;
	cmin = 0.5 * (cmin + cmin5);
	cmax = 0.5 * (cmax + cmax5);
	cavg = 0.5 * (cavg + cavg5);

  history = clip_aabb(cmin.xyz, cmax.xyz, clamp(cmin,cmax,cavg), history);
  //history.xyz = clamp(history.xyz, cmin.xyz, cmax.xyz);

  float modulation_factor = 0.86f;
  float3 result = lerp(color.xyz, history.xyz, modulation_factor);
  float3 noise3 = PDsrand3(pin.uv + sin(g_time) + 0.6959174) / 510.0;
  return float4(result + noise3,1.0f);
}
