#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

Texture2D g_color : register(t0);
SamplerState g_sam_linear : register(s3);

static const float3x3 gx = { 1.0, 0.0,  -1.0,
																2.0, 0.0, -2.0,
															  1.0, 0.0, -1.0};

static const float3x3 gy = { 1.0, 2.0, 1.0,
																0.0, 0.0, 0.0,
															-1.0,-2.0,-1.0};

float checker(float2 uv){
 	return (abs(floor(fmod(uv.x*10.,2.))-floor(fmod(uv.y*10.,2.))));
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 uv = pin.uv;
  float2 pixelSize = float2(1.0f/g_screen_size.x, 1.0f/g_screen_size.y);

  float3 color = g_color.Sample(g_sam_linear, uv).xyz;

  float center = g_color.Sample(g_sam_linear, uv).x;
	float top = g_color.Sample(g_sam_linear, uv + float2(0.0, -pixelSize.y)).x;
	float bottom = g_color.Sample(g_sam_linear, uv + float2(0.0, pixelSize.y)).x;
	float left = g_color.Sample(g_sam_linear, uv + float2(-pixelSize.x, 0.0f)).x;
	float right = g_color.Sample(g_sam_linear, uv + float2(pixelSize.x, 0.0f)).x;
	float topLeft = g_color.Sample(g_sam_linear, uv + float2(-pixelSize.x, -pixelSize.y)).x;
	float topRight = g_color.Sample(g_sam_linear, uv + float2(pixelSize.x, -pixelSize.y)).x;
	float bottomLeft = g_color.Sample(g_sam_linear, uv + float2(-pixelSize.x, pixelSize.y)).x;
	float bottomRight = g_color.Sample(g_sam_linear, uv + float2(pixelSize.x, pixelSize.y)).x;

  float cx = topLeft*gx[2].z+top*gx[1].z+topRight*gx[0].z+left*gx[2].y+center*gx[1].y + right*gx[0].y + bottomLeft*gx[2].x + bottom*gx[1].x + bottomRight*gx[0].x;
	float cy = topLeft*gy[2].z+top*gy[1].z+topRight*gy[0].z+left*gy[2].y+center*gy[1].y + right*gy[0].y + bottomLeft*gy[2].x + bottom*gy[1].x + bottomRight*gy[0].x;

	float len = sqrt(cx*cx + cy*cy);

  float3 col = lerp(color, float3(1,1,1), saturate(len));
  return float4(col,1.0f);
}
