#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

cbuffer cbPerFrame : register(b0)
{
    float g_progress;
    float g_aspect;
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 p = pin.uv * 2.0f - 1.0f;
  p.x *= g_aspect;
  float n = lerp(0.9,1.0,PDsrand(p*10.0f));

  p.x += cos(p.y*6.0)*0.15f;
  p.y += sin(p.x*4.0)*0.2f;

  float d = smoothstep(0.02,0.001,length(p) - g_progress*2);
  float3 col = float3(0,0,0);
  col.r = lerp(0, (sin((length(p)-g_progress*0.2)*400.0)*0.5+0.5) * n, d);
  col.g = lerp(0, (sin((length(p)-g_progress*0.2)*398.0)*0.5+0.5) * n, d);
  col.b = lerp(0, (sin((length(p)-g_progress*0.2)*396.0)*0.5+0.5) * n, d);

  float vigniette = smoothstep(1.7, 0.9,length(pin.uv * 2.0 - 1.0));
  col.xyz *= vigniette;

  col = pow(col, 1.0f / 2.2f);
  return float4(col, 1.0f);
}
