#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

Texture2D g_color : register(t0);
Texture3D g_luts[] : register(t1);
SamplerState g_sam_linear : register(s3);

float checker(float2 uv){
 	return (abs(floor(fmod(uv.x*10.,2.))-floor(fmod(uv.y*10.,2.))));
}

float3 RGBToYCoCg(in float3 rgb)
{
  return float3(
      0.25f * rgb.r + 0.5f * rgb.g + 0.25f * rgb.b,
      0.5f * rgb.r - 0.5f * rgb.b,
      -0.25f * rgb.r + 0.5f * rgb.g - 0.25f * rgb.b);
}

float3 YCoCgToRGB(in float3 yCoCg)
{
  return float3(
    yCoCg.x + yCoCg.y - yCoCg.z,
    yCoCg.x + yCoCg.z,
    yCoCg.x - yCoCg.y - yCoCg.z);
}

float3 Sharpening(float2 uv)
{
  const float3 center = g_color.SampleLevel( g_sam_linear, uv, 0.0, int2( 0, 0 ) ).xyz;
  const float3 top    = g_color.SampleLevel( g_sam_linear, uv, 0.0, int2( 0, 1 ) ).xyz;
  const float3 left   = g_color.SampleLevel( g_sam_linear, uv, 0.0, int2( 1, 0 ) ).xyz;
  const float3 right  = g_color.SampleLevel( g_sam_linear, uv, 0.0, int2( -1, 0 ) ).xyz;
  const float3 bottom = g_color.SampleLevel( g_sam_linear, uv, 0.0, int2( 0, -1 ) ).xyz;

  float3 result = RGBToYCoCg(center);
  float unsharpenMask = 4.0f * result.x;
  unsharpenMask -= RGBToYCoCg(top).x;
  unsharpenMask -= RGBToYCoCg(bottom).x;
  unsharpenMask -= RGBToYCoCg(left).x;
  unsharpenMask -= RGBToYCoCg(right).x;
  result.x = min(result.x + 0.25f * unsharpenMask, 1.1f * result.x);
  return YCoCgToRGB(result);
}

float2 FishEye(float2 uv, float mouse)
{
  float2 p = uv;
  float prop = g_screen_size.x /g_screen_size.y;
  p.y /= prop;

  float2 m = float2(0.5f, 0.5/prop);
  float2 d = p - m;
  float r = sqrt(dot(d,d));

  float power = (2.0 * 3.141592 / (2.0f * sqrt(dot(m,m))) ) * (mouse);

  float bind;
  if (power > 0.0f) bind = sqrt(dot(m,m));
  else { if (prop < 1.0) bind = m.x; else bind = m.y;}

  float2 result;
  if (power > 0.0f)
    result = m + normalize(d) * tan(r * power) * bind / tan(bind * power);
  else
    result = p;

  result.y *= prop;
  return result;
}

float2 ConvexEffect(float2 uv, float distortion)
{
  uv = uv* 2.0f - 1.0f;
  uv.x *= g_screen_size.x / g_screen_size.y;

  float r = length(uv);
  uv *= lerp(1.0f, 1.0f + distortion * r, r);

  uv.x /= g_screen_size.x / g_screen_size.y;
  uv = uv * 0.5 + 0.5;

  return uv;
}

float3 ChromaticAberration(float2 uv)
{
  float2 inv_size = 1.0f / g_screen_size;
  float fringe = g_chromab;
  float2 fringe_offset  = inv_size * fringe;

  float r_sample = g_color.Sample(g_sam_linear, uv + (float2(0.0, 1.0) * fringe_offset)).x;
  float g_sample = g_color.Sample(g_sam_linear, uv + (float2(-0.866, -0.5) * fringe_offset)).y;
  float b_sample = g_color.Sample(g_sam_linear, uv + (float2(0.866, -0.5) * fringe_offset)).z;

  return float3(r_sample,g_sample,b_sample);
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 uv = FishEye(pin.uv, lerp(0.0f,0.4f,saturate(g_fish_eye)));

  float3 color = g_color.Sample(g_sam_linear, uv).xyz;
  color = Sharpening(uv);

  float vigniette = smoothstep(g_min_vigniette, g_max_vigniette,length(pin.uv * 2.0 - 1.0));
  color.xyz *= vigniette;

  if (g_lut_idx >= 0)
  {
      color = g_luts[g_lut_idx].Sample(g_sam_linear, color.rgb).rgb;
  }

  float3 noise3 = PDsrand3(pin.uv + sin(g_time) + 0.6959174) / g_noise_scale;
  color.xyz += noise3;

  float alpha = smoothstep(g_min_chromab, g_max_chromab,length(uv * 2.0 - 1.0));
  color = lerp(color, ChromaticAberration(uv), alpha);

  return float4(color,1.0f);
}
