#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"
#include "data\\shaders\\FastNoiseLite.h"

Texture2D g_color : register(t0);
SamplerState g_sam_linear : register(s3);

float rand( float2 n )
{
  return frac(sin(dot(n.xy, float2(12.9898, 78.233)))* 43758.5453);
}

float trunc( float x, float num_levels )
{
	return floor(x*num_levels) / num_levels;
}

float2 trunc(float2 x, float num_levels)
{
  return floor(x*num_levels) / num_levels;
}

float remap  ( float t, float a, float b ) {
	return saturate( (t - a) / (b - a) );
}

float linterp( float t ) {
	return saturate( 1.0 - abs( 2.0*t - 1.0 ) );
}

float3 spectrum_offset( float t ) {
	float3 ret;
	float lo = step(t,0.5);
	float hi = 1.0-lo;
	float w = linterp( remap( t, 1.0/6.0, 5.0/6.0 ) );
	float neg_w = 1.0-w;
	ret = float3(lo,1.0,hi) * float3(neg_w, w, neg_w);
	return pow( ret, float3(1.0/2.2, 1.0/2.2, 1.0/2.2) );
}

float4 main(VertexTOut pin) : SV_Target
{
  float2 uv = pin.uv;
  float2 pixelSize = float2(1.0f/g_screen_size.x, 1.0f/g_screen_size.y);
	float2 dim = g_screen_size;

  float4 color = g_color.Sample(g_sam_linear, uv);

  fnl_state noise = fnlCreateState();
  noise.frequency = 0.3f;

	float glitch = g_glitch;
	float time = g_time;

	float gnm = saturate(glitch);
	float rnd0 = rand( trunc( float2(time, time), 6.0 ) );
	float r0 = saturate((1.0-gnm)*0.7 + rnd0);
	float rnd1 = 0.0f;//rand(float2(trunc(uv.x,2.0f*r0),time)); //vertical
	float r1 = 0.5 - 0.5*gnm + rnd1;

	float rnd2 = 1.0f;//rand(float2(trunc(uv.y, 1.0f * r1), time)); //horizontal
	float r2 = saturate( rnd2 );

	float rnd3 = 0.0f;//rand( float2(trunc( uv.y, 2.0*r0 ), time) );
	float r3 = (1.0-saturate(rnd3+0.8)) - 0.1;

	float pxrnd = rand( uv + time );

	float offs = 0.05 * r2 * glitch;// * ( rnd0 > 0.5 ? 0.5 : -0.5 );
	offs += 0.5 * pxrnd * offs * (fnlGetNoise3D(noise, uv.y*10.0f, g_time, uv.x*10.0)*2.0 - 1.0f);

	//uv.y += 0.1 * r3 * glitch;

	float4 sum = float4(0,0,0,0);
  float3 wsum = float3(0,0,0);
  for (int i = 0; i < 10; ++i)
	{
		float t = float(i)/10.0f;
		uv.x = saturate(uv.x+offs*t);
    float4 sample = g_color.Sample(g_sam_linear, uv);
    float3 s = spectrum_offset(t);

    sample.rgb *= s;
    wsum += s;

    sum += sample;
	}
	sum.rgb /= wsum;

	return lerp(color, sum, g_glitch_blend);
}
