#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\common.h"

cbuffer cbPerFrame : register(b0)
{
  float2 g_inv_size;
  int g_mip_level;
  int _pad;
};

Texture2D g_input : register(t0);
SamplerState g_sam_linear : register(s3);

static float2 offsets[9] = { 
    float2( 1, 1), float2( 0, 1), float2(-1, 1), 
    float2( 1, 0), float2( 0, 0), float2(-1, 0), 
    float2( 1,-1), float2( 0,-1), float2(-1,-1)
    };

float4 main(VertexTOut pin) : SV_Target
{
  float4 color = float4(0,0,0,0);
  
  if (g_mip_level==0)
  {
    for(int i=0;i<9;i++)
      color += log(max(g_input.Sample(g_sam_linear, pin.uv + (2 * g_inv_size * offsets[i])),0.01.xxxx )*g_bloom_mul);
    return exp(color / 9.0f);
  }
  else
  {
    for(int i=0;i<9;i++)
      color += g_input.Sample(g_sam_linear, pin.uv + (2 * g_inv_size * offsets[i]));
    return color / 9.0f;
  }
  
  return color;
}