#include "data\\shaders\\input_formats.h"

Texture2D<float> g_depth : register(t2, space2);

SamplerState g_sam_point : register(s1);

float main(VertexTOut pin) : SV_Depth
{
  float2 dim;
  g_depth.GetDimensions(dim.x,dim.y);
  float2 tex_size = 1.0f / dim;

  float depth0 = g_depth.Sample(g_sam_point, pin.uv).r;
  float depth1 = g_depth.Sample(g_sam_point, pin.uv + float2(0,1)*tex_size).r;
  float depth2 = g_depth.Sample(g_sam_point, pin.uv + float2(1,1)*tex_size).r;
  float depth3 = g_depth.Sample(g_sam_point, pin.uv + float2(1,0)*tex_size).r;

  return max(max(max(depth0, depth1), depth2), depth3);
}
