#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

StructuredBuffer<Particle> particles : register(t0);

static const float3 offsets[] =
{
  float3(-1,-1,0),
  float3(-1,1,0),
  float3(1,-1,0),
  float3(1,-1,0),
  float3(-1,1,0),
  float3(1,1,0)
};

VertexPCOut main(uint id : SV_VertexID)
{
	VertexPCOut vout;
  uint particle_idx = id/6;
  uint quad_idx = id%6;
  
  float3 p = float3((float)particles[particle_idx].p_x,(float)particles[particle_idx].p_y,(float)particles[particle_idx].p_z);
	float3 pos = mul(float4(p,1.0f),g_view).xyz + offsets[quad_idx]*0.01f;
  float4 clip_pos = mul(float4(pos, 1.0f), g_proj);
  vout.pos_h = clip_pos;
  vout.color = float4(1,0,0,1);
  return vout;
}