#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

StructuredBuffer<Particle> in_particles : register( t0 );
RWStructuredBuffer<Particle> out_particles : register(u0);

cbuffer PerFrame : register(b0)
{
  double delta_time;
  uint max_particles;
  uint max_constraints;
}

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{  
  Double3 gravity;
  gravity.x = 0.0;
  gravity.y = -1.0;
  gravity.z = 0.0;
  
  uint index = dispatch_thread_id.x;
  
  if (index >= max_particles)
    return;
  
  Particle particle = in_particles[index];
  
  //external forces
  particle.prev_x = particle.p_x;
  particle.prev_y = particle.p_y;
  particle.prev_z = particle.p_z;
  
  Double3 v = PackDouble(particle.v_x, particle.v_y, particle.v_z);
  Double3 p = PackDouble(particle.p_x, particle.p_y, particle.p_z);
  
  v = Add(v, Mul(gravity,delta_time));
  p = Add(p, Mul(v, delta_time));
  
  particle.v_x = v.x;
  particle.v_y = v.y;
  particle.v_z = v.z;
  
  particle.p_x = p.x;
  particle.p_y = p.y;
  particle.p_z = p.z;

  out_particles[index] = particle;
}