#include "data\\shaders\\particles\\particles_common.h"
#include "data\\shaders\\input_formats.h"

StructuredBuffer<Particle> particles : register(t0);

float4 main(VertexPNTIn vin, uint instanceID : SV_InstanceID) : SV_POSITION
{
	Particle p = particles[instanceID];
  float3 pos = GetParticlePos(p, vin.pos);
	float3 world_pos = mul(float4(pos, 1.0f), g_world).xyz;
  float4 clip_pos = mul(float4(world_pos, 1.0f), g_view_proj);
  return clip_pos;
}
