#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

struct DustParticle
{
  float3 pos;
  float size;
};

RWStructuredBuffer<DustParticle> particles : register(u0);

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{
  uint index = dispatch_thread_id.x;
  float3 pos = particles[index].pos;
  float speed = 0.1f * g_dust_speed;
  pos += float3(sin(pos.y+125.0f),sin(pos.z+336.0f),sin(pos.x*33315.0f))*speed*g_delta_time + g_dust_force.xyz*g_delta_time;
  particles[index].pos = pos;
}
