#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

StructuredBuffer<Instance> g_instance : register(t0, space0);
StructuredBuffer<uint> g_index_instance : register(t1, space0);

VertexPPIOut main(VertexPNTIn vin, uint instanceID : SV_InstanceID)
{
  VertexPPIOut vout;
  Instance inst = g_instance[g_index_instance[instanceID]];
  float3 world_pos = mul(float4(vin.pos, 1.0f), inst.world).xyz;

  vout.pos_h = mul(float4(world_pos, 1.0f), g_view_proj);
  vout.clip_pos = vout.pos_h;
  vout.instance_id = instanceID;

  return vout;
}
