#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"
#include "data\\shaders\\pcss.h"

StructuredBuffer<Material> g_materials : register(t5, space1);
Texture2D g_mat_tex[] : register(t0, space3);

SamplerState g_sam_point : register(s0);
SamplerState g_sam_linear : register(s2);

float4 main(VertexPPNTOut pin) : SV_Target
{
    float3 color = float3(0.0f, 0.0f, 0.0f);
    Material mat = g_materials[pin.mat_index];

    float3 n = normalize(pin.normal);
    float3 v = normalize(-pin.pos_v);
    float3 l = normalize(float3(-1,1,-1));

    mat.diffuse *= g_mat_tex[mat.diffuse_tex].Sample(g_sam_linear, pin.uv * mat.tiling).xyz;
    mat.roughness *= g_mat_tex[mat.roughness_tex].Sample(g_sam_linear, pin.uv * mat.tiling).x;

    color = (mat.diffuse*0.3) +  (mat.diffuse*saturate(dot(n,l))*0.7);

    return float4(color, mat.specular.x);
}
