pico-8 cartridge // http://www.pico-8.com
version 38
__lua__
-- axteroids
-- by syntax inc
-- revision 2025


function _init()
	
	roomx=128	-- room size
	roomy=128 -- 128x128 minimun
	o_o={x=0,y=0}
	state=0
	amax=56 -- max asteroid size (60 max)
	range=90
	wait=200
	gamemode=1
	extended=true
	minimap=false
	pos=0
	let=0
	menu_i=0
	pal_i=0
	palet={
	split'1,13,7,7,7,7,7',--white
	split'131,3,138,138,138,138,138',--green
	split'130,2,8,8,8,8,8',--red
	split'1,140,12,12,12,12,12', --blue
	split'132,4,10,10,10,10,10',--yellow
	split'130,141,14,14,14,14,14',--pink	
	split'129,131,3,139,11,138,7',-- green sparks
	split'130,2,136,8,142,143,15',-- red sparks
	split'129,1,140,12,12,7,7',-- blue sparks
	split'2,136,8,9,10,11,12',--infra
	split'7,7,7,0,0,0,0',--outline
	split'128,133,134,134,15,15,7',-- blurry
	split'128,133,134,15,7,7,7',--sharp
	split'129,1,7,7,7,7,7'--pixel
	}
	
	update_palet(1)

	
	acid_x=0 acid_y=0 acid_p=0 acid_g=0 acid_q=0 acid_e=0 acid_k=0 acid_o=0 acid_v=0
	play_music=true
	
	-- player
	p={
		x=0,
		y=0,
		vx=0,
		vy=0,
		siz=5,
		rot=0.25,
		dir=0,
		spd=0,
		acc=0,
		viz=false,
		col=1,
		sco=0,
		lif=3,
		lvl=1,
		ext=0, -- extra life
		pow=0, -- power up
		pot=0, -- power up timer
		shd=0, -- shield
		nam={97,97,97}
	}
	
	stars={}
	spawn_stars(max(roomx,roomy))
	
	asteroids={}
	abump=.7 -- bumps
 
	spawn_asteroids(10,14)
	spawn_asteroids(5,18)
	spawn_asteroids(1,amax)
	
	saucers={}
	spawn_saucer(5)
	
	spaceworms={}
	
	bosses={}
	
	particules={}
	
	bullets={}
	
	trimis={}
	
	powerups={}

 cartdata("syntax_axteroids_highscore")
 highscore={}
 -- default highscore
 local hn=split'stx,log,zep,luc,shy,dub,rez,eli,lou,jul' 
 local sc=0x.c350
	for i=1,10 do
		local hs={n=hn[i],s=sc}
		add(highscore,hs)
 	sc-=0x.1388
	end
 --save_highscore()

 -- load highscore on cartdata
 load_highscore()
 
end
---------- update --------------------------------------------------------------------------------------

function _update()
	
	if wait>0 then wait-=1 end
	if play_music then acid() end
	if btn(0) then p.rot=(p.rot+0.020)%1 end -- rotate left
	if btn(1) then p.rot=(p.rot-0.020)%1 end -- rotate right
	if btn(2) then -- thrust
		if state==1 or state==2 and wait==0 then
			if p.spd<5 then
				p.acc+=0.05
				local pa={x=0,y=0,dir=p.rot+.4+rnd(.2),spd=.5+rnd(.5),lif=10+rnd(5)}
				add(particules,pa)
				sfx(1)
			end
		end  
	end
	
	
	if p.viz then // game
 	--if btnp(4) then teleport or brake or ...
		if btnp(5) then //shoot
			if p.pow==2 then --double shot 
				shoot(p.x,p.y,p.vx,p.vy,p.rot+.01,p.siz,1)
				shoot(p.x,p.y,p.vx,p.vy,p.rot-.01,p.siz,1)
			elseif p.pow==3 then -- triple shot
				shoot(p.x,p.y,p.vx,p.vy,p.rot,p.siz,1)
				shoot(p.x,p.y,p.vx,p.vy,p.rot+.02,p.siz,1)
				shoot(p.x,p.y,p.vx,p.vy,p.rot-.02,p.siz,1)
   elseif p.pow==6 then -- triple shot omni
				shoot(p.x,p.y,p.vx,p.vy,p.rot,p.siz+1,1)
				shoot(p.x,p.y,p.vx,p.vy,p.rot+.33,p.siz+1,1)
				shoot(p.x,p.y,p.vx,p.vy,p.rot+.66,p.siz+1,1)   	
			else -- single shot
				shoot(p.x,p.y,p.vx,p.vy,p.rot,p.siz+1,1)
			end
			sfx(0)
		end
		
		if p.pow==5 then -- blast
			for j=1,50 do
				shoot(p.x,p.y,p.vx,p.vy,p.rot+j*0.02,p.siz,1)
			end
			p.pow=0
		end
		
		if btnp(4) then minimap = not minimap end
	end
	
	-- move player
	p.acc=.7*p.acc
	p.vx=.99*p.vx+p.acc*cos(p.rot)
	p.vy=.99*p.vy+p.acc*sin(p.rot)
	p.dir=atan2(p.vx,p.vy)
	p.spd=sqrt(p.vx^2+p.vy^2)
	p.x-=p.vx
	p.y-=p.vy
	wrap_obj(p)
	
	-- move stars
	for s in all(stars) do
		s.x-=p.vx*s.z
		s.y-=p.vy*s.z
		wrap_obj(s)
	end
	
	-- move particules
	for i=#particules,1,-1 do
		local pa=particules[i]
		pa.x+=pa.spd*cos(pa.dir)-p.vx
		pa.y+=pa.spd*sin(pa.dir)-p.vy
		pa.lif -=1
		if pa.lif<0 then del(particules,pa) end
	end
	
	-- move bullets
	for i=#bullets,1,-1 do
		local b=bullets[i]
--		b.x=b.x+b.vx-p.vx
--		b.y=b.y+b.vy-p.vy
		b.x=b.x+b.spd*cos(b.dir)-p.vx
		b.y=b.y+b.spd*sin(b.dir)-p.vy
		b.lif -=1
		if b.lif<0 then del(bullets,b) end
	end
	
	-- move asteroids & check distance to player
	local aster_col={}
	for i=#asteroids,1,-1 do
		local a=asteroids[i]
		a.x += a.spd*cos(a.dir)
		a.y += a.spd*sin(a.dir)
		a.x=a.x-p.vx
		a.y=a.y-p.vy
		a.rot += a.drot
		wrap_obj(a)
		--if abs(a.x)<range and abs(a.y)<range then -- faster
		local dist=dist_trig(a,o_o) -- can be done every 2,3,4... frames for speed, no problem
		if dist<range+a.siz then
			a.col=true -- collidable
			add(aster_col,a)
		else
			a.col=false
		end
	end
	
	-- move saucers & shoot & check distance to player
	local saucer_col={}
	for i=#saucers,1,-1 do
		local sa=saucers[i]
		sa.x += sa.spd*cos(sa.dir)-p.vx
		sa.y += sa.spd*sin(sa.dir)-p.vy
		wrap_obj(sa)
		sa.tim=(sa.tim-1)%50
		sa.fir=(sa.fir-1)%50
		if p.viz then
			local dist=dist_trig(sa,o_o)
			if dist<range then
				-- move to player
				if sa.tim<sa.iqt then
					local ang=norm_ang(atan2(sa.x,sa.y)-sa.dir)
					if ang>0.5 then sa.dir+=.02 else sa.dir-=.02 end
					sa.dir=norm_ang(sa.dir)
				end
				-- shoot toward player
				if sa.fir==0 then
					local fdir=atan2(sa.x,sa.y)+.5
					fdir+=rnd(0.2)-0.1
					if sa.siz>6 then fdir=rnd(1) end -- big saucer shoot random
					local b={
					x=sa.x+(sa.siz+1)*cos(fdir),
					y=sa.y+(sa.siz+1)*sin(fdir),
					vx=3*cos(fdir),
					vy=3*sin(fdir),
					dir=fdir,
					spd=3,
					lif=30,
					typ=2,
					viz=true}
					add(bullets,b)
					sfx(5)
				end
				sa.col=true -- set collidable
				add(saucer_col,sa)
			else
				sa.col=false -- or not
			end
		end
	end
	
	-- move spaceworms
	for i=#spaceworms,1,-1 do
		local sw=spaceworms[i]
  --local di=dist_trig(sw,o_o)
  --sw.spd=.5+dist_trig(sw,o_o)/32 -- if far spd increase
		sw.x=sw.x+sw.spd*(cos(sw.dir))-p.vx
		sw.y=sw.y+sw.spd*(sin(sw.dir))-p.vy
  
		sw.rot=sw.dir--+0.1*sin(t()/2)
  
  -- based on rope simulator by tobias gurdan
  -- https://x.com/tbsgrdn/status/1686014149971554304
  sw.sdir[1]=norm_ang(sw.dir)
  sw.shpx[1]=sw.x+64
  sw.shpy[1]=sw.y+64
		for j=1,sw.lth-1 do -- tail
  	local sx1=sw.shpx[j]
   local sy1=sw.shpy[j]
  	local sx2=sw.shpx[j+1]
   local sy2=sw.shpy[j+1]
   local sx=sx2-sx1
   local sy=sy2-sy1
			local sl=sqrt(sx*sx+sy*sy)
   local ss=.5/sl*(sw.siz*.8-sl)
   sx2+=sx*ss
   sy2+=sy*ss
   sw.shpx[j+1]=sx2-p.vx
   sw.shpy[j+1]=sy2-p.vy
   local sd=sw.sdir[j]-sw.sdir[j+1]
   if sd>.5 then sd-=1 elseif sd<-.5 then sd+=1 end
   if sd>0.05 then
   	sw.sdir[j+1]+=0.025
   elseif sd<-0.05 then
   	sw.sdir[j+1]-=0.025
   else
   	sw.sdir[j+1]=sw.sdir[j]
   end
   sw.sdir[j+1]=norm_ang(sw.sdir[j+1])
  end
  
		sw.tim=(sw.tim-1)%50 -- iq
  local di=norm_ang(atan2(sw.x,sw.y)-sw.dir)
		if p.viz then
			if sw.tim<sw.iqt then -- ingame
  	 if di>.5 then sw.dir+=.01 else sw.dir-=.01 end
			end
		else
  	if sw.tim%2==0 then -- player dead
  	 if di>.5 then sw.dir+=.01 else sw.dir-=.01 end
   end
   sw.dir=norm_ang(sw.dir)
   sw.rot=sw.dir
  end
	end

	-- move bosses
	for b in all(bosses) do
		b.drot=.07*sin(b.a*t())+.05*sin(b.b*t())
		b.rot=b.rot+0.1*b.drot
		b.vx=b.spd*cos(b.dir)
		b.vy=b.spd*sin(b.dir)
		b.x+=b.vx-p.vx
		b.y+=b.vy-p.vy
		wrap_obj(b)
  b.tim=(b.tim-1)%50
  if b.tim<b.iqt then
 	 if p.viz then
  		local di=norm_ang(atan2(b.x,b.y)-b.dir)
  	 if di>.5 then b.dir+=.01 else b.dir-=.01 end
  	 b.dir=norm_ang(b.dir)
  	end
  end
	end
	
	-- move trimissiles
	for i=#trimis,1,-1 do
	local tr=trimis[i]
		tr.lif-=1
		tr.x=tr.x+tr.spd*(cos(tr.dir))-p.vx
		tr.y=tr.y+tr.spd*(sin(tr.dir))-p.vy
		tr.rot=tr.dir
		wrap_obj(tr)
		if p.viz then
			local ang=norm_ang(atan2(tr.x,tr.y)-tr.dir)
			if ang>0.5 then tr.dir+=.01 else tr.dir-=.01 end
		end
		if tr.lif<0 then
			explosion(tr.siz,tr.x,tr.y,0)
			del(trimis,tr)
			sfx(3)
		end
	end
	
	-- move powerups
	for i=#powerups,1,-1 do
		local po=powerups[i]
		po.rot+=0.01
		po.x+=.5*sin(po.ang)-p.vx
		po.y+=.5*cos(po.ang)-p.vy
		wrap_obj(po)
		po.lif-=1
		if po.lif<50 then po.siz=6-2*(cos(t()*2)) end
		if po.lif<0 then del(powerups,po) end
	end
	
	-- collide player
	-- player with asteroids
	for i=#aster_col,1,-1 do
		local a=aster_col[i]
		local di=dist_trig(a,o_o)
		if p.viz and di<a.siz then
				player_death()
		end
	end
	-- player with saucers
	for i=#saucer_col,1,-1 do
		local sa=saucer_col[i]
		local di=dist_trig(sa,o_o)
		if di<sa.siz then
			player_death()
		end
	end
	-- player with spaceworms
	for i=#spaceworms,1,-1 do
		local sw=spaceworms[i]
		local di=dist_trig(sw,o_o)
		if di<sw.siz and p.viz then
			player_death()
		end
	end
 -- player with bosses
	for i=#bosses,1,-1 do
		local bo=bosses[i]
		local di=dist_trig(bo,o_o)
		if di<bo.siz and p.viz then
			player_death()
		end
	end
	-- player with trimis
	for i=#trimis,1,-1 do
		local tr=trimis[i]
		local di=dist_trig(tr,o_o)
		if di<tr.siz and p.viz then
			if p.shd>0 then
				p.shd-=1
			else
				player_death()
			end
			del(trimis,tr)
		end
	end
	-- player with powerups
	for i=#powerups,1,-1 do
		local po=powerups[i]
		local di=dist_trig(po,o_o)
		if di<po.siz and p.viz then
			p.pow=po.typ
			p.pot=500
			if p.pow==1 then p.lif+=1 p.pow=0 end
			if p.pow==4 then p.shd+=1 p.pow=0 end
			del(powerups,po)
			sfx(6)
		end
	end
	
	-- collide bullets
	for i=#bullets,1,-1 do
		-- bullets with player
		local b=bullets[i]
		local di=dist_trig(b,o_o)
		if di<p.siz then
			if p.shd>0 then
				p.shd-=1
			else
				player_death()
			end
			del(bullets,b)
		end
		-- bullets with asteroids
		for j=#aster_col,1,-1 do
			local a=aster_col[j]
			di=dist_trig(b,a)
			if di<a.siz then
				if flr(a.siz)!=16 and flr(a.siz)!=32 then
					a.siz-=1
				end
				for k=1,10 do
					local part={x=b.x+b.spd*cos(b.dir),y=b.y+b.spd*sin(b.dir),dir=b.dir+.5+rnd(.2)-rnd(.2),spd=.5+rnd(.5),lif=5+rnd(5)}
					add(particules,part)
				end
				sfx(2)
				del(bullets,b)
			end
			
			if flr(a.siz)==32 then -- large asteroid
				spawn_asteroid(a.x,a.y,a.rot,a.siz-1)
				spawn_asteroid(a.x,a.y,a.rot,a.siz-1)
				explosion(4*a.siz,a.x,a.y,a.siz)
				p.sco+=0x.0014 p.ext+=20 -- score +20
				if extended then
					if rnd(100)<75 then
						spawn_powerup(a.x,a.y,rnd(),6,1+flr(rnd(6)))
					end
     if rnd(100)<50 then
     	if rnd(100)<50 then
      	spawn_spaceworm(a.x,a.y,8,4+p.lvl)
						else
      	spawn_boss(a.x,a.y,12,2+flr(rnd(p.lvl)),1+p.lvl,rnd(),rnd())
      end
     end
				end
				del(aster_col,a)
				del(asteroids,a)
				sfx(3)
			end
			
			if flr(a.siz)==16 then -- medium asteroid
				spawn_asteroid(a.x,a.y,a.rot,a.siz-1)
				spawn_asteroid(a.x,a.y,a.rot,a.siz-1)
				spawn_asteroid(a.x,a.y,a.rot,a.siz-1)
				explosion(4*a.siz,a.x,a.y,a.siz)
				p.sco+=0x.0032 p.ext+=50 -- score +50
				if extended then
					if rnd(100)<50 then
						spawn_powerup(a.x,a.y,rnd(),6,1+flr(rnd(6)))
     end
     if rnd(100)<25 then
     	spawn_spaceworm(a.x,a.y,8,4+flr(p.lvl/2))
     end
				end
				del(asteroids,a)
				del(aster_col,a)
				sfx(3)
			end
			
			if a.siz<8 then -- small asteroid
				if extended then
					if rnd(100)<25 then
						spawn_powerup(a.x,a.y,rnd(),6,1+flr(rnd(6)))
					end
				end
				del(asteroids,a)
				del(aster_col,a)
				explosion(50,a.x,a.y,a.siz)
				p.sco+=0x.0064 p.ext+=100 -- score +100
				sfx(3)
			end
		end
		
		-- bullets with saucers
		for j=#saucer_col,1,-1 do
			local s=saucer_col[j]
			di=dist_trig(b,s)
			if di<s.siz then
				s.lif-=1
				explosion(10,b.x,b.y,0)
				del(bullets,b)
			end
			if s.lif==0 then
   	if s.siz>6 then
    	p.sco+=0x.00c8 p.ext+=200 -- big saucer
    else
    	p.sco+=0x.03e8 p.ext+=1000 -- small saucer
    end
				explosion(s.siz*50,s.x,s.y,0)
				sfx(3)
				del(saucers,s)
				del(saucer_col,s)
			end
		end
		
		--bullets with spaceworms
		for j=#spaceworms,1,-1 do
			local sw=spaceworms[j]
			di=dist_trig(b,sw)
			if di<sw.siz then
				sfx(3)
				del(bullets,b)
				if sw.lif<0 then
					explosion(sw.siz*10,sw.x,sw.y,sw.siz)
					del(spaceworms,sw)
     p.sco+=0x.07d0 p.ext+=2000
				else
     explosion(10,sw.x,sw.y,sw.siz)
					sw.lif-=1
     sw.lth-=1
				end
			end
		end
  
		--bullets with bosses
		for j=#bosses,1,-1 do
			local bo=bosses[j]
			di=dist_trig(b,bo)
			if di<bo.siz then
				if bo.lif<0 then
					explosion(bo.siz*10,bo.x,bo.y,bo.siz)
					del(bosses,bo)
     p.sco+=0x.1388 p.ext+=5000
				else
     explosion(10,b.x,b.y,0)
     spawn_trimis(bo.x,bo.y,bo.siz/3,rnd())
					bo.lif-=1
     --bo.ntri-=1
				end
				del(bullets,b)
				sfx(3)    
			end
   for k=1,bo.narm do
   	local a=bo.rot+k/bo.narm-0.2*bo.drot*bo.arm[k]+.5/bo.narm
   	local armx=bo.x+.5*(bo.arm[k]+1)*bo.siz*cos(a)
    local army=bo.y+.5*(bo.arm[k]+1)*bo.siz*sin(a)
    di=dist_trig(b,{x=armx,y=army})
    if di<.5*bo.siz then
    	bo.arm[k]-=1
     explosion(10,b.x,b.y,0)
     spawn_trimis(armx,army,bo.siz/3,rnd())
					bo.lif-=1
     del(bullets,b)
     sfx(3)
    end
   end
		end
		
		--bullets with trimis
		for j=#trimis,1,-1 do
			local tr=trimis[j]
			di=dist_trig(b,tr)
			if di<tr.siz then
				explosion(tr.siz,b.x,b.y,0)
				sfx(3)
				p.sco+=0x.000a p.ext+=10
				del(bullets,b)
				del(trimis,tr)
			end
		end
		
		-- saucers with asteroids on screen
		for j=#saucer_col,1,-1 do
			local sa=saucer_col[j]
			for k=#aster_col,1,-1 do
				local as=aster_col[k]
			 di=dist_trig(sa,as)
				if di<as.siz then
					explosion(20,sa.x,sa.y,0)
					del(saucers,sa)
					sfx(3)
				end
			end
		end
	end
	
	if state==0 then -- menu
		if wait==0 then state=5 wait=200 end
		if btnp(2) then menu_i=(menu_i-1)%3 end
		if btnp(3) then menu_i=(menu_i+1)%3 end
		if btnp(5) then -- play
			if menu_i==0 then
				state=2 -- start game
				p.viz=false p.rot=0.25 p.sco=0 p.ext=0 p.lvl=1 p.lif=3 p.pow=0 p.shd=0
				stars={}				
    asteroids={}
				saucers={}
				spaceworms={}
				trimis={}
				powerups={}
    bosses={}
				spawn_stars(max(roomx,roomy))
				spawn_asteroids(2,10+flr(rnd(amax-10)))
				spawn_asteroids(1,56)
				--spawn_spaceworm(0,0,10,2)
				wait=50
			elseif menu_i==1 then
				state=3 -- options
				menu_i=1
			elseif menu_i==2 then
				state=4 -- credits
			end
		end
		
	elseif state==1 then -- ingame
		if wait==0 then p.viz=true end
		if p.pot>0 then p.pot-=1 end
		if p.pot==0 then p.pow=0 end
		local na=count(asteroids)
		-- spawn saucers if few asteroids left
		if na<3 and count(saucers)<min(1+p.lvl\5,5) then
			spawn_saucer(4+flr(rnd(5)))
		end
		-- next level
		if na==0 then
			-- change roomsize, add boss, etc...
			p.lvl+=1
			local rz=max(roomx,roomy)
			roomx=min(128+4*p.lvl,2048)
			roomy=min(128+4*p.lvl,2048)
			spawn_stars(max(roomx,roomy)-rz) -- add more stars
			spawn_asteroids(flr(p.lvl/2),33+flr(rnd(amax-33)))
			spawn_asteroids(p.lvl,17+flr(rnd(15)))
			spawn_asteroids(2*p.lvl,10+flr(rnd(5)))
			wait=100
		end
		-- extra life
		if p.ext>10000 and p.lif<=10 then p.ext=0 p.lif+=1 sfx(4) else p.ext=0 end
		
	elseif state==2 then -- death
		p.vx=.95*p.vx p.vy=.95*p.vy -- brake fx
		-- game over
		if p.lif==0 then
			if p.sco>highscore[10].s then wait=30 state=6 end
			if wait==0 then state=0 end
		-- next life or start
		elseif btnp(5) and wait==0 then
			p.viz=true
			state=1
			sfx(6)
		end
		
	elseif state==3 then -- options
		if btnp(2) then menu_i=(menu_i-1)%3 end
		if btnp(3) then menu_i=(menu_i+1)%3 end
		if btnp(5) then state=0 menu_i=1 end
		if menu_i==1 then -- colors
			if btnp(0) then pal_i=(pal_i-1)%#palet end
			if btnp(1) then pal_i=(pal_i+1)%#palet end
			for i=0,7 do
				pal(i,palet[pal_i+1][i],1)
			end
		elseif menu_i==2 then -- music
			if btnp(0) or btnp(1) then
				play_music = not play_music end
		elseif menu_i==0 then
			if btnp(1) then gamemode=(gamemode+1)%2 end
			if btnp(0) then gamemode=(gamemode-1)%2 end
		end
		if gamemode==0 then extended=false else extended=true end
	elseif state==4 then -- credits
		if btnp(5) then state=0 end
		
	elseif state==5 then -- highscore
		if btnp(5) or wait==0 then wait=400 state=0 end
		
	elseif state==6 then -- highscore entry
		if wait==0 then
			if btnp(0) then pos=(pos-1)%3 let=p.nam[pos+1]-97 end
			if btnp(1) then pos=(pos+1)%3 let=p.nam[pos+1]-97 end
			if btnp(2) then let=(let+1)%26 end
			if btnp(3) then let=(let-1)%26 end
			p.nam[pos+1]=97+let
			if btnp(5) then
				highscore[10].s=p.sco
				highscore[10].n=chr(p.nam[1],p.nam[2],p.nam[3])
				for i=9,1,-1 do
					if p.sco>highscore[i].s do
						local nh=highscore[i+1].n
						local sh=highscore[i+1].s
						highscore[i+1].n=highscore[i].n
						highscore[i+1].s=highscore[i].s
						highscore[i].n=nh
						highscore[i].s=sh
					end
				end
    save_highscore() -- update highscore cartdata
				state=0
			end
		end
	end
end

---------- drawing --------------------------------------------------------------------------------------

function _draw()
	cls(0)
	if minimap then -- draw minimap
		local zoom=min(64/roomx,64/roomy)
		--if roomy>roomx then zoom=64/roomy end
		for i=1,#stars,10 do
			pset(64+stars[i].x*zoom,64+stars[i].y*zoom)
		end
		if p.viz then draw_player(64,64,p.rot,p.siz*zoom) end
		for as in all(asteroids) do
			draw_asteroid(64+as.x*zoom,64+as.y*zoom,as.rot,as.siz*zoom,as.shp)
		end
		for sa in all(saucers) do
			draw_saucer(64+sa.x*zoom,64+sa.y*zoom,0,sa.siz*zoom)
		end
		for bu in all(bullets) do
  	local di=dist_trig(bu,o_o)
   if di<96 then pset(64+bu.x*zoom,64+bu.y*zoom) end
		end
		for sw in all(spaceworms) do
			draw_obj(64+sw.x*zoom,64+sw.y*zoom,sw.rot,sw.siz*zoom,object[8])
 		for i=2,sw.lth do
 			draw_poly((64+sw.shpx[i])*zoom,(64+sw.shpy[i])*zoom,sw.sdir[i],.8*sw.siz*zoom,3)
 		end
		end
		for bo in all(bosses) do
			draw_poly(64+bo.x*zoom,64+bo.y*zoom,bo.rot,bo.siz*zoom,bo.narm)
		end
		for tr in all(trimis) do
			draw_tri(64+tr.x*zoom,64+tr.y*zoom,tr.rot,tr.siz*zoom)
		end
  local cul=64-64*zoom
  local cur=64+64*zoom-1
  line(cul,cul,cul+4,cul)
		line(cul,cul,cul,cul+4)
		line(cul,cur,cul+4,cur)
  line(cul,cur,cul,cur-4)
  line(cur,cul,cur-4,cul)
  line(cur,cul,cur,cul+4)
  line(cur,cur,cur-4,cur)
  line(cur,cur,cur,cur-4)
	else -- draw game
		
		-- draw stars
		for s in all (stars) do
			pset(64+s.x,64+s.y,1)
		end
		
		-- draw particules
		for pa in all(particules) do
			pset(64+pa.x,64+pa.y,1)
		end
		
		-- draw bullets
		for b in all(bullets) do
			if b.typ>1 then 
				circ(64+b.x,64+b.y,b.typ-1)
			else
				line(64+b.x,64+b.y,64+b.x-.3*b.vx,64+b.y-.3*b.vy)
			end
		end
		
		-- draw player
		if p.viz then
			draw_player(64,64,p.rot,p.siz)
			if p.shd>0 then
				for i=1,p.shd do
					local step=15+3*i--2.618*i
					for j=0,step do
						pset(64+1.25*(p.siz+i)*cos(j/step+p.rot), 64+1.25*(p.siz+i)*sin(j/step+p.rot) )
					end
				end
			end
			--line(64,64,64+10*cos(p.rot),64+10*sin(p.rot),8)
			--line(64,64,64+10*cos(p.dir),64+10*sin(p.dir),10)
		end
		
		-- draw asteroids
		for as in all(asteroids) do
			draw_asteroid(64+as.x,64+as.y,as.rot,as.siz,as.shp)
			--if as.col==true then
				--line(64,64,64+as.x,64+as.y)
				--circ(64+as.x,64+as.y,as.siz,1)
			--end
		end
		
		-- draw saucers
		for sa in all(saucers) do
			draw_saucer(64+sa.x,64+sa.y,0,sa.siz)
			--circ(64+s.x,64+s.y,4*s.siz)
		end
		
		-- draw spaceworms
		for sw in all(spaceworms) do
  	draw_spaceworm(64+sw.x,64+sw.y,sw.rot,sw.siz,sw.lth,sw.shpx,sw.shpy,sw.sdir)
		end
		
		-- draw bosses
		for bo in all(bosses) do
			draw_boss(64+bo.x,64+bo.y,bo.rot,bo.siz,bo.narm,bo.ntri,bo.drot,bo.arm)
		end
		
		-- draw tri missiles
		for tr in all(trimis) do
			draw_tri(64+tr.x,64+tr.y,tr.rot,tr.siz)
		end
		
		-- draw powerups
		for po in all(powerups) do
			draw_powerup(64+po.x,64+po.y,po.rot,po.siz,po.typ)
		end
		
		-- draw gui
		
		if state==0 then -- menu
			local xr=rnd(2)-1
			local yr=rnd(2)-1
			if menu_i==0 then draw_text("play",47+xr,50+yr) else draw_text("play",47,50) end
			if menu_i==1 then draw_text("options",38+xr,62+yr) else draw_text("options",38,62) end
			if menu_i==2 then draw_text("credits",38+xr,74+yr) else draw_text("credits",38,74) end
			
		elseif state==1 then -- game
			if wait>0 then draw_text("level "..tostr(p.lvl),38,24) end
			
		elseif state==2 then -- death
			if wait>0 then
				if p.lif>0 then
					draw_text("level "..tostr(p.lvl),38,26)
					if wait<30 then
						for i=1,p.lif do
							draw_player(64,64,p.rot,6*i*wait)
						end
					end
				else
					draw_text("game over",31,26)
				end
			else
				draw_player(64,64,p.rot,4+2*sin(5*t()))
			end
			
		elseif state==3 then -- options
			local xr=rnd(2)-1
			local yr=rnd(2)-1
			if menu_i==1 then draw_text("colors",40+xr,50+yr) else draw_text("colors",40,50) end
			if menu_i==2 then draw_text("music",43+xr,62+yr) else draw_text("music",43,62) end
			if menu_i==0 then draw_text("game mode",32+xr,74+yr) else draw_text("game mode",32,74) end
			if gamemode==0 then
				draw_text("classic",38,86)
			else
				draw_text("extended",34,86)
			end
			spr(48,49,98,4,1)
			
		elseif state==4 then -- credits
			draw_text("thanks to ed logg",5,40)
			draw_text("for asteroids 1979",2,48)
			draw_text("thanks to zep",19,58)
			draw_text("for pico-8",28,66)
			draw_text("thanks to luchak",10,76)
			draw_text("for acid jam",22,84)
			draw_text("thanks to shy",19,94)
			draw_text("for aa-conv",25,102)
			
		elseif state==5 then -- highscore
			draw_highscore()
			draw_text("@ syntax inc",22,116)
			 
		elseif state==6 then -- highscore entry
			draw_text("level "..tostr(p.lvl),36,34)
			draw_text("enter your name",14,88)
			spr(48,49,98,4,1)
			draw_text(tostr(p.sco,2),64,60)
			draw_text(chr(p.nam[1],p.nam[2],p.nam[3]),32,60)
			line(38+6*pos,72,38+6*pos+6,72)
		end
			 
		if state==0 or state==3 or state==4 then
			local tfx=t()*.2
			draw_axteroids_text(64,26,0.5+.22*sin(tfx),1.5*tfx,text)
			draw_text("@ syntax inc",22,116)
		end
			
		if state==1 or state==2 then
			local scotxt=tostr(p.sco,2)
			draw_text(scotxt,59-4*#scotxt,2)
			draw_text(tostr(count(asteroids)),100,116)
			for i=1,p.lif-1 do
				spr(39,2+10*(i-1),116)
			end
			if state==2 then spr(39,2+10*(p.lif-1),116) end
		end
	end
	conv_aa()
	
end

------------- functions --------

text=split'-88,8,-88,0,-88,0,-80,-8,-80,-8,-72,0,-72,0,-72,8,-88,2,-72,2,-68,-8,-52,8,-68,8,-52,-8,-48,-8,-32,-8,-40,-8,-40,8,-28,-8,-12,-8,-28,-8,-28,8,-28,0,-14,0,-28,8,-12,8,-8,-8,-8,8,-8,-8,8,-8,8,-8,8,0,-8,0,8,0,-8,0,8,8,12,-8,28,-8,12,-8,12,8,28,-8,28,8,12,8,28,8,32,-8,48,-8,32,8,48,8,40,-8,40,8,52,-8,52,8,52,-8,60,-8,60,-8,68,-4,68,-4,68,4,68,4,60,8,60,8,52,8,72,-8,88,-8,72,-8,72,0,72,0,88,0,88,0,88,8,88,8,72,8'

function draw_axteroids_text(x,y,s,a,txt)
	local n=count(txt)
	for i=1,n,4 do
		local x1=s*txt[i]*sin(a)
		local y1=s*txt[i+1]
		local x2=s*txt[i+2]*sin(a)
		local y2=s*txt[i+3]
		line(x+x1,y+y1,x+x2,y+y2,1)
	end
end

function draw_text(txt,x,y)
	for i=1,#txt do
		local ll=ord(txt,i)
		local lt=0
		if ll==32 then lt=37 end
		if ll==45 then lt=38 end
		if ll==64 then lt=40 end
		if ll>96 and ll<123 then lt=ll-96 end
		if ll>47 and ll<58 then lt=ll-21 end
		spr(lt,x+6*i,y)
	end
end

function draw_obj(x,y,rot,siz,obj)
	for i=1,#obj-2,2 do
		local x1=x+siz*abs(obj[i])*cos(obj[i+1]+rot)
		local y1=y+siz*abs(obj[i])*sin(obj[i+1]+rot)
		local x2=x+siz*abs(obj[i+2])*cos(obj[i+3]+rot)
		local y2=y+siz*abs(obj[i+2])*sin(obj[i+3]+rot)
		if obj[i+2]>=0 then line(x1,y1,x2,y2) end
	end
end

object={ -- radius,angle,... minus means don't draw
split'1,0, 1,.38, .5,.5, 1,.62, 1,0', -- 1 player ship
split'.5,.12, .5,.44, -.5,.88, .5,.56', -- 2 double shot
split'.5,.18, .5,.38, -.5,0, .5,.5, -.5,.82, .5,.62', -- 3 triple shot
split'.6,0, .6,.1, .6,.2, .6,.3, .6,.4, .6,.5, .6,.6, .6,.7, .6,.8, .6,.9, .6,0', -- 4 shield
split'.8,0, .4,.1, .8,.2, .4,.3, .8,.4, .4,.5, .8,.6, .4,.7, .8,.8, .4,.9, .8,0', -- 5 blast star
split'1.42,.25, 1.42,.75, 1,.85, 1,.15, 1.42,.25, 1.024,.35, 1.024,.65, 1.42,.75, -.88,.87, 1,.95, 1,.05, .88,.13, -.88,.37, 1,.45, 1,.55, .88,.63', -- saucer
split'1.4,0, 1.4,.3, .8,.30, 1.4,.38, .7,.40, 1.4,.5, .7,.6, 1.4,.62, .8,.7, 1.4,.70, 1.4,0', -- 7 sw head
split'1,0, 1,.333, 1,.666, 1,0', -- 8 triangle
split'1,0, 1,.38, .5,.42, 1,.5, .5,.56, 1,.62, 1,0', -- 9 other ship
split'.3,.33, .8,.33, -.3,0, .8,0, -.3,.66, .8,.66', -- 10 triple shot omni
split'1,0, .6,.25, 1,.5, .6,.75, 1,0', -- 11 sw tail
split'1,0, 1,.2, 1,.4, 1,.6, 1,.8, 1,0' -- 12 pentagon
}

function draw_highscore()
	for h=1,10 do
		draw_text(highscore[h].n,36,10+10*(h-1))
		draw_text(tostr(highscore[h].s,2),62,10+10*(h-1))
	end
end

function draw_poly(x,y,rot,siz,n)
		for i=1,n do
			line(x+.5*siz*cos(rot+i/n),y+.5*siz*sin(rot+i/n),x+siz*cos(rot+i/n+.5/n),y+siz*sin(rot+i/n+.5/n))
			line(x+.5*siz*cos(rot+i/n+1/n),y+.5*siz*sin(rot+i/n+1/n),x+siz*cos(rot+i/n+.5/n),y+siz*sin(rot+i/n+.5/n))
		end
end

function draw_tri(x,y,r,s)
	draw_obj(x,y,r,s,object[8])
end

function draw_player(x,y,r,s)
	draw_obj(x,y,r,s,object[1])
end

function draw_asteroid(x,y,r,s,shp)
	draw_obj(x,y,r,s,shp)
end

function draw_saucer(x,y,r,s)
	draw_obj(x,y,r+.25,s,object[6])
end

function draw_boss(x,y,rot,siz,narm,ntri,drot,arm)
	draw_poly(x,y,rot,siz,narm)
	local npol=3
 local d=1/narm
	for i=1,narm do
 	for j=1,arm[i] do
	 	if j==arm[i] then npol=narm else npol=3 end
  	local a=rot+d*i-0.2*drot*j+d/2
			draw_poly(x+.5*(j+1)*siz*cos(a),y+.5*(j+1)*siz*sin(a),a+.5-0.2*drot*j,siz/2,npol)
  end
 end
end

function draw_spaceworm(x,y,r,s,l,shpx,shpy,sdir)
	draw_obj(x,y,r,s,object[8])
 local n=8
 for i=2,l do
 	if i==l then n=11 end
		draw_obj(shpx[i],shpy[i],sdir[i],.8*s,object[n])
 	--draw_poly(shpx[i],shpy[i],sdir[i],.8*s,n)
 end
	--draw_obj(shpx[l],shpy[l],sdir[l],.8*s,object[11])
end

function draw_powerup(x,y,rot,siz,typ)
	circ(x,y,siz)
	if typ==1 then -- +1 life
		draw_obj(x,y,rot,siz-2,object[1])
	elseif typ==2 then -- double shot
		draw_obj(x,y,rot,siz,object[2])
	elseif typ==3 then -- triple shot
		draw_obj(x,y,rot,siz,object[3])
	elseif typ==4 then -- shield
		draw_obj(x,y,rot,siz+1,object[4])
	elseif typ==5 then -- blast
		draw_obj(x,y,rot,siz-1,object[5])
	elseif typ==6 then -- triple omni
		draw_obj(x,y,rot,siz-2,object[10])
	end
end


function spawn_powerup(x,y,rot,siz,typ)
	local pu={
		x=x,
		y=y,
		rot=rot,
		siz=siz,
		typ=typ,
		ang=rnd(),
		lif=300
		}
		if pu.typ==1 and p.lif>9 then pu.typ=2 end
		if pu.typ==4 and p.shd>4 then pu.typ=3 end
	add(powerups,pu)
end

function spawn_stars(n)
	for i=1,n do
		add(stars,{x=rnd(2*roomx)-roomx,y=rnd(2*roomy)-roomy,z=1-.25*rnd(1)})
	end
end

function spawn_asteroid(x,y,rot,siz)
	
		local a={
		x=x,
		y=y,
		dx=0,
		dy=0,
		rot=rot,
		drot=.01-rnd(.02),
		dir=rnd(1),
		spd=0.1+rnd(.5),
		siz=siz,
		col=true,
		shp={}
		}
		
		local sides=min(flr(a.siz/2),18)
		local first=1+abump*(rnd(2)-1)*sqrt(a.siz)/a.siz
		add(a.shp,first)
		add(a.shp,0)
		for j=1,sides-1 do
			add(a.shp,1+abump*(rnd(2)-1)*sqrt(a.siz)/a.siz )
			add(a.shp,j/sides)
		end
		add(a.shp,first)
		add(a.shp,0)
		
		add(asteroids,a)
end

function spawn_asteroids(n,siz)
	for i=1,n do
		local a={x=rnd(2*roomx)-roomx,y=rnd(2*roomy)-roomy,rot=rnd(1),siz=siz}
		while dist_trig(a,o_o)<3*a.siz do
			a.x=rnd(2*roomx)-roomx
			a.y=rnd(2*roomy)-roomy
		end
		spawn_asteroid(a.x,a.y,a.rot,a.siz)
	end
end

function spawn_saucer(si)
	local s={
		x=rnd(2*roomx)-roomx,
		y=rnd(2*roomy)-roomy,
		siz=si,
		dir=rnd(1),
		spd=.5+rnd(1),
		lif=5,
		tim=50,
		iqt=10,
		fir=30,
		col=true
		}
	while dist_trig(s,o_o)<96 do
		s.x=rnd(roomx)
		s.y=rnd(roomy)
	end
	s.lif=flr(s.siz)
	add(saucers,s)
end

function spawn_boss(x,y,siz,narm,ntri,a,b)
-- x, y, size ,nbr_arms, nbr_tri, angle a, angle b
	local bo={
		x=x,
		y=y,
		siz=siz,
		narm=narm,
		ntri=ntri,
		a=a,
		b=b,
		dir=rnd(1),
		rot=rnd(1),
		drot=rnd(.02)-.01,
		spd=0.5+rnd(.4),
		lif=narm*ntri,
		tim=50,
		iqt=10,
		fir=30,
		col=true,
  arm={}
		}
	--while dist_trig(bo,o_o)<96 do
		--bo.x=rnd(2*roomx)-roomx
		--bo.y=rnd(2*roomy)-roomy
	--end
	for i=1,narm do
 	add(bo.arm,ntri)
 end
	add(bosses,bo)
end

function spawn_spaceworm(x,y,siz,lth)
	local sw={
 x=x,
 y=y,
 rot=rnd(1),
 drot=rnd(.02)-.01,
 siz=siz,
 dir=rnd(1),
	spd=0.8+rnd(.4),
 lth=lth,
 lif=lth,
 tim=50,
 iqt=50,
 col=true,
 sdir={},
 shpx={},
 shpy={}
 }
 sw.rot=sw.dir
 for i=sw.lth,1,-1 do
 	add(sw.sdir,sin(2*i/sw.lth))
 	add(sw.shpx,64+sw.x+2*i*cos(2*i/sw.lth))
 	add(sw.shpy,64+sw.y+2*i*sin(2*i/sw.lth))
 end
	add(spaceworms,sw)
end


function spawn_trimis(x,y,s,r)
	local tr={
		x=x,
		y=y,
		siz=s,
		dir=rnd(1),
		spd=1.5,
		rot=r,
  lif=200
		}
		add(trimis,tr)
end

--shoot(x,y,vx,vy,dir,siz,typ)
function shoot(x,y,vx,vy,dir,siz,typ)
	local b={
	x=siz*cos(dir),
	y=siz*sin(dir),
	vx=vx+siz*cos(dir),
	vy=vy+siz*sin(dir),
	dir=dir,
	spd=1+siz, -- usefull ?
	lif=30,
	typ=typ,
	viz=true
 }
	add(bullets,b)
end

function newshoot(x,y,dir,spd,siz,typ)
	local b={
	x=siz*cos(dir),
	y=siz*sin(dir),
	--vx=vx+siz*cos(dir),
	--vy=vy+siz*sin(dir),
	dir=dir,
	spd=spd, -- usefull ?
	lif=30,
	typ=typ,
	viz=true
 }
	add(bullets,b)
end

function explosion(n,x,y,s)
	for i=1,n do
		local d=rnd()
		local pa={x=x+s*cos(d),y=y+s*sin(d),dir=d,spd=.1+rnd(.9),lif=25+rnd(15)}
		add(particules,pa)
	end
end

function player_death()
	p.viz=false p.acc=0 p.lif-=1 p.pow=0 p.shd=0
	if minimap then minimap = not minimap end
	explosion(250,0,0,0)
	sfx(3)
	state=2
	wait=100
end

function wrap_obj(o)
	if o.x>roomx then o.x-=2*roomx end
	if o.x<-roomx then o.x+=2*roomx end
	if o.y>roomy then o.y-=2*roomy end
	if o.y<-roomy then o.y+=2*roomy end
end
 
function save_highscore()
 for i=1,10 do
 	dset(4*i,ord(highscore[i].n,1)) -- 3 letters
 	dset(4*i+1,ord(highscore[i].n,2))
 	dset(4*i+2,ord(highscore[i].n,3))
 	dset(4*i+3,highscore[i].s) -- hexa score
 end
end
 
function load_highscore()
 highscore={}
 for i=1,10 do
 	local nam=chr(dget(4*i))..chr(dget(4*i+1))..chr(dget(4*i+2))
		local sc=dget(4*i+3)
		add(highscore,{n=nam,s=sc})
 end
end

function update_palet(pa)
	for i=1,7 do
		pal(i,palet[pa][i],1)
	end
end

function norm_ang(a)
	while a>=1 do a-=1 end
	while a<0 do a+=1 end
	return a
end

function dist_trig(a,b) -- thanks to drakeblue
	local x,y=abs(b.x-a.x),abs(b.y-a.y)
	if x<y then x,y=y,x end
	return x/sin(atan2(y,x))
end -- https://www.lexaloffle.com/bbs/?tid=49827

function acid() -- thanks to luchak
	for i=0,min(511-stat(108),187) do
		if(acid_g%646<1) then acid_q=rnd({1,1.8,2,2.1})<<9 acid_e=.3+.1*sin(t()/6) end
		if(acid_g<1) then acid_k=62 acid_g=2584 end
		acid_k*=.999
		acid_e*=.996
		acid_g-=1
		acid_o=acid_p>>11
		acid_o-=16*(acid_y-acid_o)
		acid_x+=acid_e*(acid_o-acid_x)
		acid_y+=acid_e*(acid_x-acid_y)
		acid_v=acid_y+sin((acid_g>>10)^3)*acid_k+64
		poke(0,acid_v+64)
		serial(2056,0,1)
		acid_p+=acid_q
	end
end -- https://www.lexaloffle.com/bbs/?tid=48186

function conv_aa() -- anti-alias thanks to shy
	memcpy(0x9000,0x6000,0x2000)
	for j=0x9000,0xafff,64 do
		local b,c=0,$j
		for i=j+4,j+60,4 do
			local n=$i
			poke4(i-0x3004,
			$(i-68)+$(i+60)+c*0x13.1+
			(n<<28)+(b>>>28))
			b=c
			c=n
		end
		poke4(j-0x2fc4,
		$(j-4)+$(j+124)+c*0x13.1+
		(b>>>28))
	end
end -- https://www.lexaloffle.com/bbs/?tid=46044

-- great article about asteroids creation
-- https://arcadeblogger.com/2018/10/24/atari-asteroids-creating-a-vector-arcade-classic/

__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00100100000100000111100001111100011110000111110001111100011111000100010001111100000001000100010001000000010001000100010001111100
00011000001010000100010001000000010001000100000001000000010000000100010000010000000001000101100001000000011011000110010001000100
00011000010001000111100001000000010001000111000001111100010011000111110000010000010001000110000001000000010101000101010001000100
00100100011111000100010001000000010001000100000001000000010001000100010000010000001001000101100001000000010001000100110001000100
00000000010001000111100001111100011110000111110001000000011111000100010001111100000111000100010001111100010001000100010001111100
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01111100011111000111110001111100011111000100010001000100010001000100010001000100011111000111110000010000011111000111110001000100
01000100010001000100010001000000000100000100010001000100010001000010100000101000000010000100010000010000000001000000010001000100
01111100010001000111110001111100000100000100010000101000010101000001000000010000000100000100010000010000011111000111110001111100
01000000010010000100100000000100000100000100010000101000011011000010100000010000001000000100010000010000010000000000010000000100
01000000011101000100010001111100000100000111110000010000010001000100010000010000011111000111110000010000011111000111110000000100
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000100000011111000010000000000000000000000000000000000000000000000000000
01111100011111000111110001111100011111000000000000000000001010000100000101111100000000000000000000000000000000000000000000000000
01000000010000000000010001000100010001000000000000000000001010000101110101010000000000000000000000000000000000000000000000000000
01111100011111000000010001111100011111000000000000111000010001000101000101111100000000000000000000000000000000000000000000000000
00000100010001000000010001000100000001000000000000000000010001000101110100010100000000000000000000000000000000000000000000000000
01111100011111000000010001111100000001000000000000000000101110100100000101111100000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000110001100011111000010000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00100000001110000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000000010101000001000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
11111110000100000001000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000000000100000101010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00100000000100000011100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000555665000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00055556556550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00555555665555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
05565555555555500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
05656555665556500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55656556556565650000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
56656556556556550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
56565555665555550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
56555555555665550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55655555556556550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
56565555555665550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
06565566665555500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
05655655556555500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00555655556555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00055566665550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
00000000000000000000000000000000000000000000000000000000000000000000000005000005050500505055050555555555555555565655656565656656
00000000000000000000000000000000000000000000000000000000000000000000005000005000000050050505505505555555555556555565565656565665
00000000000000000000000000000000000000000000000000000000000000000000000000000005050500505050550555050555555555556555656556565656
00000000000000000000000000000000000000000000000000000000000000000000000000050000000050500505055505555555555555555565565656565656
00000000000000000000000000000000000000000000000000000000000000000000000005000500505005005505050505555555555555556556555565565656
00000000000000000000000000000000000000000000000000000000000000000000000000000000000050500050505550505055555555555555565556565656
00000000000000000000000000000000000000000000000000000000000000000000000000000005005000050505050505555555055555555556556565556565
00000000000000000000000000000000000000000000000000000000000000000000000005005000050050005050505050505555555555555555555556556556
00000000005000000050000000005005555555555550055555555555500555555555555005555555555550555555555555055555555555555555555555555565
00000000057500000565000000056556777777777765577777777777655777777777777557777777777775567777777776557777775555555777777777776556
00000000575750000057500000575005555676555550576555555555505765555555567557655555555675055556765555557655557755555765555555555555
00000005750575000005750005750000000575000000575000000000005750000000057557500005055575500005750555057550555577555755555555655656
00000057500057500000575057500000000575000000575000000000005750000000057557550000000575050055750505057555505555755755555565556555
00000575000005750000057675000000000575000000576555555550005765555555567557500050050575000505750505057505055055755765555555555666
00005765555555675000006760000000000575000000577777777765005777777777777557500000000575050055750500557555505505755777777777777566
00005777777777775000057675000000000575000000576555555550005767755555555057500050000575000005755055057505055055755555555555567555
00005765555555675000575057500000000575000000575000000000005755577550000057500000500575050505750000057505505555755555505000557500
00005750000000575005750005750000000575000000575000000000005750055775500057500500005575000005755050557550555577550555000000057500
00005750000000575057500000575000000575000000576555555555505750000557755057655555555675055556765555057655557755055555555555567500
00005650000000565565000000056500000565000000577777777777655650000005576557777777777775567777777776557777775550555677777777777505
00000500000000050050000000005000000050000000055555555555500500000000055005555555555555055555555555055555550505505555555555555000
00000000000000000000000000000000000000000050000000000000000000000000000000005005005000050000000050500500505050550500000000000000
00000000000000000000000000000000000000050000000000000000000000000000000000000000000050000500505000050505050505505500000000000000
00000000000000000000000000000000005000000000000000000000000000000000000000000000000000050000000050500050505050550500000000000000
00000000000000000000000000000000000000500500000000000000000000000000000000000005000000000005005000005050500505055500000000000000
00000000000000000000000005000005000500000000000000000000000000000000000000000000000500050000000050050050050505055000000000000000
00000000000000000000000000000500050005005000500000000000000000000000000000000000000000000005005005000500505050505500000000000000
00000000000000000000000000000005000500500005660000000000000000000000000000000000050000000000000000050505005050500500000000000000
00000000000000000000050000500500005050000500665000000000000000000000000000000000000005005005005005000000505005005050000000000000
00000000000000000050000050005005050005050000066000000000000000000000000000000000000000000000000000050505050505050500000000000000
00000000000000005000005000500050000505005000056050050000000000000000000500000050000000000005005005000000005050505050000000000000
00000000000050500050050505050505050050550500055000000000000000000000000000050000050005005000000000050050500505050500000000000000
00000000000000000500505050505050505050005005050000000050000000000050000000000000000000000005005005005000005005050505000000000000
00000000050050050050505050505050505505550500000505005000000000500000050000000005000000000000000000000050500500505050000000000000
00000000000005000505055505550550555055050505050000000000000000000000000005005000005005005005005000500500005050505050500000000000
00005000005050550505050550505055050550550500500500050005005050000050005000000000000000000000000050005005050050505055050000000000
00000005000000005050555555555505055555505555050005000500000000000000000000500500000500500050050000000050005005005050505000000000
00000500050556655555555555555555555555550505005050505055500000000000000000000005005000005000000500505000505050550505550555050000
00000000505550665555555555555555555555555550050000055666666555665666665500005000000000500000500050000005000005005050505505505055
00050005050500567555555555555555555555555555555555505566666676666677676666500050500505005050005000500500505050505050550550555555
00000500505500556755555555555555555555555506766666555555656667665056677667665000050000500500500050050005000500505055055055055055
00000505050550055655555565556555565555555666666650555560555667765655567767677650005050050005005000500500505055050505505050555555
00050005055555005555656555655556555565555555055555055565000056666666667777777777600505005050050050005005050550505050505555050505
00000505055555555555555656565656565655500000000556665566500000056666777676777777775005050505005000500505005055550550550050555555
00055550555555555565665656565665656565000005055555566556655555056656667777767777777655050505050505005000505005050505505555505555
00055665555555656565556566565656565650000000555555556666666565555676667777777777777777655505505005050505005050505050550505055055
00000565555655656566666566666666666500000005550056665555655556555566566777777777777777777555055550505050050505050505005055505555
00005566555556566665656666665566666500000000555000055055550555500555556667777776777777777765550505050050500505050505555505055055
50005566555556565666666666666666665000000000050000000000055555650055505556667776777777777777655555505505005005050505500550550555
00000055555655666666666666666666650000000000000000000000005555666555655505566677777777777777775550505050505050505050555005505505
00000055555565566666666666666666650000000000000000000000000005666556555555566666677777777777777555555055050505050505050555055055
05050505555556666666666666666666600000000000000000000000000000566666555555666776676667776777777755555505500505050505505050550550
00050555555565656666666666666666000000000000000000000000000000556666565505666676666767777677777775555555055055050550550555505505
05005055555556666666666667666665000000000000000000000000000000005666556500566667676677777777777776555555505550505505505050550505
00050555555565666666666666676650000000000000000000000000000000000566505650066667666767677777777777755555550505050550555555055555
00505055555656566666666666666500000000000000000000000000000000000566655655056666666666777777777777775555555555555555555555550505
00050505555555666666676766765000000000000000000000000000000000000056665555505677766666667777777777776555655555555555555555555555
05005055555566656666666666665000000000000000000000000000000000000000565555000567776676666777777777777655555555555555555555555555
00005055555555566666667667650000000000000000000000000000000000000000005555500055777666666667777777777655565555555555555555555555
00050550555565665666666666660000000000000000000000000000000000000000000055500000567766566676777777777756555655565555565555555555
00500005055555656666666766650000000000000000000000000000000000000000000000500000056666665666777777777765656556555556555555565555
00005050555556556666666666600000000000000000000000000000000000000000000005550000055665655566667677777765656565565565565565555555
00000505555555565666666667600000000000000000000000000000000000000000000000555000000055555555667666777765665656556556556556556565
00500005055555656656666666600000000000000000000000000000000000000000000000050050550000000550566666777775656565655655656656565555
00005050505555565666666666500000000000000000000000000000000000000000000000000005055500000000056666667776666566565656566556556565
00000050555555656566566666500000000000000000000000000000000000000000000000000000555500000000005665677766666656666656565565665655
00000505505555555656666666000000000000000000000000000000000000000000000000000000005555000000005565667776666666566566666665665656
00050050555556656665666666000000000000000000000000000000000000000000000000000000000050500000000565566776666666666666666666565665
50000505055505655556666665000000000000000000000000000000000000000000000000000000000000000000055566666676666656566666666666666656
55050050555505556665666665000000000000000000000000000000000000000000000000000000000000005000555556667776666666666666666666666666
00000505055555555656565665000000000000000000000000000000000000000000000000000000000000000005055656566677666666666666666666666666
00500505505555656566565665000000000000000000000000000000000000000000000000000000000000000050555556556667666666666666666666666666
00000500505555556556556665000000000000000000000000000000000000000000000000000000000000000555055565555566666666666666666666666666
00505055555555655556556655000000000000000000000000000000000000000000000000000000000000000055555555500066766666666666655577766666
50005005055555556566565665000000000000000000000000000000000000000000000000000000000000000000555555600566676667667666550555676666
00500550555555565655666555000000000000000000000000000000000000000000000000000000000000000005555505560567666766666660505005556666
00050005055555555556565650000000000000000000000000000000000000000000000000000000000000000000055555560666666667667660000500055666
05005505505555655655665655000000000000000000000000000000000000000000000000000000000000000000005505556676666766676666000005006666
00050050555555555556556565000000000000000000000000000000000000000000000000000000000000000000000055556666766676766766000000066666
00505055055555565655656655000000000000000000000000000000000000000000000000000000000000000000000005566767666666676666660005667667
50005050555055555556555556000000000000000000000000000000000000000000000000000000000000000000000005566666766766766667666666666766
00505055505055555555656565000000000000000000000000000000000000000000000000000000000000000000000005667676667667667666676676766666
50005050555555555555555555000000000000000000000000000000000000000000000000000000000000000000000056666666676666666656667666666676
05050555555555555555556565000000000000000000000000000000000000000000000000000000000000000000000056767676766766666666676676676666
05505550555555555555555555500000000000000000000000000000000000000000000000000000000000000000000566666666666666666666666666666666
55055055555555555555555555550000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666666666666
05550555555555555555555555550000000000000000000000000000000000000000000000000000000000000000006666665666656666666666666666665666
55055505555555555555555555550000000000000000000000000000000000000000000000000000000000000000066666666666555666666666666666666656
05550555555555505555555555555500000000000000000000000000000000000000000000000000000000000000566666666666656666566666666566666666
50555550566555555505555555555500000000000000000000000000000000000000000000000000000000000000666665666666665656666666566566565656
55555500556655555500555555555555000000000000000000000000000000000000000000000000000000000055666666666665666655665666665656656566
55555500055555555050550550665555500000000000000000000000000000000000000000000000000000000056666666665666666666656656656656565656
55555555000555505555055500556555550000000000000000000000000000000000000000000000000000005666666666656565665656566566566565656565
55555555555555555055555050005505055500000000000000000000000000000000000000000000000000556666666565666566656655656656656565656556
05055055555555505055050505050555505050000000000000000000000000000000000000000000000055565655656666665656565556565656565656565656
55555550505505555055505050505050555050500000000000000000000000000000000000000000005566565666666556566565656556556556565655656555
05055055555555505005550055000505050505050000000000000000000000000000000000000000055556556656556566656566565565656565556566555565
05505550500505550500505005050505005050550500000000000000000000000000000000000005555556565556555655656555556556565556555556656555
05055055050055055050500505005005505005050550000000000000000000000000000000000055555655555565656565565655655656555655555665555565
50050505050505050505050000500555050505005055550000000000000000000000000000000555555556555655555555555655556555655556550006556555
05050050505005005050005050050005005000005500505500000000000000000000000000005505555665555555656565565555655655556555555000555555
05055050500500500005050000505050505050050505550050550555555000500500000005555555550006555555555555555555556665555565555500555555
00000000005005005050000050000005000000505050050505055005055555505055555055550555555005555555555555655555555555555555555555555555
05050505000050000000050000500000000505005005000000005005050505055500550505050505555555555555055555555555555555555555555555555555
00000000050000500050000500000000000050000000500000500050050055505050055050555055555505555555555550555555555555555555555555555555
00500500000500000000000000000000000000055050000050005005000000005005555505050550555050055555555550055555555555555555555555555555
00000005000000000000000000000000000000000000500000000000050000505005000055505505505555550555555505055555555555555555555555555555
00000000050005500000000000000000000000000000000500005050500500005050050050550055555050505505555055055555555055555505505555555555
00000000005000000000000000000000000000000000000005000000055050050500555055055050505505550555555550550555505505055555555550550555
00005000000000000000000000000000000000000000000000000500005005000005050005055050050555050550505505505055055055550555555505505550
00000000000000000000000000000000000000000000000000050050000000000050050500505005050005555555500505055505505055055555050555555055
00000005000000000000000000000000000000000000000000000000000005055500000055005050050550555555550550505050555550505005555505505505
00000000500000000000000000000000000000000000000000005000005000000505000050550005000005050555505000505505005505050050505055055055
00000000000000000000000000000000000000000000000000000000000000000000000000000000050500000000550505050000505050500500050505505550
00000000000000000000000000000000000000000000000000000000000000000000550000000000050000000000050500505050505050555000505050550505
00000000000000000000000000000000000000000000000000000000000000000000000005050000005000000000050055050050500000555055005505050555
00000000000000000000000000000555550000000000000000000000000000000000000000000000000000000000000050505000000050005050050550050005
00000000000000000000000000005777775000000555550500050500050555550005000500055000000055555050055055555000505050505505000005055055
00000000000000000000000000057555557500005777775750575750575777775057505750575000000577777575557577777500000000500500500505000555
00000000000000000000000000057577757500005765550576755775575567650576750576750000000056765577557576555000005050050550050000000500
00000000000000000000000000057576557500005777775057505767675057505765675067650000000005750576767575000050000000000005000505050000
00000000000000000000000000057577757500000555675057505755775057505777775576750000000056765575577576555000500000500050050000005000
00000000000000000000000000057555557500005777775057505750575057505765675750575000000577777575057577777500000000050500000000000000
00000000000000000000000000005777775000000555550005000500050005000500050500050000000055555050005055555000000000000050000000500000
00000000000000000000000000000555550000000000000000000000000000000000000000000000000000000000000000000000000005000005000500005000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000500
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000500000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005000000000000000
__sfx__
080300001a051180511705113051100550c0550805602056000521e001148070e0003eb0732b06287002e30000806000001eb050000626b060080600805008050000000000000000000000000000000000000000
001000000262006620076100461002610006000060000600006000060000600006000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000400000264001630016300062000620006200061000610006000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00080000156500d630086200462002620006200061000610006100061000610006000060001600016000160001600016000060000600006000060000000000000000000000000000000000000000000000000000
000400002e5202f52032530345402e540355303252034500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
08030000185511655114551115510d555085550455600556000021e001148070e0003eb0732b06287002e30000806000001eb050000626b060080600805008050000000000000000000000000000000000000000
000600000255004550075500b5500f55012550125001c500185001050017500015000160000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000600000f5500b550075500455001550005500050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
00 40404040
__meta:4f78820c-0dc1-11ed-861d-0242ac120002__
__meta:1bdaec14-d23c-4c68-9cbb-45d80342eabf__
{
	["pico8"] = {
	},
}
