/**
 * Randomized Inque demoscene group logo
 * by Glow/Inque
 * 
 * Created for the Revision 2025 Entropretty competition.
 **/ 

ctx.textAlign = "center";
ctx.textBaseline = "middle";

const vertices = [
  -0.00631052256, -0.620765686, -0.0480940938,
-0.625595748, -0.400248051, 0.70546931,
0.329141051, 0.321291804, -0.0480940938,
-0.290144145, 0.54180932, 0.70546931,
0.664592624, 1.26334918, -0.0480940938,
0.0453073978, 1.48386681, 0.70546931,
1.00004411, 2.20540667, -0.0480940938,
0.380758971, 2.4259243, 0.70546931,
1.33549571, 3.14746404, -0.0480940938,
0.716210544, 3.36798167, 0.70546931,
-1.33549571, -0.147464037, 0.0480940939,
-0.716210544, -0.367981672, -0.70546931,
-1.00004411, 0.794593334, 0.0480940938,
-0.380758971, 0.574075818, -0.70546931,
-0.664592624, 1.73665082, 0.0480940938,
-0.0453073978, 1.51613319, -0.70546931,
-0.329141051, 2.67870808, 0.0480940938,
0.290144145, 2.45819068, -0.70546931,
0.00631052256, 3.62076569, 0.0480940938,
0.625595748, 3.40024805, -0.70546931,
1.03904116, 0.0685077906, 0.609281123,
0.419755936, 0.289025307, 1.36284447,
0.755207479, 1.2310828, 1.36284447,
1.37449265, 1.01056516, 0.609281123,
1.70994425, 1.95262265, 0.609281123,
1.09065902, 2.17314005, 1.36284447,
1.42611063, 3.11519766, 1.36284447,
2.04539585, 2.89468002, 0.609281123,
1.74894106, -0.184276223, 1.2666564,
1.12965584, 0.036241293, 2.0202198,
1.46510744, 0.978298724, 2.0202198,
2.08439255, 0.757781208, 1.2666564,
2.41984415, 1.69983864, 1.2666564,
1.80055892, 1.92035615, 2.0202198,
2.13601065, 2.86241364, 2.0202198,
2.75529575, 2.64189601, 1.2666564,
-0.238526285, 2.64644194, 1.45903277,
-0.948426306, 2.89922571, 0.801657498,
-0.612974703, 3.84128332, 0.801657498,
0.0969253182, 3.58849907, 1.45903277,
-0.857811391, 2.86695933, 2.21259618,
-1.56771135, 3.11974335, 1.55522084,
-1.23225987, 4.06180096, 1.55522084,
-0.522359848, 3.8090167, 2.21259618,
0.806825399, 3.33571529, 2.11640787,
0.471373796, 2.39365768, 2.11640787,
-0.14791131, 2.61417532, 2.86997128,
0.187540233, 3.55623293, 2.86997128,
1.5167253, 3.08293104, 2.77378321,
1.1812737, 2.14087391, 2.77378321,
0.561988592, 2.36139131, 3.52734661,
0.897440135, 3.30344868, 3.52734661,
0.135922253, 1.45160031, 2.11640787,
-0.483362913, 1.67211795, 2.86997128,
0.226536989, 1.41933393, 3.52734661,
0.845822155, 1.1988163, 2.77378321,
-0.19952929, 0.509542882, 2.11640787,
-0.818814516, 0.730060458, 2.86997128,
-0.108914614, 0.477276444, 3.52734661,
0.510370612, 0.256758928, 2.77378321];

const faces = [
[ 1, 3, 4, 2],
[ 5, 7, 8, 6],
[ 11, 13, 14, 12],
[ 13, 15, 16, 14],
[ 15, 17, 18, 16],
[ 17, 19, 20, 18],
[ 19, 10, 9, 20],
[ 12, 1, 2, 11],
[ 12, 14, 3, 1],
[ 14, 16, 5, 3],
[ 16, 18, 7, 5],
[ 18, 20, 9, 7],
[ 2, 4, 13, 11],
[ 4, 6, 15, 13],
[ 6, 8, 17, 15],
[ 3, 21, 22, 4],
[ 4, 22, 23, 6],
[ 6, 23, 24, 5],
[ 5, 24, 21, 3],
[ 7, 25, 26, 8],
[ 8, 26, 27, 10],
[ 10, 27, 28, 9],
[ 9, 28, 25, 7],
[ 29, 32, 31, 30],
[ 33, 36, 35, 34],
[ 21, 29, 30, 22],
[ 22, 30, 31, 23],
[ 24, 32, 29, 21],
[ 25, 33, 34, 26],
[ 26, 34, 35, 27],
[ 27, 35, 36, 28],
[ 28, 36, 33, 25],
[ 26, 34, 33, 25],
[ 23, 26, 25, 24],
[ 24, 25, 33, 32],
[ 32, 33, 34, 31],
[ 31, 34, 26, 23],
[ 8, 37, 38, 17],
[ 17, 38, 39, 19],
[ 19, 39, 40, 10],
[ 10, 40, 37, 8],
[ 41, 44, 43, 42],
[ 37, 41, 42, 38],
[ 38, 42, 43, 39],
[ 39, 43, 44, 40],
[ 40, 45, 46, 37],
[ 37, 46, 47, 41],
[ 41, 47, 48, 44],
[ 44, 48, 45, 40],
[ 49, 52, 51, 50],
[ 45, 49, 50, 46],
[ 47, 51, 52, 48],
[ 48, 52, 49, 45],
[ 46, 53, 54, 47],
[ 47, 54, 55, 51],
[ 51, 55, 56, 50],
[ 50, 56, 53, 46],
[ 57, 60, 59, 58],
[ 53, 57, 58, 54],
[ 54, 58, 59, 55],
[ 55, 59, 60, 56],
[ 56, 60, 57, 53], 
];

const length = seed.length
const grid = Math.ceil(Math.sqrt(length))
const cellSize = Math.floor(90 / grid)
const fontSize = Math.max(8, Math.floor(cellSize * 0.4))
// ctx.font = `${fontSize}px sans-serif`

const rando = randomGenerator(seed);

const minDist = 0.0;
//const totalSeed = seed[0]+seed[1]*256+seed[2]*256*256+seed[3]*256*256*256;

const rotAngleX = 0.2+0.10*Math.sin(Math.PI*rando()*2.0);
const rotAngleZ = 1.6+0.4*Math.sin(Math.PI*rando()*2.0);
const randCol = Math.floor(rando()*1024);

ctx.strokeStyle = "#000000";
ctx.lineWidth = 1;
ctx.strokeRect(0, 0, 100, 100);

function rotateZ(v, angle)
{
    var x = v[0]*Math.cos(angle) + v[2]*Math.sin(angle);
    var y = v[1];
    var z = -v[0]*Math.sin(angle) + v[2]*Math.cos(angle);
    return [x,y,z];
}

function rotateX(v, angle)
{
    var x = v[0];
    var y = v[1]*Math.cos(angle) + v[2]*Math.sin(angle);
    var z = -v[1]*Math.sin(angle) + v[2]*Math.cos(angle);
    return [x,y,z];
}

function getPos2d(v)
{
  var z = 0.1*v[2] + 1.5;

  var px = -v[0] / z;
  var py = -v[1] / z;

  var scale = 20.0;
  px *= scale;
  py *= scale;

  px += 71.0;
  py += 75.0;

  return [px, py];
}

function getFaceVertex(f,i)
{
  var idx = (f[i]-1)*3;  
  var v = [vertices[idx],vertices[idx+1],vertices[idx+2]];
  return rotateX(rotateZ(v, rotAngleZ), rotAngleX);
}

function drawLine(p0, p1)
{
  ctx.beginPath(); // Start a new path
  ctx.moveTo(p0[0], p0[1]); // Move the pen to (30, 50)
  ctx.lineTo(p1[0], p1[1]); // Draw a line to (150, 100)
  ctx.stroke(); // Render the path
}

function getCol(idx)
{
  var cols = [
    "#9e4d1e",
    "#ebae34",
    "#000000",
  ];

  idx += randCol;

  return cols[idx%3];
}

function vertSub(a,b)
{
  return [a[0]-b[0],a[1]-b[1],a[2]-b[2]];
}

function getNormal(a,b,c)
{
  var ba = vertSub(b,a);
  var ca = vertSub(c,a);

  return [
    ba[1]*ca[2] - ba[2]*ca[1],
    ba[2]*ca[0] - ba[0]*ca[2],
    ba[0]*ca[1] - ba[1]*ca[0]
  ];
}

function getColIdx(f)
{
  var v0 = getFaceVertex(f,0);
  var v1 = getFaceVertex(f,1);
  var v2 = getFaceVertex(f,2);

  var n = getNormal(v0, v1, v2);
  var x = (n[0] > 0.0) ? 1 : 0;
  var y = (n[1] > 0.0) ? 0 : 1;
  if (n[1] > 0.0)
    return 2;
  else 
    return x;
}

function distToP(a, b)
{
  var d0 = a[0]-b[0];
  var d1 = a[1]-b[1];
  return Math.sqrt(d0*d0+d1*d1);
}

function drawFace(p0,p1,p2,p3, col)
{
  if (
    distToP(p0, p1) < minDist ||
    distToP(p0, p2) < minDist ||
    distToP(p0, p3) < minDist ||
    distToP(p1, p2) < minDist ||
    distToP(p1, p3) < minDist ||
    distToP(p2, p3) < minDist)
    {
      return;
    }

  ctx.fillStyle = col;
  ctx.beginPath();
  ctx.moveTo(p0[0], p0[1]);
  ctx.lineTo(p1[0], p1[1]);
  ctx.lineTo(p2[0], p2[1]);
  ctx.lineTo(p3[0], p3[1]);
  ctx.closePath();
  ctx.fill();
  ctx.stroke();
}

function isBackFace(p0, p1, p2)
{
  var cp = (p1[0]-p0[0]) * (p2[1]-p0[1]) - (p1[1]-p0[1]) * (p2[0]-p0[0]);
  return cp >= 0;
}

// for (var v=0; v<vertices.length; v+=3)
// {
//   var p = [vertices[v], vertices[v+1], vertices[v+2]];
//   var p0 = getPos2d(p);
//   ctx.strokeRect(p0[0]-1, p0[1]-1, 3, 3);
// }

function getMinDepth(f)
{
  var v0 = getFaceVertex(f,0);
  var v1 = getFaceVertex(f,1);
  var v2 = getFaceVertex(f,2);
  var v3 = getFaceVertex(f,3);

  var z = v0[2];
  z = Math.min(z, v1[2]);
  z = Math.min(z, v2[2]);
  z = Math.min(z, v3[2]);
  return z;
}

function depthSort(a, b)
{
  return getMinDepth(b) - getMinDepth(a);
}

// sort on depth
faces.sort(depthSort);

for (var f=0; f<faces.length; f++)
{
  var v0 = getFaceVertex(faces[f],0);
  var v1 = getFaceVertex(faces[f],1);
  var v2 = getFaceVertex(faces[f],2);
  var v3 = getFaceVertex(faces[f],3);

  var p0 = getPos2d(v0);
  var p1 = getPos2d(v1);
  var p2 = getPos2d(v2);
  var p3 = getPos2d(v3);


  if (isBackFace(p0,p1, p2))
    continue;

  var colIdx = getColIdx(faces[f]);
  var col = getCol(colIdx);

  drawFace(p0,p1,p2,p3, col);
}
