function randomGenerator(seed) {
    // xorshift-based prng
    let s = seed.reduce((acc, val) => ((acc * 31) + val) >>> 0, 1);
    return function() {
      s ^= (s << 13);
      s ^= (s >>> 17);
      s ^= (s << 5);
      return (s >>> 0) / 4294967296;
    };
  }
  
  const rand = randomGenerator(seed);
  
  const palettes = ["#5E1675", "#EE4266", "#B73", "#336357", "#446", "#644"];
  const baseColor = palettes[Math.floor(rand() * palettes.length)];
  const palette = ["#000", baseColor, lightenColor(baseColor, 100), "#fff"];
  
  function randColor() {
    return palette[Math.floor(rand() * palette.length)];
  }
  
  function lightenColor(hex, amt) {
    const num = parseInt(hex.slice(1), 16);
    let r = (num >> 16) + amt;
    let g = ((num >> 8) & 0xff) + amt;
    let b = (num & 0xff) + amt;
    if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;
    return "#" + ((r<<16)|(g<<8)|b).toString(16).padStart(6,"0");
  }
  
  function makeObject(x, y) {
    for (let i = 4; i >= 0; i--) {
      ctx.beginPath();
      ctx.arc(x, y, i*3, 0, Math.PI * 2);
      ctx.strokeStyle = randColor();
      ctx.fillStyle = ctx.strokeStyle;
      ctx.stroke();
      if (rand() < 0.1) {
        ctx.fill();
      }
    }
  }
  
  // Lines
  // Don't make lines on the last row/col, so that we can see the orientation.
  for (let i = 0; i < 2; i++) {
    for (let j = 0; j < 2; j++) {
      ctx.lineWidth = (rand() + 0.5) * 4;
      const cx = i * 30 + 15;
      const cy = j * 30 + 15;
      ctx.strokeStyle = palette[0];
      ctx.beginPath();
      ctx.moveTo(cx, cy);
      ctx.lineTo(cx + 30, cy);
      ctx.stroke();
  
      ctx.beginPath();
      ctx.moveTo(cx, cy);
      ctx.lineTo(cx, cy + 30);
      ctx.stroke();
    }
  }
  
  ctx.lineWidth = 1.5;
  for (let i = 0; i < 3; i++) {
    for (let j = 0; j < 3; j++) {
      const cx = i * 30 + 15;
      const cy = j * 30 + 15;
      makeObject(cx, cy);
    }
  }
  