;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000
    *--- ****************************************************** ---*
    *--- De aqui hacia abajo meter TODAS las rutinas del PLAYER ---*
    *--- Y TODAS LAS VARIABLES ---*
    *--- Para encapsularlas despues ---*
    *--- ****************************************************** ---*
    ;I always liked tfmx v7 songs in games in the main screen
    ;And i wondered how this could be done.
    ;This code was made while I'm learning 68k asm
    ;This code is a work in progress (slowly)
    ;May contain bugs
    ;It is incomplete
    ;It is fixed at 12749 samples/s and notes from g2 to f#3 (1 octave only)
    ;However, it is enough to use it in some productions.
    
    ;mgyv, 2025
    
gxm_pal_freq	EQU	3546895
gxm_masterfreq	EQU	12749-1	;<-Editable, selecciona frecuencia
			;gxm_buffsize resultante DEBE ser PAR (controlar)
			;MUCHO CUIDADO si quieres mantener la afinacion:
			;Cada linea que bajes subira la frecuencia.
			;por cada linea debes desplazar anadiendo
			;una linea en gxm_freqtable. De no hacerlo,
			;la cancion va a sonar 'transposed' con respecto
			;a lo secuenciado en el octamed
			;Elegir un valor intermedio a las notas
			;para poder hacer luego afinacion arriba-abajo
			;7830= 156 (B1)
			;8049= 160
			;8249= 164 (C2)
			;8537= 170
			;8749= 174 (C#2)
			;9046= 180
			;9309= 186  (D2)
			;9549= 190
			;9849= 196 (D#2)
			;10149= 202
			;10425= 208 (E2)
			;10749= 214
			;11049= 220 (F2)
			;11349= 226
			;11745= 234 (F#2)
			;12049= 240
			;12445= 248 (G2)
			;12749= 254
			;13149= 262 (G#2)
			;13525= 270
			;13949= 278 (A2)
gxm_masterPeriod	EQU	gxm_pal_freq/gxm_masterfreq
gxm_buffsize	EQU	gxm_masterfreq/50	;
			;habra 2 buffers de em_buffsize en chip ram
gxm_longbuff	EQU	2	;bytes mas largo que sera el buffer largo
			;valores posibles 2,4,6 (default 2)
			;intentar poner el valor menor
			;dependiendo del periodo, admite 6,4 o 2.
			;con 6 posiblemente haya que bajar un poco
			;stick2line a 285 o asi.
			;p.ej a 11332 admite el 2, y 13549 NO
gxm_stick2line	EQU	298	;Int de audio intenta sincronizarse a 
				;esta linea cada frame (def=298)
		;Nombres de OFFSETS en header EXM0:
gxm_hsonglen	EQU	$4
gxm_hplayseq	EQU	$6
gxm_hnumblocks	EQU	$106
gxm_hnumsamples	EQU	$108
gxm_hparsamples	EQU	$10a
gxm_htempo2	EQU	$312
gxm_hbaseptrs	EQU	$314
gxm_hsamplelistptr EQU	$31c
gxm_hblock0ptr	EQU	$320

	;SECTION	em_play,CODE_P
	INCLUDE "includes/P6112-play-stripped.i"

gxm_Init:
	jsr	gxm_GetVBR		;vbr en gxm_vbrpos
	jsr	gxm_fillLUTVol		;generamos tabla volumen
	jsr	gxm_Fillcurves		;rellenamos curvas por defecto


	clr.b	gxm_mixerrunning	;Flag. 0=off, 1=on
	move.w	#$1,gxm_usearray	;curva por defecto global
	move.w	#$6,gxm_usearrayparcial	;curva por defecto ch0-1
	clr.w	gxm_offarray
	move.w	#0,gxm_offarrayparcial	;curva 0 de amp para todo	
	;colocamos valores para forzar llenado de buferes al inicio
	clr.w	gxm_allowplay		;No permite playear
	moveq	#0,d0			;marcamos todo ok
	;move.w	#$00,gxm_req_fill	;
	;move.w	#$08,gxm_req_pos	;posicion actual llenado
	lea	gxm_song,a0
	cmp.l	#$47584d30,(a0)		;GXM0 string?
	beq	.sig00			;OK
	subq	#1,d0			;FAIL & EXIT! d0=$ffff
	bra	.exit
.sig00					;sigue normalmente
	move.w	#$1,gxm_allowplay	;En principio permite playear
		;recogemos algunos datos de la cabecera del EXM
	move.w	gxm_hnumblocks(a0),d1
	move.w	d1,gxm_totalblocks
	move.w	gxm_hnumsamples(a0),d2
	move.w	d2,gxm_totalsamples
	add.w	d2,d1			;samples+blocks
	move.w	gxm_fixdptrs,d2
	bne	.l1	;si ya lo hizo antes, no volver a hacer este trozo
			;punteros totales=samples+blocks+4-1
	addq.w	#$4-1,d1	;d1=punteros totales a incrementar direccion a0
	move.l	a0,d2
	lea 	gxm_hbaseptrs(a0),a1
.l0			;incrementamos todos los punteros desde $314
	move.l	(a1),d3	;con la direccion de inicio de la cancion (a0)
	beq	.no
	add.l	d2,(a1)
.no	add.l	#4,a1
	dbf	d1,.l0
	move.w	#$1,gxm_fixdptrs ;marcamos para no volver a hacer
		;Aqui tenemos los punteros actualizados entre marcadores
		;$AA y $CCCCCCCC. Ojo que el $BBBBBBBB me lo cargue
		;seguimos recogiendo datos de la cabecera:
.l1	move.w	gxm_hsonglen(a0),gxm_songlen
	;move.w	gxm_songlen,d2		 ;debug, borrar
	lea	gxm_hplayseq(a0),a1	
	move.l	a1,gxm_inisongpos_ptr
	lea	gxm_hparsamples(a0),a1
	move.l	a1,gxm_sample_param_ptr
	lea	gxm_hsamplelistptr(a0),a1 ;Ptr a lista de samples
	move.l	(a1),gxm_sample_base_list_ptr
	;move.l	gxm_sample_base_list_ptr,d2	;debug, borrar
	lea	gxm_hblock0ptr(a0),a1
	move.l	a1,gxm_block_list_ptr
		;ahora vamos a inicializar las variables para
		;empezar la cancion desde el principio
	clr.w	gxm_curr_tick		;0 =pasara valores a mixer
	move.w	gxm_htempo2(a0),d0	;secondary tempo inicial en octamed
	and.w	#$1f,d0
	move.w	d0,gxm_num_ticks	;guardamos
	;move.w	#$06,gxm_num_ticks	;que recargue a 6 si 0 (debug)
	clr.w	gxm_curr_line		;Nos ponemos en linea 0
	move.w	#$40,gxm_numlines	;64 lineas por defecto
	clr.w	gxm_curr_songpos	;empieza secuencia

	;Hay que calcular em_curr_block_ptr
	clr.w	d0
	jsr	gxm_getblockptr		;ptr to 1st block to play
	move.l	a1,gxm_curr_block_ptr
	;currently not using nosample:
	lea	gxm_nosample,a1
	move.l	a1,gxm_nosampleptr	;guardamos direccion de nosample
	
	move.w	#-1,gxm_ch0restoacc
	move.w	#-1,gxm_ch1restoacc
	move.w	#-1,gxm_ch2restoacc
	moveq	#0,d0			;todo OK
	moveq	#0,d1
	moveq	#0,d2			;dejar limpios d1 y d2
	jsr	gxm_play
	jsr	gxm_fillBuf		;1st buffer filled & ready
	moveq	#0,d0			;mark d0=0, all ok on return
.exit	rts

gxm_getblockptr:	;get block pointer from sequence index
			;d0.w=position, a1=returns block pointer
	move.l	gxm_inisongpos_ptr,a1
	move.b	(a1,d0),d0		;d0=block number
	move.l	gxm_block_list_ptr,a1	;apuntamos
	add.w	d0,d0
	add.w	d0,d0			;mul * 4
	adda.w	d0,a1			;a1=block(number) pointer
	move.l	(a1),a1			;a1=real block memory position
	move.w	(a1),d0
	addq.w	#1,d0			;d0=lines-1
	move.w	d0,gxm_numlines		;lines in current block ($40)
	adda.w	#$2,a1			;a1=block data here!	
	rts

gxm_getsampleptr: ;get sample pointer from index
		;d1.w=sample number, a2=returns sample pointer
	move.l	gxm_sample_base_list_ptr,a2
	add.w	d1,d1
	add.w	d1,d1
	adda.w	d1,a2
	move.l	(a2),a2			;a2=real memory position
	rts

gxm_getparamsptr: ;get sample parameters pointer from index
		;d1.w=sample number, a3=returns params pointer
	move.l	gxm_sample_param_ptr,a3
	asl.w	#$4,d1
	adda.w	d1,a3			;a3=params pointer

	rts
gxm_getperiod: ;entra nota (12 es la primera, 24 la ultima)
	; Entrada=d3, salida d3 (a3 como puntero)
	add.w	d3,d3
	
	add.w	d3,d3
	add.w	d3,d3
	add.w	d3,d3
	add.w	d3,d3	;*16, ahora la tabla es mas grande
	addq.w	#8,d3	;+8
	lea	(gxm_freqtable),a3
	adda.w	d3,a3
	move.w	(a3),d3
	rts

gxm_play:	;rutina a llamar cada vblank (o tick)
	;a0: se utiliza en rutina (chXinitptr para cada canal hasta dbf)
	;a1: se utiliza en rutina (current block pointer)
	;a2: Se utiliza en rutina (pointer to sample en proceso ;-)
	;a3: DEBE CONTENER sample params position (se trashea en rutina)
	;a4: se utiliza en rutina (tamanos de canales)
	;a5: se utiliza en rutina (
	;d0.full: se utiliza en rutina para nota completa (32 bit)
	;d1.low: temporal para guardar instrumento, multiproposito
	;d2.low: contador hasta el dbf, luego multiproposito
	;d3.low: multiproposito
	;d4.low: multiproposito
	;d5.low: sample size
	;d6.low: 0 en ch0, 32 en ch1, 64 en ch2
	movem.w	d2/d3/d4/d6,-(sp)
	movem.l	a0-a5/d0/d1/d5,-(sp)
	tst.w	gxm_curr_tick	
	bne	.tick
	move.w	gxm_num_ticks,gxm_curr_tick
    		*--- Esta parte actualiza valores desde cancion: ---*
	;movem.w	d1/d2/d3/d4/d6,-(sp)
	;movem.l	a0-a5/d0/d5,-(sp)
	clr.w	gxm_ch0volinc	;Nueva linea:incrementos o decrementos
	clr.w	gxm_ch1volinc	;de volumen a 0, para efectos tipo
	clr.w	gxm_ch2volinc	;Axx,etc. 
	clr.w	d6
	move.l	gxm_curr_block_ptr,a1
	lea	gxm_ch0initptr,a0 ;a0 = punteros de samples canales
	lea	gxm_ch0size,a4	;a4= tamanos en canales 
	lea	gxm_ch0curroff,a5 ;a5=curroffset actual channel
	move.w	#$3-1,d2	; 3  canales
.l0	move.l	(a1)+,d0 ;Ins,Note,Effect,Amount
	swap	d0
	move.w	d0,d1
	;and.w	#$ff00,d1
	asr.w	#$8,d1		;instrument+1
	beq.s	.sig4		;si es 0, no actualizamos ptrs de sample
	subq.w	#1,d1		;restamos 1 para que busque la tabla bien
	move.w	d1,d3		;guardamos (al salir lo restauramos)
	bsr	gxm_getsampleptr	;a2=sample memory position
	move.l	a2,(a0)		;guardamos en chXinitptr de canal actual
	move.w	d3,d1		;restauramos en d1
	bsr	gxm_getparamsptr ;a3=sample params position in GXMod
	move.w	(a3)+,(a4)+	;store size to gxm_chXsize
	move.w	(a3)+,d1	;len lo utilizamos en breve
	move.w	d1,(a4)+	;store len to gxm_chXlen
	move.w	(a3)+,(a4)+	;store replen
	move.w	(a3)+,(a4)+	;store vol
	move.w	(a3)+,(a4)+	;store singlecycle


	;FALTA GUARDAR/INICIALIZAR TAMBIEN:
	move.w d1,(a4)+		;inicializamos chXcurroff con len
	clr.w	(a4)+	;chXresto=0
	; chXresto
	; chXrestoacc
	;addq	#2,a4		;se supone apuntando a chxvolinc
	;clr.w	(a4)		;no inc o dec de volumen en .tick
	bra.s	.sig2
.sig4	adda.w	#$0e,a4		;este adda si no hay n.sample en linea
.sig2	and.w	#$ff,d0		;Note
	beq.s	.sig3		;si es 0, no actualizamos frecuencia
	 ;HAY NOTA-AQUI DEBEMOS ACTUALIZAR FRECUENCIA ACORDE A LA NOTA
	 ;y/o recargar punteros al comienzo del sample
	 ;a2=ptr to actual sample	 
	;move.l	a2,(a0)		;guardamos en chXinitptr de canal actual
	;move.l	#0,(a5)		;curroffset=0, resto=0
	move.w	d0,d3
	bsr	gxm_getperiod	;a3 trashed, d3=period
	move.w	d3,-2(a4)

.sig3	swap	d0
	move.w	d0,d1
	;and.w	#$ff00,d1
	asr.w	#$8,d1		;effect
	and.w	#$ff,d0		;amount
	bsr	gxm_applyfx
	adda.w	#$4,a0		;apuntamos a chXinitptr siguiente
	adda.w	#$12,a4		;alineamos a siguiente chXsize (colamos FREEs)
	adda.w	#$20,a5		;offset/resto del siguiente canal
	add.w	#32,d6		;ch0=0, ch1=32, ch2=64 para offset
	dbf	d2,.l0
	;adda.w	#$4,a1		;NOS COLAMOS el canal de distorsion
	bsr	gxm_canaldist	;rutina para canal distorsion (ch3)

	addq.w	#$1,gxm_curr_line
	move.w	gxm_curr_line,d2
	cmp.w	gxm_numlines,d2
	bne.s	.sig0			;no acabo el block
	clr.w	gxm_curr_line		;inicio de block de nuevo
	addq.w	#1,gxm_curr_songpos
	move.w	gxm_curr_songpos,d2
	cmp.w	gxm_songlen,d2
	bne.s	.sig1			;se acaba cancion??
	;AQUI se acaba la cancion, ver forma de terminarla
	clr.w	gxm_curr_songpos	;loopeamos desde el principio
.sig1	move.w	gxm_curr_songpos,d0
	bsr	gxm_getblockptr
	;AQUI hay que PASAR AL SIGUIENTE BLOCK
.sig0	move.l	a1,gxm_curr_block_ptr	;guardamos puntero a sig. linea

	;movem.l	(sp)+,a0-a5/d0/d5
	;movem.w	(sp)+,d1/d2/d3/d4/d6

	
.tick   	*--- Esta parte actualiza solo ticks de la linea anterior ---*
	subq.w	#$1,gxm_curr_tick
    		*--- BEGIN ACTUALIZA SLIDES VOLUMEN ---*
		;sumar gxm_chXvolinc a chXvolume segun corresponda en tick
		;y que no baje de 0 y que no suba de 64 para cada canal
	move.w	gxm_ch0volinc,d0
	beq.s	.finch0		;si incremento=0, no hacemos nada en ch0
	add.w	gxm_ch0volume,d0
	;tst.w	d0		;needed???
	bge.s	.mas0
	clr.w	d0		;si no es mayor que 0 o 0, ponemos a 0 
	clr.w	gxm_ch0volinc
	bra.s	.done0		;y vamos a siguiente canal
.mas0				;si >0 seguimos
	cmp.w	#64,d0
	ble.s	.done0		;if d0<=64 then goto .finch0
	move.w	#64,d0		;else d0=64
	clr.w	gxm_ch0volinc
.done0	move.w	d0,gxm_ch0volume	;devolvemos el valor y seguimos
.finch0

	move.w	gxm_ch1volinc,d0
	beq.s	.finch1		;si incremento=0, no hacemos nada en ch1
	add.w	gxm_ch1volume,d0
	;tst.w	d0
	bge.s	.mas1
	clr.w	d0		;si no es mayor que 0 o 0, ponemos a 0 
	clr.w	gxm_ch1volinc
	bra.s	.done1		;y vamos a siguiente canal
.mas1				;si >0 seguimos
	cmp.w	#64,d0
	ble.s	.done1		;if d0<=64 then goto .finch1
	move.w	#64,d0		;else d0=64
	clr.w	gxm_ch1volinc
.done1	move.w	d0,gxm_ch1volume	;devolvemos el valor y seguimos
.finch1

	move.w	gxm_ch2volinc,d0
	beq.s	.finch2		;si incremento=0, no hacemos nada en ch2
	add.w	gxm_ch2volume,d0
	;tst.w	d0
	bge.s	.mas2
	clr.w	d0		;si no es mayor que 0 o 0, ponemos a 0 
	clr.w	gxm_ch2volinc
	bra.s	.done2		;y vamos a siguiente canal
.mas2				;si >0 seguimos
	cmp.w	#64,d0
	ble.s	.done2		;if d0<=64 then goto .finch2
	move.w	#64,d0		;else d0=64
	clr.w	gxm_ch2volinc
.done2	move.w	d0,gxm_ch2volume	;devolvemos el valor y seguimos
.finch2
    		*--- END ACTUALIZA SLIDES VOLUMEN ---*


	movem.l	(sp)+,a0-a5/d0/d1/d5
	movem.w	(sp)+,d2/d3/d4/d6
	
.end	rts

gxm_canaldist	;rutina para el canal de distorsion (ch3) - probar bien
	move.l	(a1)+,d0 ;Ins,Note,Effect,Amount
	swap	d0
	move.w	d0,d1
	asr.w	#$8,d1		;instrument+1
	beq	.sig4		;si es 0, no actualizamos ptrs de sample
	;sub.w	#1,d1		;restamos 1 para que busque la tabla bien
	;move.w	d1,d3		;guardamos (al salir lo restauramos)


	bra.s	.sig2
.sig4	adda.w	#$0e,a4		;este adda si no hay n.sample en linea
.sig2	and.w	#$ff,d0		;Note
	;beq	.sig3		;si es 0, no actualizamos frecuencia
	 ;HAY NOTA-AQUI DEBEMOS ACTUALIZAR FRECUENCIA ACORDE A LA NOTA
	 ;y/o recargar punteros al comienzo del sample
	 ;a2=ptr to actual sample	 
	;move.l	a2,(a0)		;guardamos en chXinitptr de canal actual
	;move.l	#0,(a5)		;curroffset=0, resto=0
	;move.w	d0,d3
	;jsr	gxm_getperiod	;a3 trashed, d3=period
	;move.w	d3,-2(a4)

.sig3	swap	d0
	move.w	d0,d1
	;and.w	#$ff00,d1
	asr.w	#$8,d1		;effect
	and.w	#$ff,d0		;amount
	bsr	gxm_applyfxch3
	;adda.w	#$4,a0		;apuntamos a chXinitptr siguiente
	;adda.w	#$12,a4		;alineamos a siguiente chXsize (colamos FREEs)
	;adda.w	#$20,a5		;offset/resto del siguiente canal
	;add.w	#32,d6		;ch0=0, ch1=32, ch2=64 para offset

	rts

gxm_applyfx:	;Gestiona los comandos en columnas de 0 a 2
		;jmp table (p.ej:para d1=4 salta a .fx4)
		;d1=effect , d0=amount
	movem.l	a0-a1,-(sp)	;un par de registros para poder usar
				;d3.low y d4.low se pueden utilizar
				;d6 contiene offset 0-32-64 segun canal
	and.w	#$f,d1		;que no se salga de la tabla
	beq.w	.done		;si efecto=0 ignoramos
	add.w	d1,d1
	move.w	.jmpeffect(pc,d1.w),d1
	jmp	.jmpeffect(pc,d1.w)
.jmpeffect
	dc.w	.fx0-.jmpeffect		;disabled for now
	dc.w	.fx1-.jmpeffect
	dc.w	.fx2-.jmpeffect
	dc.w	.fx3-.jmpeffect
	dc.w	.fx4-.jmpeffect
	dc.w	.fx5-.jmpeffect
	dc.w	.fx6-.jmpeffect
	dc.w	.fx7-.jmpeffect
	dc.w	.fx8-.jmpeffect
	dc.w	.fx9-.jmpeffect
	dc.w	.fxa-.jmpeffect
	dc.w	.fxb-.jmpeffect
	dc.w	.fxc-.jmpeffect
	dc.w	.fxa-.jmpeffect	;de momento DXX=AXX
	dc.w	.fxe-.jmpeffect
	dc.w	.fxf-.jmpeffect

.fx0	
	bra	.done
.fx1	
	bra	.done
.fx2	
	bra	.done
.fx3	
	bra	.done
.fx4	
	bra	.done
.fx5	
	bra	.done
.fx6	
	bra	.done
.fx7	
	bra	.done
.fx8	
	bra	.done
.fx9   
	*--- SECONDARY TEMPO 01<=x<=$20 ; si 0 = $20---*
	and.w	#$1f,d0			;rango valido 0-31
	bne	.fx9co			;si <>0, aplicamos tiempo
	move.w	#$20,d0			;si 0, aplicamos $20
.fx9co	move.w	d0,gxm_num_ticks	;recarga este valor al llegar a 0
	move.w	d0,gxm_curr_tick	;en la linea actual tambien
	bra	.done
.fxa	;AXX  incremento/decremento de volumen
	;sumar gxm_ch0volinc a ch0volume segun corresponda en tick
	;aqui colocar el valor en gxm_ch0volinc
	lea	gxm_ch0volinc,a0
	move.w	d0,d1		;copiamos cantidad en d1	
	and.w	#$f,d0		;d0=upwards
	bne.s	.rampdn
	and.w	#$f0,d1
	asr.w	#$4,d1		;ramp up volume
	move.w	d1,(a0,d6.w)
	bra	.done
.rampdn				;ramp down volume
	neg.w	d0
	move.w	d0,(a0,d6.w)
	bra	.done
.fxb	
	;SIN PROBAR
	move.w	d0,gxm_curr_songpos	;colocamos posicion playlist
	clr.w	gxm_curr_line		;linea 0

	bra	.done
.fxc	;CXX es control de volumen hasta 64
	;d6 contiene offset ch0=0, ch1=32, ch2=64
	;ch0vol=ch0volume+0, ch1vol=ch0volume+32, ch2=ch0volume+64
	;aqui debiera haber un check para que d0 sea <=64 (incluido)
	lea	gxm_ch0volume,a0
	move.w	d0,(a0,d6.w)	;escribimos nuevo volumen
	bra	.done
.fxd	
	bra	.done
.fxe	
	bra	.done
.fxf	*-----------------------------------------*
	*--- Tabla secundaria para efectos FXX ---*
    	*-----------------------------------------*	
	move.w	d0,d1		;copiamos cantidad en d1
	asr.w	#4,d1		;queremos el nibble alto en la parte baja
	and.w	#$f,d1		;que no se salga de la tabla
	add.w	d1,d1
	move.w	.jmpf(pc,d1.w),d1
	jmp	.jmpf(pc,d1.w)
.jmpf
	dc.w	.fxf0-.jmpf
	dc.w	.fxf1-.jmpf
	dc.w	.fxf2-.jmpf
	dc.w	.fxf3-.jmpf
	dc.w	.fxf4-.jmpf
	dc.w	.fxf5-.jmpf
	dc.w	.fxf6-.jmpf
	dc.w	.fxf7-.jmpf
	dc.w	.fxf8-.jmpf
	dc.w	.fxf9-.jmpf
	dc.w	.fxfa-.jmpf
	dc.w	.fxfb-.jmpf
	dc.w	.fxfc-.jmpf
	dc.w	.fxfd-.jmpf
	dc.w	.fxfe-.jmpf
	dc.w	.fxff-.jmpf

.fxf0	 *--- F0X Command ---*
	;ahora mismo F00,F01,F02...F0F HACEN LO MISMO:Siguiente pattern
	;PROBAR PRIMERO!!!!
	clr.w	gxm_curr_line		;inicio de block de nuevo
	addq.w	#1,gxm_curr_songpos
	move.w	gxm_curr_songpos,d1
	cmp.w	gxm_songlen,d1
	bne	.fsig1			;se acaba cancion??
	;AQUI se acaba la cancion, ver forma de terminarla
.fsig1	move.w	gxm_curr_songpos,d0
	jsr	gxm_getblockptr		;uses d0 & a1
	;AQUI hay que PASAR AL SIGUIENTE BLOCK
.fsig0	move.l	a1,gxm_curr_block_ptr	;guardamos puntero a sig. linea

	bra	.done
.fxf1	bra	.done
.fxf2	bra	.done
.fxf3	bra	.done
.fxf4	bra	.done
.fxf5	bra	.done
.fxf6	bra	.done
.fxf7	bra	.done
.fxf8	bra	.done
.fxf9	bra	.done
.fxfa	bra	.done
.fxfb	bra	.done
.fxfc	bra	.done
.fxfd	bra	.done
.fxfe	bra	.done
.fxff	

.done
	movem.l	(sp)+,a0-a1
	rts

gxm_applyfxch3:	;Gestiona los comandos en columna 3 SOLAMENTE
		;jmp table (p.ej:para d1=4 salta a .ch3fx4)
		;d1=effect , d0=amount
	movem.l	a0-a1,-(sp)	;un par de registros para poder usar
				;d3.low y d4.low se pueden utilizar
				;d6 se puede utilizar
	and.w	#$f,d1		;que no se salga de la tabla
	beq.w	.done		;si efecto=0 ignoramos
	add.w	d1,d1
	move.w	.jmpeffect(pc,d1.w),d1
	jmp	.jmpeffect(pc,d1.w)
.jmpeffect
	dc.w	.ch3fx0-.jmpeffect	;disabled
	dc.w	.ch3fx1-.jmpeffect
	dc.w	.ch3fx2-.jmpeffect
	dc.w	.ch3fx3-.jmpeffect
	dc.w	.ch3fx4-.jmpeffect
	dc.w	.ch3fx5-.jmpeffect
	dc.w	.ch3fx6-.jmpeffect
	dc.w	.ch3fx7-.jmpeffect
	dc.w	.ch3fx8-.jmpeffect
	dc.w	.ch3fx9-.jmpeffect
	dc.w	.ch3fxa-.jmpeffect
	dc.w	.ch3fxb-.jmpeffect
	dc.w	.ch3fxc-.jmpeffect
	dc.w	.ch3fxd-.jmpeffect
	dc.w	.ch3fxe-.jmpeffect
	dc.w	.ch3fxf-.jmpeffect
.ch3fx0	
	bra	.done
.ch3fx1	
	move.w	d0,d1
	and.w	#$7,d0		;d0=valor de 0-7
	and.w	#$f0,d1
	asr.w	#4,d1		;d1=nibble alto de d0
	;tst.w	d1
	beq.s	.SelCurGl	;10x = Select Amp curve (global)
	subq.w	#1,d1
	beq.s	.SelCurDi	;11x = Select Amp curve (distorsion)
	subq.w	#1,d1
	beq.s	.EdCurGl	;12x = Edit Amp curve (global)
	subq.w	#1,d1
	beq.s	.EdCurDi	;13x = Edit Amp curve (Distorsion)
	subq.w	#1,d1
	beq.s	.SelMixcode	;14x = Select mixing code
	bra	.done		;end
.SelCurGl
	;move.w	d0,gxm_currmixcode
	move.w	d0,gxm_usearray	
	bra	.done
.SelCurDi
	move.w	d0,gxm_usearrayparcial
	bra	.done
.EdCurGl
	move.w	d0,gxm_setarray		
	bra	.done
.EdCurDi
	move.w	d0,gxm_setarrayparcial
	bra	.done
.SelMixCode
	move.w	d0,gxm_currmixcode
	bra	.done
.ch3fx2	
	bra	.done
.ch3fx3	
	bra	.done
.ch3fx4	
	bra	.done
.ch3fx5	
	bra	.done
.ch3fx6	
	bra	.done
.ch3fx7	
	bra	.done
.ch3fx8	
	bra	.done
.ch3fx9   
	*--- SECONDARY TEMPO 01<=x<=20 ---*
	and.w	#$1f,d0
	bne	.chfx9c			;si <>0, aplicamos tiempo
	move.w	#$20,d0
.chfx9c	move.w	d0,gxm_num_ticks	;recarga este valor al llegar a 0
	move.w	d0,gxm_curr_tick	;en la linea actual tambien
	bra	.done
.ch3fxa	
	bra	.done
.ch3fxb	
	bra.s	.done
.ch3fxc	
	;FALTA HACER chequeo de limites, etc
	move.w	d0,gxm_HardVolume

	bra.s	.done
.ch3fxd	;FALTA hacer chequeo de limites, etc
	and.w	#$3f,d0
	asl.w	#$8,d0
	move.w	d0,gxm_DistVolume	
	bra.s	.done
.ch3fxe	
	bra	.done
.ch3fxf
.done
	movem.l	(sp)+,a0-a1
	rts

gxm_waitVB:
	tst.b	gxm_mixerrunning
	beq	gxm_waitvbsafe	;if =0, not mixing
.wait
	tst.b	gxm_waitvb_intdone
	bne	.wait
	rts
gxm_waitVBsafe:	;para que no vuelva a ejecutarse antes de que acabe la linea
	move.l	d0,-(sp)
.wvb	move.l	custom+vposr,d0
	and.l	#$1ff00,d0
	;cmp.l	#$12f<<8,d0
	cmp.l	#gxm_stick2line<<8,d0
	bne.b	.wvb
.wvb2	move.l	custom+vposr,d0
	and.l	#$1ff00,d0
	;cmp.l	#$12f<<8,d0
	cmp.l	#gxm_stick2line<<8,d0
	beq.b	.wvb2	
	move.l	(sp)+,d0
	rts



	
gxm_InitSound:
	move.l	a6,-(sp)
	jsr	P61_music
	jsr	gxm_waitvb
	jsr	P61_music
	jsr	gxm_waitvb
	jsr	P61_music
	jsr	gxm_waitvb
	jsr	P61_music
	jsr	gxm_waitvb
	;jsr	P61_music	;sync with P61
	;jsr	gxm_waitvb

	move.l	(sp)+,a6
	
	move.b	#$1,gxm_mixerrunning	;Flag. 0=off, 1=on
	move.w	#$3fff,custom+intena	;desactivamos interrupciones
	move.l	gxm_vbrpos,a0
	move.l	$70(a0),gxm_oldint4	;guardamos direccion int audio vieja
	move.l 	#gxm_intbuff,$70(a0)	;Asignamos Level 4 int
	;move.w	#$8000,custom+intena	;deshabilitamos todas int. (debug)
	move.w 	#$e400,custom+intena	;Enable ch.3 (bit 10) e interrupciones
					;and int6 for p61
	move.w 	#gxm_masterPeriod,custom+aud3per
	move.w 	#$40,custom+aud3vol	;volumen a tope!
	move.l 	#gxm_buff00,custom+aud3lch
	move.w 	#gxm_buffsize/2,custom+aud3len
	move.w 	#$8008,custom+dmacon	;enable DMA channel 3
	clr.b	gxm_playlongbuffer	;marcamos para playear buff corto
	clr.b	gxm_wantlongbuffer	;marcamos para rellenar buff corto
	rts

gxm_intbuff:
	move.l	d7,-(sp)
	move.w	custom+intreqr,d7
	and.w	#$0400,d7	;si es canal 3(bit 10)->atendemos
	beq .noi
	;move.w	#$c00,custom+color00	;debug
	move.l	custom+vposr,d7		;vamos a sincronizar:
	and.l	#$1ff00,d7
	cmp.l	#gxm_stick2line<<8,d7	;sincronizamos a esta linea
	ble.s	.largo
    	*--- Siguiente BUFFER CORTO ---*
	move.w	#gxm_buffsize/2,custom+aud3len
	clr.b	gxm_wantlongbuffer
	;move.w	#$000,custom+color00	;debug
	bra.s	.sig
.largo
    	*--- Siguiente BUFFER LARGO ---*
	move.w	#(gxm_buffsize+gxm_longbuff)/2,custom+aud3len
	move.b	#$1,gxm_wantlongbuffer
	;move.w	#$000,custom+color00	;debug
.sig	;AHORA VEMOS que buffer playeamos/marcamos para siguiente play 
	tst.b	gxm_currbuffer
	bne.s	.buf1
		;Buffer00 playeando, recargar buff01 como siguiente
	move.l	#gxm_buff01,custom+aud3lch ;apuntamos siguiente buffer
	move.b	#$1,gxm_currbuffer
	bra.s	.sig2
.buf1
		;Buffer01 playeando, recargar buff00 como siguiente
	move.l	#gxm_buff00,custom+aud3lch ;apuntamos siguiente buffer
	clr.b	gxm_currbuffer
.sig2
	clr.b	gxm_playlongbuffer
	move.w 	#$0400,custom+intreq ;Apagar bit 10 (int atendida)
	clr.b	gxm_waitvb_intdone  ;indica preparar sig.buffer
.noi
	move.l	(sp)+,d7
	rte


gxm_stopint:	;para interrupcion desde programa principal
	move.w	#$0400,custom+intena	;Disable int channel 3 (bit 10)
	move.w 	#$0400,custom+intreq	;apagamos bit 10 (int atendida)
	move.w 	#$0008,custom+dmacon	;apagamos dma ch.3
	move.w 	#0,custom+aud3vol	;volume=0
	move.l	gxm_vbrpos,a0
	move.l	gxm_oldint4,$70(a0)	;restauramos vector int 4 audio
	clr.b	gxm_mixerrunning	;Flag. 0=off, 1=on
	rts					

gxm_Fillbuf:	;primero vemos que buffer hay que rellenar	
	move.b	#1,gxm_waitvb_intdone
	tst.b	gxm_currbuffer
	bne.s	.buf1
		;Cargaremos parametros de posicion para BUFF00
	lea	gxm_buff00,a5		;a5 ptr a buffer a rellenar
	bra.s	.sig0
.buf1		;Cargaremos parametros de posicion para BUFF01
	lea	gxm_buff01,a5		;a5 ptr a buffer a rellenar
.sig0		;ahora comprobamos si es buffer corto o largo
	tst.b	gxm_wantlongbuffer
	bne.s	.largo
		;aqui cargar parametros de buffer CORTO para refillbuff
	move.w	#gxm_buffsize-1,d7	;d7 contador (num samples en buffer)
	bra.s	.sig
.largo		;aqui cargar parametros de buffer LARGO para refillbuff
	move.w	#gxm_buffsize-1+gxm_longbuff,d7
	clr.b	gxm_wantlongbuffer
	move.b	#$1,gxm_playlongbuffer
.sig

	movem.l	d0-d7/a0-a6,-(sp)	;Must store this. If not, remains muted.
	;movem.l	d7/a5-a6,-(sp)	;Must store this. If not, remains muted.
	move.l	#$dff000,a6	;P61_music needs A6=$dff000
	jsr	P61_music
	;movem.l	(sp)+,d7/a5-a6	;restore
	movem.l	(sp)+,d0-d7/a0-a6	;restore


	;swap	d7
	;clr.w	d7	;limpiamos parte alta
	;move.w	gxm_lastsample,d7
	;swap	d7	
	bsr	ReFillBuff		;si =#$10, call RefillBuff00
	;swap	d7
	;move.w	d7,gxm_lastsample
	;swap	d7

	move.w	d0,gxm_ch0curroff	;guardamos posiciones al salir
	move.w	d1,gxm_ch1curroff	;	
	move.w	d2,gxm_ch2curroff	;
	move.l	a0,gxm_ch0initptr	;a0 ptr a inicio sample ch0
	move.l	a1,gxm_ch1initptr	;a1 ptr a inicio sample ch1
	move.l	a2,gxm_ch2initptr	;a2 ptr a inicio sample ch2
	swap	d6			;dejamos como estaba d6

	;move.w	#$080,custom+color00
	;move.l	a6,-(sp)	;store a6
	;move.l	#$dff000,a6	;P61_music needs A6=$dff000
	;jsr	P61_music
	;move.l	(sp)+,a6	;leave untouched a6 on return
	;move.w	#$25f,custom+color00
	bsr	gxm_play	
.fin
	rts


RefillBuff:
	*--- Rutina + critica, OPTIMIZAR LO MAXIMO ---*
    	*--- a0 sera posicion de sample en ch0 ---*
    	*--- a1 sera posicion de sample en ch1 ---*
    	*--- a2 sera posicion de sample en ch2 ---*
	*--- a3 debe apuntar a la tabla de volumenes ---*
	*--- a4 LIBRE (En Mix01-2 apunta a tabla de distorsion parcial)---*
    	*--- a5 buffer destino en chip, NO DEJAR APUNTANDO A CUENCA!!---*
    	*--- a6 apunta a la curva actual de amplificacion en pos 0 ---*
	*--- a7 full: volumen ch2---*
	*--- Longitud maxima sample =0 a 65535 : ---*
	*--- d0.full-bytes restantes para recargar replen ch0 ---*
	    ;debo utilizar todo, sino falla al hacer sub.w d0,a0
	*--- d1.full-bytes restantes para recargar replen ch1 ---*
	*--- d2.full-bytes restantes para recargar replen ch2 ---*
	*--- d3 multiproposito ---*
	*--- d4.low es acumulador de la muestra en curso ---*
    	*--- d4.high libre ---*
	*--- d5.low es volumen de ch0 ---*
	*--- d5.high es volumen de ch1 ---*
	*--- d6.high controla el acumulador del resto (antes del swap)---*
    	*--- d6.low ocupada?? parte baja, desde fillop (antes del swap)---*
	*--- d7.low contador posicion bufer salida ---*
    	*--- d7.high sample anterior para low pass filter ---*
	;move.w	#$440,custom+color00
	move.l	a6,-(sp)	;Hay que guardar a6 (sino se para audio)
	move.l	a7,gxm_olda7
	;*** CAUTION ***
	;*** FROM NOW THERE IS NOT STACK TILL THE end of this subroutine ***
	;*** NO BSR,NO JSR, NO MOVE (SP), NO RTS, ETC***
	;move.l	#0,a7		;debug, borrar
	move.w 	gxm_HardVolume,custom+aud3vol ;seteamos volumen
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	move.l	gxm_ch0initptr,a0	;a0 ptr a inicio sample ch0
	move.l	gxm_ch1initptr,a1	;a1 ptr a inicio sample ch1
	move.l	gxm_ch2initptr,a2	;a2 ptr a inicio sample ch2
	move.w	gxm_ch0curroff,d0	;cont. decreciente sample ch0(bytes)
	move.w	gxm_ch1curroff,d1	;cont. decreciente sample ch1(bytes)
	move.w	gxm_ch2curroff,d2	;cont. decreciente sample ch2(bytes)

	lea	gxm_LUTvolume,a3		;a3 apunta a tabla volumenes
	move.w	gxm_ch2volume,d5
	asl.w	#8,d5
	move.w	d5,a7			;a7.full=volumen ch2
	;swap	d4			
	move.w	gxm_ch1volume,d5
	asl.w	#8,d5
	swap	d5
	move.w	gxm_ch0volume,d5
	asl.w	#8,d5			;cargamos volumen ch0 y ch1
	moveq	#0,d3			;No quiero basura en parte alta

	swap 	d6			;liberamos parte baja de d6


	;Seleccionamos rutina de mixing.
	;HAY que dejar la rutina basica (mix00) lo mas pulida posible
	;podria hacerse con cmp's
	move.w	gxm_currmixcode,d4
	;dbf	d4,mix00
	;dbf	d4,mix01
	;dbf	d4,mix03

	;move.w	#6,d4			;debug, borrar, forzamos rutina
	and.w	#$7,d4			;que no se salga de la tabla
	add.w	d4,d4
	move.w	.jmpmix(pc,d4.w),d4
	jmp	.jmpmix(pc,d4.w)
.jmpmix
	dc.w	mix00-.jmpmix	;mezcla basica 3 ch
	dc.w	mix01-.jmpmix	;ch0 distorsionado + ch1 +ch2
	dc.w	mix02-.jmpmix	;(ch0+ch1) distorsionado +ch2
	dc.w	mix03-.jmpmix	;(ch0+ch1+ch2) distorsionado (curva parcial)
	dc.w	mix04-.jmpmix	;mezcla basica 3 ch low pass
	dc.w	mix00-.jmpmix	;CRASHES removed
	dc.w	mix06-.jmpmix	;Channels 0 and 1 ONLY
	dc.w	mix00-.jmpmix	;usamos la 0 de momento
	dc.w	mix00-.jmpmix	;usamos la 0 de momento
		

	;************ BEGIN Rutina de mixing 0 ************
	;rutina de mezclado sin distorsion (mas rapida)
mix00:	
	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$444,custom+color00	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d4		;busqueda tabla volumen
	ext.w	d4			;acumulamos a un word con signo
	;add.w	d3,d4			;acumulamos en d4		
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	move.w	gxm_ch2restoacc,d6	;un momento en d6
	sub.w	gxm_ch2resto,d6		;restamos resto ;-)
	bcc.s	.sigini3
	addq	#1,a2
	subq	#1,d2			;nos colamos un sample
	bne.s	.sigini3		;si =0, 		
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sigini3
	;swap	d4
	;clr.w	a7	;illegal addressing mode
	;move.w	#0,a7
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sigini3
	;swap	d4
	move.w	a7,d3			;volumen ch2 en 8 bits altos
	;swap	d4
	move.b	(a2)+,d3		;->d3
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d2			;queda 1 sample menos
	bne.s	.sig3			;seguimos normalmente
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sig3
	;swap	d4
	;clr.w	a7
	;move.w	#0,a7
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sig3    	
	move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	move.b	d4,(a5)+		;guardamos en buffer sample
	dbf	d7,.loopm		;repite mientras no rellene buffer
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 0 **********
	;************ BEGIN Rutina de mixing 01 ************
	;Esta rutina aplica volumen a ch0
	;luego curva de distorsion parcial a ch0
	;a continuacion aplica volumen post-distorsion a ch0
	;guarda en d4 y prosigue con canal 1 y 2 normalmente
mix01:	lea	gxm_curve0,a4		;
	add.w	gxm_offarrayparcial,a4	;+- offset
	move.w	gxm_usearrayparcial,d4		;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a4	;a4 apunta a 0+-offset de curva (usearrayparcial)
	move.l	a4,gxm_ptrarrayparcial
		;ojo, esto de arriba solo se utiliza cuando vaya a haber
		;distorsiones en canales 1 y/o 2 (parcial)

	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$444,custom+color00
	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
				;sample en d3, BEGIN Distorsion
	;move.l	ptrarrayparcial,a4	;apuntamos a curva distorsion
	move.b	(a4,d3),d4		;aplicamos curva parcial
	move.w	gxm_DistVolume,d3	;ponemos volumen post distorsion
	move.b	d4,d3			;volumen*256 +d3
	move.b	(a3,d3),d4		;busqueda tabla volumen
	ext.w	d4			;y seteamos d4		
				;END distorsion
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	move.w	gxm_ch2restoacc,d6	;un momento en d6
	sub.w	gxm_ch2resto,d6		;restamos resto ;-)
	bcc.s	.sigini3
	addq	#1,a2
	subq	#1,d2			;nos colamos un sample
	bne.s	.sigini3		;si =0, 		
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sigini3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sigini3
	;swap	d4
	move.w	a7,d3			;volumen ch2 en 8 bits altos
	;swap	d4
	move.b	(a2)+,d3		;->d3
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d2			;queda 1 sample menos
	bne.s	.sig3			;seguimos normalmente
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sig3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sig3    	
	move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	move.b	d4,(a5)+		;guardamos en buffer sample
	dbf	d7,.loopm		;repite mientras no rellene buffer
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 01 **********
	;************ BEGIN Rutina de mixing 02 ************
	;Esta rutina va a mezclar canales 0 y 1 normalmente
	;a continuacion aplica la curva de distorsion parcial a ch0+ch1
	;a continuacion aplica volumen post-distorsion,
	;acumula en d4 y sigue mezclando canal 2 normalmente
mix02:	
	lea	gxm_curve0,a4		;
	add.w	gxm_offarrayparcial,a4	;+- offset
	move.w	gxm_usearrayparcial,d4		;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a4	;a4 apunta a 0+-offset de curva (usearrayparcial)
	move.l	a4,gxm_ptrarrayparcial
		;ojo, esto de arriba solo se utiliza cuando vaya a haber
		;distorsiones en canales 1 y/o 2 (parcial)

	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$444,custom+color00
	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	move.w	d3,d4
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
				;ch0+ch1 en d3, BEGIN Distorsion
	swap	d6		;podemos utilizar d6.w como scratch
	;;move.l	ptrarrayparcial,a4	;apuntamos a curva distorsion
	move.b	(a4,d4),d3		;aplicamos curva parcial
	move.w	gxm_DistVolume,d6	;ponemos volumen post distorsion
	;move.w	#$1800,d6		;ponemos volumen #$10 postdist (debug)
	move.b	d3,d6			;volumen*256 +d3
	move.b	(a3,d6),d4		;busqueda tabla volumen
	ext.w	d4			;y seteamos d4		
	swap	d6
				;END distorsion

	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	move.w	gxm_ch2restoacc,d6	;un momento en d6
	sub.w	gxm_ch2resto,d6		;restamos resto ;-)
	bcc.s	.sigini3
	addq	#1,a2
	subq	#1,d2			;nos colamos un sample
	bne.s	.sigini3		;si =0, 		
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sigini3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sigini3
	;swap	d4
	move.w	a7,d3			;volumen ch2 en 8 bits altos
	;swap	d4
	move.b	(a2)+,d3		;->d3
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d2			;queda 1 sample menos
	bne.s	.sig3			;seguimos normalmente
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sig3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sig3    	
	move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	move.b	d4,(a5)+		;guardamos en buffer sample
	dbf	d7,.loopm		;repite mientras no rellene buffer
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 02 **********
	;************ BEGIN Rutina de mixing 03 ************
	;Esta rutina va a mezclar canales 0,1 y 2 normalmente
	;a continuacion aplica la curva de distorsion total a ch0+ch1+ch2
	;a continuacion aplica volumen post-distorsion
	;y acumula en d4
mix03:	lea	gxm_curve0,a4		;
	add.w	gxm_offarrayparcial,a4	;+- offset
	move.w	gxm_usearrayparcial,d4		;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a4	;a4 apunta a 0+-offset de curva (usearrayparcial)
	move.l	a4,gxm_ptrarrayparcial
		;ojo, esto de arriba solo se utiliza cuando vaya a haber
		;distorsion (parcial)

	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$444,custom+color00
	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	move.w	d3,d4
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	

	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	move.w	gxm_ch2restoacc,d6	;un momento en d6
	sub.w	gxm_ch2resto,d6		;restamos resto ;-)
	bcc.s	.sigini3
	addq	#1,a2
	subq	#1,d2			;nos colamos un sample
	bne.s	.sigini3		;si =0, 		
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sigini3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sigini3
	;swap	d4
	move.w	a7,d3			;volumen ch2 en 8 bits altos
	;swap	d4
	move.b	(a2)+,d3		;->d3
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	

				;ch0+ch1+ch2 en d3, BEGIN Distorsion
	swap	d6		;podemos utilizar d6.w como scratch
	;move.l	ptrarrayparcial,a4	;apuntamos a curva distorsion
	move.b	(a4,d4),d3		;aplicamos curva parcial (en a4)
	move.w	gxm_DistVolume,d6	;ponemos volumen post distorsion
	;move.w	#$1800,d6		;ponemos volumen #$10 postdi (debug)
	move.b	d3,d6			;volumen*256 +d3
	move.b	(a3,d6),d4		;busqueda tabla volumen
	ext.w	d4			;y seteamos d4		
	swap	d6
	;			;END distorsion


	subq	#1,d2			;queda 1 sample menos
	bne.s	.sig3			;seguimos normalmente
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sig3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sig3    	
	move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	move.b	d4,(a5)+		;guardamos en buffer sample
	dbf	d7,.loopm		;repite mientras no rellene buffer
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 03 **********


	;************ BEGIN Rutina de mixing 4 ************
	;rutina de mezclado sin distorsion (LOW PASS FILTER)
mix04:	
	swap 	d7
	move.w	gxm_lastsample,d7
	swap	d7
	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$444,custom+color00	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d4		;busqueda tabla volumen
	ext.w	d4			;acumulamos a un word con signo
	;add.w	d3,d4			;acumulamos en d4		
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	move.w	gxm_ch2restoacc,d6	;un momento en d6
	sub.w	gxm_ch2resto,d6		;restamos resto ;-)
	bcc.s	.sigini3
	addq	#1,a2
	subq	#1,d2			;nos colamos un sample
	bne.s	.sigini3		;si =0, 		
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sigini3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sigini3
	;swap	d4
	move.w	a7,d3			;volumen ch2 en 8 bits altos
	;swap	d4
	move.b	(a2)+,d3		;->d3
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d2			;queda 1 sample menos
	bne.s	.sig3			;seguimos normalmente
	move.w	gxm_ch2replen,d2	;si 0, recargamos contador
	sub.l	d2,a2			;y restamos replen a posicion
	tst.w	gxm_ch2singlcyc
	beq.s	.sig3
	;swap	d4
	;clr.w	d4
	sub.l	a7,a7
	move.w	a7,gxm_ch2volume	
	move.w	a7,gxm_ch2resto		;minima freq, usa menos CPU
	;swap	d4
.sig3    	
	move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	swap	d7			;suav2
	ext.w	d4			;suav2
	add.w	d7,d4			;suav2
	asr.w	#1,d4			;suav2
	;ext.w	d4			;suavizado
	;add.w	gxm_lastsample,d4	;suavizado sumamos sample anterior
	;asr.w	#1,d4			;suavizado hacemos media
	move.b	d4,(a5)+		;guardamos en buffer sample
	;move.w	d4,gxm_lastsample	;suavizado guardamos para siguiente
	move.w	d4,d7			;suav2
	swap	d7			;suav2
	dbf	d7,.loopm		;repite mientras no rellene buffer
	swap	d7
	move.w	d7,gxm_lastsample
	swap	d7
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 4 **********


	;************ BEGIN Rutina de mixing 06 ************
	;rutina de mezclado sin distorsion (mas rapida)
	;SOLO MEZCLA CH0 y CH1
mix06:	
	lea	gxm_curve0,a6	;
	add.w	gxm_offarray,a6	;+- offset
	move.w	gxm_usearray,d4	;
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	asl.w	#7,d4		;*1024bytes cada curva
	add.w	d4,a6		;a6 apunta a 0+-offset de curva (usearray)
	move.l	a6,gxm_ptrarray
		;en a6 queda el puntero a la curva final
	;move.w	#$333,custom+color00	
.loopm:
	;clr.w	d4
    	*--- CH0 1 sample cada vez ---*
	move.w	gxm_ch0restoacc,d6	;un momento en d6
	sub.w	gxm_ch0resto,d6		;restamos resto ;-)
	bcc.s	.sigini1
	addq	#1,a0
	subq	#1,d0			;nos colamos un sample
	bne.s	.sigini1		;si =0, 
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc
	beq.s	.sigini1		;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;minima freq (usa menos CPU)
.sigini1
	move.w	d5,d3			;volumen ch0 en 8 bits altos
	move.b	(a0)+,d3		;en la parte baja el sample
	move.b	(a3,d3),d4		;busqueda tabla volumen
	ext.w	d4			;acumulamos a un word con signo
	;add.w	d3,d4			;acumulamos en d4		
	subq	#1,d0			;queda 1 sample menos
	bne.s	.sig1			;seguimos normalmente
	move.w	gxm_ch0replen,d0	;si 0, recargamos contador
	sub.l	d0,a0			;y restamos replen a posicion
	tst.w	gxm_ch0singlcyc		;
	beq.s	.sig1			;si =1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch0volume
	move.w	d5,gxm_ch0resto		;min freq, usa menos CPU
.sig1    	
	move.w	d6,gxm_ch0restoacc	;devolvemos valor a acumulador
    	*--- CH1 1 sample cada vez ---*
	swap	d5
	move.w	gxm_ch1restoacc,d6	;un momento en d6
	sub.w	gxm_ch1resto,d6		;restamos resto ;-)
	bcc.s	.sigini2
	addq	#1,a1
	subq	#1,d1			;nos colamos un sample
	bne.s	.sigini2		;si =0, 		
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sigini2		;si=1, PARAMOS SAMPLE
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
.sigini2
	move.w	d5,d3			;volumen ch1 en 8 bits altos
	swap	d5
	move.b	(a1)+,d3		;
	move.b	(a3,d3),d3		;busqueda tabla volumen
	ext.w	d3			;acumulamos a un word con signo
	add.w	d3,d4			;acumulamos en d4	
	subq	#1,d1			;queda 1 sample menos
	bne.s	.sig2			;seguimos normalmente
	move.w	gxm_ch1replen,d1	;si 0, recargamos contador
	sub.l	d1,a1			;y restamos replen a posicion
	tst.w	gxm_ch1singlcyc
	beq.s	.sig2
	swap	d5
	clr.w	d5
	move.w	d5,gxm_ch1volume
	move.w	d5,gxm_ch1resto		;minima freq, usa menos CPU
	swap	d5
.sig2    	
	move.w	d6,gxm_ch1restoacc	;devolvemos valor a acumulador
    	*--- CH2 1 sample cada vez ---*
	;move.w	d6,gxm_ch2restoacc	;devolvemos valor a acumulador
	move.b	(a6,d4),d4		;aplicamos curva
	move.b	d4,(a5)+		;guardamos en buffer sample
	dbf	d7,.loopm		;repite mientras no rellene buffer
	move.l	gxm_olda7,a7
	move.l	(sp)+,a6
	rts
	;*********** END Rutina de MIX 6 **********




	;JUMPPTR GetVBR; Thank you Photon for this code ;-)
	;SECTION test,CODE_C
gxm_GetVBR:					;-->d0
	MOVEM.L A5-A6,-(SP)
	moveq #0,d0
	move.l 4.w,a6
	btst #0,297(a6)
	beq.s .noacc
	lea .VBRtoA2(PC),a5
	jsr -30(a6)
	move.l	d0,gxm_vbrpos		;here, d0=vbr
.noacc:	MOVEM.L (SP)+,A5-A6
	RTS
.VBRtoA2:
	dc.w $4e7a,$0801		;=movec VBR,d0; $0801=reg"0"=d0
	RTE


gxm_fillLUTVol:
    	*--- Rellena LookUp Table control volumen ---*    	
    	*--- Optimizacion 0, si me apetece ya me parare ---*
	lea	gxm_LUTvolume,a0	;destino
	move.w	#-128,d0		;desde -128 hasta +127
	move.l	#64,d1			;0 a 63 (luego haremos el 64)
.loops:
	clr.w	d2			;limpiamos
	move.l	d1,d3			;copia en d3 para
	move.b	d1,d2
	asl.w	#8,d2
	or.b	d0,d2			;juntamos volumen a continuacion
	muls.w	d0,d3
	asr.l	#6,d3			;d3=d0*(d1/64);d3=sample*(vol/64)
	move.b	d3,(a0,d2)
	addq.w	#1,d0
	cmp.w	#127+1,d0		;hasta 127 (poner 128)
	bne	.loops
	move.w	#-128,d0		;desde -128 hasta +127	
	dbf	d1,.loops		;bajamos volumen y repite hasta 0
    	*--- Ejemplo para acceder a la tabla ---*
    	*--- a0 debe apuntar a la tabla ---*
	;move.w	#$207f,d4		;p.ej: $7f a volumen $20
	;move.b	(a0,d4),d5		;ejemplo de busqueda (8 bits bajos)
	;and.w	#$ff,d5			;limpito
	rts

	;INCLUDE	"mgyv/GXMix10/includes/waveshape.i"
    *------------------------------------*
    *--- WAVESHAPING DISTORSION ---------*
    *--- Rutinas de llenado de tablas ---*
	;Para saber de que va:
	;https://hispasonic.com/
	;  tutoriales/conceptos-basicos-sobre-distorsion/39162
	;Se basa en sumar los samples en el mezclador y luego buscarlos en
	;estas tablas de 1024 pos; 3 canales* 256 valores (de -128 a 127).
	;Devuelve un valor atenuado o amplificado siguiendo la curva
	;seleccionada (Se puede seleccionar de la 0 a la 7).
	;Hay una curva seleccionada para utilizar, y otra para modificar.
	; pudiendo ser la misma o una diferente.
	;Por defecto, la 0 es la mas conservadora (solo comprime un poco)
	;Las 4-5-6-7 son las que mas distorsionan
	;Las curvas se podran modificar desde el pattern (setx y sety)
	;Se pueden aplicar por ejemplo, estas distorsiones:
	; -Atenuacion+(clipping o compresion dinamica)
	; -Amplificacion+(clipping o compresion dinamica)
	; -Quitar bits de resolucion dinamica (bitcrunching?)
	; -La atenuacion o amplificacion puede ser simetrica o asimetrica
	; -Rectificacion de media onda u onda completa
	; -Inversion de onda
	; -Clipping con espejo en sentido opuesto
	; -Clipping plano a cualquier nivel
	; -Lo que se os ocurra con la curva adecuada...
	;TODO:
	;Cambiar algunos nombres de variables para encajarlo en mixer
	;encapsular y probar
	;probarlo mucho (que limite de 0 a 7)
	;optimizar (ya lo hara el mgyv del futuro ;-)
	;optim:Quitar partes comunes y agrupar antes de la llamada


msetxy:	MACRO	;para ahorrar 3 lineas cada vez que se define un punto
	move.w	#\1,d0
	bsr	gxm_setx
	move.w	#\2,d0
	bsr	gxm_sety
	ENDM

	;vamos a generar las 8 curvas de amplificacion por defecto
gxm_FillCurves:
	move.w	#0,gxm_setarray
	bsr	gxm_ampcurve0
	move.w	#1,gxm_setarray
	bsr	gxm_ampcurve1
	move.w	#2,gxm_setarray
	bsr	gxm_ampcurve2
	move.w	#3,gxm_setarray
	bsr	gxm_ampcurve3		
	move.w	#4,gxm_setarray
	bsr	gxm_ampcurve4		
	move.w	#5,gxm_setarray
	bsr	gxm_ampcurve5
	move.w	#6,gxm_setarray
	bsr	gxm_ampcurve6
	move.w	#7,gxm_setarray
	bsr	gxm_ampcurve7
	rts

gxm_ampcurve0:	;curva de amplificacion 0
	;casi lineal para 3 canales (127*3) con un poco de compresion
	;luego hace clipping hasta 127*4
	msetxy	$80,$80
	msetxy	$f,$80
	msetxy	43,-64
	msetxy	$3f,0
	msetxy	83,63
	msetxy	$6f,$7f
	msetxy	$7f,$7f	
	rts

gxm_ampcurve1:	;curva de amplificacion 1, con un poco mas de amplificacion
		;con mas compresion en la parte superior
		;Para 3 canales (127*3), luego hace clipping
	msetxy	-128,-128
	msetxy	15,-128
	msetxy	31,-105
	msetxy	47,-64
	msetxy	63,0
	msetxy	79,63
	msetxy	95,104
	msetxy	111,127
	msetxy	127,127	
	rts

gxm_ampcurve2:	;curva de amplificacion 2
		;+amplificacion, +compresion
		;deja 192 por izquierda y 192 por derecha
		;puede sumar hasta +-320, luego clipping
	msetxy	-128,-128
	msetxy	23,-128
	msetxy	41,-96
	msetxy	51,-64
	msetxy	75,63
	msetxy	85,95
	msetxy	103,127
	msetxy	127,127
	rts

gxm_ampcurve3:	;curva de amplificacion 3
		;+amplificacion, +compresion
		;puede sumar hasta +-256, luego clipping
	msetxy	-128,-128
	msetxy	31,-128
	msetxy	48,-96
	msetxy	55,-64
	msetxy	71,63
	msetxy	80,95
	msetxy	95,127
	msetxy	127,127
	rts

gxm_ampcurve4:	;curva de amplificacion 4
		;+amplificacion, +compresion
		;puede sumar hasta +-192, luego clipping
	msetxy	-128,-128
	msetxy	39,-128
	msetxy	53,-96
	msetxy	59,-64
	msetxy	67,63
	msetxy	73,95
	msetxy	87,127
	msetxy	127,127
	rts

gxm_ampcurve5:	;curva de amplificacion 5
		;amplificacion+compresion incluso para 1 canal
		;con bastante distorsion
		;puede sumar hasta +-128, luego clipping
	msetxy	-128,-128
	msetxy	47,-128
	msetxy	56,-120
	msetxy	70,119
	msetxy	79,127
	msetxy	127,127
	rts
gxm_ampcurve6:	;curva de amplificacion 6
		;distorsion+compresion salvaje incluso para 1 canal
	msetxy	-128,-128
	msetxy	51,-128
	msetxy	57,-96
	msetxy	61,-64
	msetxy	65,63
	msetxy	69,95
	msetxy	75,127
	msetxy	127,127
	rts
gxm_ampcurve7:	;curva de amplificacion 7
		;como la anterior con efecto mirror
		;moderado al pasarse de +-96
	msetxy	-128,-64
	msetxy	51,-128
	msetxy	57,-96
	msetxy	61,-64
	msetxy	65,63
	msetxy	69,95
	msetxy	75,127
	msetxy	127,63
	rts
	
gxm_setx:	;se utiliza en canales del 0 al 2 solamente (while playing)
	;d0=posicion x (bit 7 indica linea 0 o line to)
	;if d0<128 then 0-127 valores para el rango 1-1023 (no 1a linea)
	;if d0>127 then pillar 7 bits bajos para x=0, setear y
	;funciona, PERO queda grafica desplazada en x un valor abajo
	;p.ej: valor central debiera ser 512 y es 511
	;Creo que sera casi imperceptible
	;ext.w	d0
	btst	#7,d0
	beq.s	.lineto
	clr.w	gxm_x0	;seleccionamos posicion 0 en x0
	clr.w	gxm_set0;siguiente valor de y no llamara linearray
	rts
.lineto		;si 0: desde punto anterior x0
		;OJO, CON 1 de mas (((x+1)*8)-1)
		;00 significa hasta posicion 7
		;01 hasta posicion 15
		;...
		;3f es mitad de la tabla -1
		;...
		;7f hasta 1023
	and.w	#$7f,d0		;7 bits bajos	
	addq.w	#$1,d0		;a partir de escalon 1
	add.w	d0,d0
	add.w	d0,d0
	add.w	d0,d0		;*8 (sera mejor rotar?)
	subq.w	#$1,d0		;restamos 1 ?
	move.w	d0,gxm_x1	;actualizamos x1
	rts

gxm_sety:	;se utiliza en canal 3 de distorsion solamente (while playing)
	ext.w	d0
	tst.w	gxm_set0
	beq	.end
	move.w	d0,gxm_y1		;valor en y1 (lineto)
	bsr	gxm_linearray	
	rts
.end
	move.w	d0,gxm_y0	;ponemos valor en y0
	move.w	#$1,gxm_set0	;siguiente valor de y llamara linearray
	rts

gxm_linearray:
	;Comprobado para numeros positivos en X
	;Comprobado para lineas SIEMPRE de izquierda a derecha
	;Comprobado para numeros enteros en Y
	;Trazara una linea desde x0,y0 a x1,y1 en array de signed bytes (a0)
	; cada valor de y se guarda en la posicion x del array
	; finalmente, deja en x0,y0 los valores antiguos de x1,y1
	;0<=x<=+1023 ; -128<=y<=+127
	;rutinas plotlow, plothighup, plothighdown traducidas del
	;algoritmo de la wikipedia inglesa y adaptadas a mis necesidades
	;ESTAS PARTES ESTAN SIN OPTIMIZAR EN ABSOLUTO
	movem.l	d0-d6/a0,-(sp)
	move.w	#1023,d4
	move.w	gxm_x0,d2
	and.w	d4,d2		;limitamos de 0 a 1023 x0
	move.w	d2,gxm_x0tmp	;tambien hacemos copias para trashear
	move.w	gxm_y0,d3
	move.w	d3,gxm_y0tmp
	move.w	gxm_x1,d0
	and.w	d4,d0		;limitamos de 0 a 1023 x1
	move.w	d0,gxm_x1tmp
	move.w	gxm_y1,d1
	move.w	d1,gxm_y1tmp
	sub.w	d2,d0		;d0=x1-x0
	sub.w	d3,d1		;d1=y1-y0
	btst	#$f,d0		;signo de d0
	beq.s	.sigue1		;necesitamos valores absolutos
	;No es 0 (es negativo, hay que invertir)
	neg.w	d0
.sigue1
	btst	#$f,d1		;signo de d1
	beq.s	.sigue2
	neg.w	d1
.sigue2				;aqui hay valores absolutos en d0 y d1
	cmp.w	d0,d1
	bge	.mayord1	;if d1>=d0 then goto .mayord1
	;es mayor d0		;(abs(y1-y0))<(abs(x1-x0))
	move.w	gxm_x1tmp,d0
	cmp.w	gxm_x0tmp,d0	;if x0>x1
	bge	.plow
	bsr	gxm_exchgcoords	;then invertimos coordenadas
.plow	bsr	gxm_plotlow		;
	bra.s	.sigue3
.mayord1 ;es mayor d1		;(abs(y1-y0))>=(abs(x1-x0))
	move.w	gxm_y0tmp,d0
	cmp.w	gxm_y1tmp,d0	;if y0>y1
	bge	.phiup
	bsr	gxm_plothighdown
	bra.s	.sigue3
.phiup	
	;bsr	exchgcoords	;then invertimos coordenadas	
	bsr	gxm_plothighup
.sigue3
	move.w	gxm_x1,gxm_x0
	move.w	gxm_y1,gxm_y0	;colocamos punto destino como origen siguiente
	movem.l	(sp)+,d0-d6/a0
	rts

gxm_plotlow: ;para valores con slope<45 de izquierda a derecha
	 ;con inclinacion hacia arriba y abajo funciona
	move.w	gxm_setarray,d0
	move.w	#10,d1
	asl.w	d1,d0
	lea	gxm_curvebase,a0
	lea	(a0,d0.w),a0
	;lea	gxm_curvebase,a0
	move.w	gxm_x0tmp,d2
	move.w	d2,d5		;hace falta luego en d5
	move.w	gxm_y0tmp,d3
	move.w	d3,d4		;hace falta luego en d4
	move.w	gxm_x1tmp,d0
	move.w	gxm_y1tmp,d1
	sub.w	d2,d0		;d0=x1-x0
	sub.w	d3,d1		;d1=y1-y0
	moveq	#$1,d2		;d2=1
	tst.w	d1		
	bge	.cont		;if d1>=0 then goto .cont
	moveq	#-1,d2		;else invertimos d2 y d1
	neg.w	d1
	
.cont	move.w	d1,d3
	add.w	d3,d3		;d3=2*d1
	sub.w	d0,d3		;d3=(2*d1)-d0

	;for d5=x0 to x1 do
.loop
	move.b	d4,(a0,d5)	;guardamos y en array
	tst.w	d3
	bge	.cont2		;if d3>=0 then goto .cont2
	;d3<0
	move.w	d1,d6
	add.w	d6,d6		;d6=2*d1
	add.w	d6,d3		;d3=d3+(2*d1)
	bra.s	.cont3
.cont2	;d3>=0
	add.w	d2,d4		;d4=d4+d2
	move.w	d1,d6
	sub.w	d0,d6		;d6=d1-d0
	add.w	d6,d6		;d6=2*(d1-d0)
	add.w	d6,d3		;d3=d3+(2*(d1-d0))
	
.cont3
	addq	#$1,d5
	cmp.w	gxm_x1tmp,d5
	bls	.loop

	rts

gxm_plothighdown: 
	 ;para valores con slope>45 de izquierda a derecha
	 ;con inclinacion hacia abajo solamente
	move.w	gxm_setarray,d0
	move.w	#10,d1
	asl.w	d1,d0
	lea	gxm_curvebase,a0
	lea	(a0,d0.w),a0
	;lea	gxm_curvebase,a0
	move.w	gxm_x0tmp,d2
	move.w	gxm_y0tmp,d3
	move.w	d2,d4		;hace falta luego en d4
	move.w	d3,d5		;hace falta luego en d5
	move.w	gxm_x1tmp,d0
	move.w	gxm_y1tmp,d1
	sub.w	d2,d0		;d0=x1-x0
	sub.w	d3,d1		;d1=y1-y0
	moveq	#$1,d2		;d2=1
	tst.w	d0		
	bge	.cont		;if d0>=0 then goto .cont
	moveq	#-1,d2		;else invertimos d2 y d0
	neg.w	d0
	
.cont	move.w	d0,d3
	add.w	d3,d3		;d3=2*d0
	sub.w	d1,d3		;d3=(2*d0)-d1

	;for d5=y0 to y1 do
.loop
	;move.b	d4,(a0,d5)	;guardamos y en array
	tst.w	d3
	bge	.cont2		;if d3>=0 then goto .cont2
	;d3<0
	move.w	d0,d6
	add.w	d6,d6		;d6=2*d0
	add.w	d6,d3		;d3=d3+(2*d0)
	bra.s	.cont3
.cont2	;d3>=0
	move.w	d5,d6
	sub.w	d2,d6		;d6=d5-d2 ;correccion
	subq.w	#1,d6
	move.b	d6,(a0,d4)	;guardamos y en array
	
	add.w	d2,d4		;d4=d4+d2
	move.w	d0,d6
	sub.w	d1,d6		;d6=d0-d1
	add.w	d6,d6		;d6=2*(d0-d1)
	add.w	d6,d3		;d3=d3+(2*(d0-d1))
.cont3
	addq	#$1,d5
	cmp.w	gxm_y1tmp,d5
	ble	.loop
	subq.w	#1,d5
	move.b	d5,(a0,d4)	;guardamos y en array (ultimo punto)
	;move.w	x0,d4
	;move.b	y0,(a0,d4)	;correccion del primer punto
	rts

gxm_plothighup: 
	 ;para valores con slope>45 de derecha a izquierda
	 ;con inclinacion hacia arriba solamente
	 ;varia la correccion con respecto al highdown
	move.w	gxm_setarray,d0
	move.w	#1024,d1
	asl.w	d1,d0
	lea	gxm_curvebase,a0
	lea	(a0,d0),a0
	;lea	gxm_curvebase,a0
	
	bsr	gxm_exchgcoords
	move.w	gxm_x0tmp,d2
	move.w	gxm_y0tmp,d3
	move.w	d2,d4		;hace falta luego en d4
	move.w	d3,d5		;hace falta luego en d5
	move.w	gxm_x1tmp,d0
	move.w	gxm_y1tmp,d1
	sub.w	d2,d0		;d0=x1-x0
	sub.w	d3,d1		;d1=y1-y0
	moveq	#$1,d2		;d2=1
	tst.w	d0		
	bge	.cont		;if d0>=0 then goto .cont
	moveq	#-1,d2		;else invertimos d2 y d0
	neg.w	d0
	
.cont	move.w	d0,d3
	add.w	d3,d3		;d3=2*d0
	sub.w	d1,d3		;d3=(2*d0)-d1

	;for d5=y0 to y1 do
.loop
	;move.b	d4,(a0,d5)	;guardamos y en array
	tst.w	d3
	bge	.cont2		;if d3>=0 then goto .cont2
	;d3<0
	move.w	d0,d6
	add.w	d6,d6		;d6=2*d0
	add.w	d6,d3		;d3=d3+(2*d0)
	bra.s	.cont3
.cont2	;d3>=0
	move.w	d5,d6
	add.w	d2,d6		;d6=d5+d2 ;correccion
	subq.w	#$1,d6
	move.b	d6,(a0,d4)	;guardamos y en array
	
	add.w	d2,d4		;d4=d4+d2
	move.w	d0,d6
	sub.w	d1,d6		;d6=d0-d1
	add.w	d6,d6		;d6=2*(d0-d1)
	add.w	d6,d3		;d3=d3+(2*(d0-d1))
.cont3
	addq	#$1,d5
	cmp.w	gxm_y1tmp,d5
	ble	.loop
	subq	#$1,d5		;correccion empirica :-S
	move.b	d5,(a0,d4)	;guardamos y en array (ultimo punto)
	rts

gxm_exchgcoords
	move.w	gxm_x0tmp,d0
	move.w	gxm_x1tmp,gxm_x0tmp
	move.w	d0,gxm_x1tmp
	move.w	gxm_y0tmp,d0
	move.w	gxm_y1tmp,gxm_y0tmp
	move.w	d0,gxm_y1tmp	;x0<->x1, y0<->y1 (optimizable?)
	rts
	
;ampcurvetest:		;prueba con linearray (sin usar setx, sety ni macros)
;	move.w	#0,x0
;	move.w	#-128,y0
;	move.w	#128,x1
;	move.w	#-128,y1
;	bsr	linearray
;	move.w	#352,x1
;	move.w	#-64,y1
;	bsr	linearray
;	move.w	#512,x1
;	move.w	#0,y1
;	bsr	linearray
;	move.w	#672,x1
;	move.w	#63,y1
;	bsr	linearray
;	move.w	#896,x1
;	move.w	#127,y1
;	bsr	linearray
;	move.w	#1023,x1
;	move.w	#127,y1
;	bsr	linearray
;	rts

	SECTION curves_vars,DATA_P

gxm_x0		dc.w	0	;x0,y0,x1,y1 datos para hacer linea
gxm_y0		dc.w	0	;valores originales
gxm_x1		dc.w	0	;no se cambiaran durante la rutina
gxm_y1		dc.w	0	;al final x0:=x1, y0:=y1
gxm_x0tmp	dc.w	0	;x0,y0,x1,y1 datos para hacer linea
gxm_y0tmp	dc.w	0	;pueden ser trasheados
gxm_x1tmp	dc.w	0
gxm_y1tmp	dc.w	0
gxm_set0	dc.w	0	;flag indica "seteando posicion 0 de curva"
gxm_setarray	dc.w	0	;seteando curva actualmente mix final
gxm_setarrayparcial	dc.w	0	;seteando curva actual mix parcial
		;ESTOS 4 valores se utilizaran desde el mixer
		;de momento los dejo comentados
gxm_usearray	dc.w	0	;curva en uso para mix final
gxm_usearrayparcial	dc.w	0	;curva en uso para mix parcial
gxm_offarray	dc.w	0	;offset con respecto al 0
gxm_offarrayparcial	dc.w	0	;offset para mix parcial
		;offsets: desplazamiento del 0 hacia derecha o izquierda
		;provoca asimetria en la amplificacion, pero inserta
		;algo de DC en la mezcla (usar con cuidado)
		; y no salirse de las 1024 posiciones (+-128 como mucho)
gxm_ptrarray	dc.l	0	;puntero a array dentro de loopm:
gxm_ptrarrayparcial	dc.l	0	;puntero a arrayparcial dentro loopm: 

	SECTION	Curves,BSS_P		;NO INICIALIZADAS
	;8 arrays de 1024 posiciones para tablas de amplificacion:
gxm_curvebase	ds.b	512		;array de 1024 pos
gxm_curve0	ds.b	512		;posicion intermedia 0
gxm_curvebase1	ds.b	512		;array de 1024 pos
gxm_curve1	ds.b	512		;posicion intermedia 0
gxm_curvebase2	ds.b	512		;array de 1024 pos
gxm_curve2	ds.b	512		;posicion intermedia 0
gxm_curvebase3	ds.b	512		;array de 1024 pos
gxm_curve3	ds.b	512		;posicion intermedia 0
gxm_curvebase4	ds.b	512		;array de 1024 pos
gxm_curve4	ds.b	512		;posicion intermedia 0
gxm_curvebase5	ds.b	512		;array de 1024 pos
gxm_curve5	ds.b	512		;posicion intermedia 0
gxm_curvebase6	ds.b	512		;array de 1024 pos
gxm_curve6	ds.b	512		;posicion intermedia 0
gxm_curvebase7	ds.b	512		;array de 1024 pos
gxm_curve7	ds.b	512		;posicion intermedia 0

    *--- OTRAS TABLAS NO INICIALIZADAS EN FAST ---*
	;SECTION	gxm_tables,BSS_P
gxm_LUTvolume	ds.b	16640	;65*256 (de 0 a 64)
				;Tabla de volumen (16k + 256bytes)
	

    *--- Variables FAST ---*
	SECTION	gxm_data,DATA_P
    *--- Variables del MIXER ---*
;gxm_req_fill		dc.w	0
;gxm_req_pos		dc.w	0
gxm_currmixcode		dc.w	0	;current mixing code
gxm_currbuffer		dc.b	0	;flag a 1 al terminar int de audio
					;poner a 0 despues de rellenar buffer
					;chequear justo despues de waitvb
					;si es 1, marcar buffer largo
gxm_playlongbuffer	dc.b	0	;siguiente buffer a playear largo
gxm_wantlongbuffer	dc.b	0	;siguiente buffer a rellenar largo
gxm_mixerrunning	dc.b	0	;Flag. 0=off, 1=on
gxm_waitvb_intdone	dc.b	0	;flag fin int4 para preparar sig.buffer

	EVEN
gxm_lastsample		dc.w	0	;sample anterior para hacer media
				;o ultimo sample de buffer anterior
gxm_HardVolume		dc.w	$40	;volumen del canal hardware
gxm_DistVolume		dc.w	$1000	;volume after distorsion

	EVEN			;alineamos variables byte
	;valores de samples en reproduccion para cada canal
	;NO CAMBIAR DE ORDEN, sino em_play casca (usa offsets desde ch0size)
	;Puedes agregar al final los campos necesarios (o insertarlos en FREE)
gxm_ch0initptr	dc.l	0	;inicio del sample actual ch.0
gxm_ch1initptr	dc.l	0	;inicio del sample actual ch.1
gxm_ch2initptr	dc.l	0	;inicio del sample actual ch.2
gxm_ch0size	dc.w	0	;longitud en bytes del sample ch.0
gxm_ch0len	dc.w	0	;bytes desde inicio hasta fin repetic. ch.0
gxm_ch0replen	dc.w	0	;longitud en bytes del bucle ch.0
gxm_ch0volume	dc.w	0	;volumen actual del canal 0 a 63? ch.0
gxm_ch0singlcyc	dc.w	0	;si 1, bajara el volumen despues de 1 ciclo
gxm_ch0curroff	dc.w	0	;contador decreciente offset en bytes ch.0
gxm_ch0resto	dc.w	0	;resto(65535) define la frecuencia ch.0
gxm_ch0restoacc	dc.w	0	;resto acumulado para ch.0
gxm_ch0volinc	dc.w	0	;increm/decrem volumen actual (comando AXX)
gxm_ch0free	dcb.b	14	;FREE
gxm_ch1size	dc.w	0	;longitud en bytes del sample ch.1
gxm_ch1len	dc.w	0	;bytes desde inicio hasta fin repetic. ch.1
gxm_ch1replen	dc.w	0	;longitud en bytes del bucle ch.1
gxm_ch1volume	dc.w	0	;volumen actual del canal 0 a 63? ch.1
gxm_ch1singlcyc	dc.w	0	;si 1, hara 1 ciclo y bajara volumen
gxm_ch1curroff	dc.w	0	;contador decreciente offset en bytes ch.1
gxm_ch1resto	dc.w	0	;resto(65535) define la frecuencia ch.1
gxm_ch1restoacc	dc.w	0	;resto acumulado para ch.1
gxm_ch1volinc	dc.w	0	;increm/decrem volumen actual (comando AXX)
gxm_ch1free	dcb.b	14	;FREE
gxm_ch2size	dc.w	0	;longitud en bytes del sample ch.2
gxm_ch2len	dc.w	0	;bytes desde inicio hasta fin repetic. ch.2
gxm_ch2replen	dc.w	0	;longitud en bytes del bucle ch.2
gxm_ch2volume	dc.w	0	;volumen actual del canal 0 a 63? ch.2
gxm_ch2singlcyc	dc.w	0	;si 1, se bajara volumen al hacer 1 ciclo
gxm_ch2curroff	dc.w	0	;contador decreciente offset en bytes ch.2
gxm_ch2resto	dc.w	0	;resto(65535) define la frecuencia ch.2
gxm_ch2restoacc	dc.w	0	;resto acumulado para ch.2
gxm_ch2volinc	dc.w	0	;increm/decrem volumen actual (comando AXX)
gxm_ch2free	dcb.b	14	;FREE

    *--- Variables del player ---*
    EVEN		; *** PLAY POSITION RELATED ***
    				;* = initialized in em_init
gxm_fixdptrs	dc.w	0	;si suma direcciones a punteros-> <>0
gxm_allowplay	dc.w	0	;* debe <>0 para llamada a em_play cada vb
gxm_curr_tick	dc.w	0	;si llega a 0, cargar con num_ticks
gxm_num_ticks	dc.w	0	;valor para recargar
gxm_curr_line	dc.w	0	;obvio
gxm_numlines	dc.w	0	;if line=esto -> siguiente block
gxm_curr_block_ptr dc.l	0	;puntero actual alimentando mezclador??
gxm_curr_songpos dc.w	0	;posicion en la tabla de cancion
gxm_songlen	dc.w	0	;* posicion final de la cancion en lista
gxm_inisongpos_ptr dc.l	0	;* puntero a playseq
gxm_block_list_ptr dc.l	0	;* puntero a lista de blocks
gxm_totalblocks	dc.w	0	;* numero total de blocks
gxm_nosampleptr	dc.l	0	;contiene direccion de nosample 
			; *** SAMPLE RELATED ***
gxm_totalsamples	dc.w	0 ;* numero total de samples
gxm_sample_base_list_ptr dc.l	0 ;* puntero a lista de samples
gxm_sample_param_ptr	dc.l	0 ;* puntero a lista de parametros de samples
gxm_nosample		dcb.b	$100 ;256 bytes para mezclar silencio

    *--- Otras variables ---*
gxm_oldint4	dc.l	0	;lo que habia en vector audio ($70)
gxm_vbrpos	dc.l	0	;apuntara a vbr
;gxm_oldP61_A6	dc.l	0	;
gxm_oldA7	dc.l	0	;guarda A7 antes de rutina mixing
    *--- Abajo valores cubiertos a partir de G 2 ---*
    	;las primeras lineas 0 es por si me animo a hacer la octava inferior
    	;afinacion con interpolacion de 3 puntos
    	;Valores calculados con wolfram alpha de 0 a 1024
    	;interpolacion {(0,0),(7,512),(12,1024)}
    	;y=((256*x*x)/105)+((5888*x)/105) :: for x=0 to 12
    	;EN ACTUAL VERSION es de 0 a 65535
    	;0=play all samples  65535=play half samples (1 octave high)
    	;regido por la siguiente interpolacion:
    	;interpolation {(0,0),(112,32768),(192,65535)}
    	;y=((21843*x*x)/35840)+((502459*x)/2240) :: for x=0 to 192
gxm_freqtable:	
		dc.w	0,0,0,0,0,0,0,0	;fine tuning (more=lower pitch)
		dc.w	0,0,0,0,0,0,0,0,0,0,0,0 ;relleno 1/2 tono
		;dc.w	0,0,0,0,0,0,0,0,0,0,0,0	;1a octava
		;dc.w	0,0,0,0,0,0,0,0,0,0,0,0	;1a octava
		dc.w	0,0,0,0,0,0,0,0,0,0,0,0	;1a octava
		dc.w	0,0,0,0,0,0,0,0,0,0,0,0	;1a octava
		dcb.w	192
		dcb.w	16
		dcb.w	16
		dcb.w	16	
		dcb.w	16	
		dcb.w	16		
		dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;D#2
		dc.w	0,225,451,678,907,1137,1368,1600	
		dc.w	1834,2068,2304,2541,2780,3019,3260,3502		;E2
		dc.w	3745,3989,4235,4482,4730,4979,5230,5482
		dc.w	5735,5989,6244,6501,6759,7018,7278,7539		;F2
		dc.w	7802,8066,8331,8598,8865,9134,9404,9675
		dc.w	9948,10221,10496,10772,11050,11328,11608,11889	;F#2
		dc.w	12171,12455,12739,13025,13312,13601,13890,14181
		dc.w	14473,14766,15060,15356,15653,15951,16250,16551	;G2
		dc.w	16852,17155,17459,17765,18071,18379,18688,18998
		dc.w	19310,19623,19936,20252,20568,20886,21204,21524	;G#2
		dc.w	21846,22168,22492,22816,23143,23470,23798,24128
		dc.w	24459,24791,25125,25459,25795,26132,26471,26810	;A2
		dc.w	27151,27493,27836,28180,28526,28873,29221,29570
		dc.w	29920,30272,30625,30979,31334,31691,32049,32408	;A#2
		dc.w	32768,33129,33492,33856,34221,34587,34955,35324
		dc.w	35694,36065,36437,36811,37186,37562,37939,38318	;B2
		dc.w	38697,39078,39460,39844,40228,40614,41001,41390
		dc.w	41779,42170,42562,42955,43349,43745,44141,44539	;C3
		dc.w	44939,45339,45741,46144,46548,46953,47360,47767
		dc.w	48176,48587,48998,49411,49824,50240,50656,51073	;C#3
		dc.w	51492,51912,52333,52756,53179,53604,54030,54457
		dc.w	54886,55315,55746,56179,56612,57046,57482,57919	;D3
		dc.w	58358,58797,59238,59680,60123,60567,61013,61459
		dc.w	61907,62356,62807,63259,63711,64165,64621,65077	;D#3
		dc.w	65535	;E3

    *--- Buffers de reproduccion (deben estar en CHIP) ---*
	SECTION	gxm_buffers,BSS_C	;NO INICIALIZADOS
gxm_buff00:    
	ds.b	gxm_buffsize+gxm_longbuff ;<esto reserva buffsize bytes a 0
	EVEN
gxm_buff01:
	ds.b	gxm_buffsize+gxm_longbuff
	EVEN

