#!/usr/bin/env node

import { createServer } from 'http'
import { readFileSync } from 'fs'

const FILE = 'neuralyte-pertussis.webp.htm.br'
const PORT = 1337

const BUFFER = readFileSync(FILE)
const SIZE = BUFFER.byteLength

console.log(`serving '${FILE}' (${SIZE} bytes) on http://localhost:${PORT}`)

createServer((req, res) => {
  if (!(req.url || '/').slice(1)) {
    res.setHeader('Content-Encoding', 'br')
    res.setHeader('Content-Type', 'text/html')
    res.setHeader('Content-Length', SIZE)
    res.write(BUFFER)
  } else {
    res.setHeader('Content-Length', 0)
  }
  res.end()
}).listen(PORT)
