{
===========================================================
Datei    : MAUS.PAS
Zweck    : UNIT fr Mausbenutzung
Datum    : 09.04.1990
Version  : 2.01
Autor    : Achim Kalwa
Compiler : TURBO-PASCAL V5.5
===========================================================
}
{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V-}
UNIT Maus;

INTERFACE

CONST
	LeftButton = $0001;         { linke Maustaste    }
	RightButton= $0002;         { rechte Maustaste   }
	MidButton  = $0004;         { mittlere Maustaste }
	MausHardCursor = 1;
	MausSoftCursor = 0;

TYPE
  SCMaskType = RECORD
    Smask : ARRAY[0..15] OF WORD;
    Cmask : ARRAY[0..15] OF WORD;
  END;

FUNCTION  MausOk:BOOLEAN;
{ Testet ob Maus vorhanden ist }

PROCEDURE MausInit;
{ Initialisiert den Maus-Treiber }

PROCEDURE ShowMaus;
{ Mauscursor anzeigen }

PROCEDURE HideMaus;
{ Mauscursor abschalten }

FUNCTION MausButton:BYTE;
{ Maustasten abfragen }

FUNCTION MausXpos:WORD;
{ X-Position der Maus }

FUNCTION MausYpos:WORD;
{ Y-Position der Maus }

PROCEDURE SetMausPos(x,y:WORD);
{ Maus positionieren }

PROCEDURE MausWindow(x1,y1,x2,y2:WORD);
{ Legt Bereich fr Maus fest }

FUNCTION  MausInWindow(x1,y1,x2,y2:WORD):BOOLEAN;
{ Prft, ob Mauszeiger innerhalb eines Bildausschnittes }

PROCEDURE MausSetTextCursor(Typ:BYTE;Smask,Cmask:WORD);
{ Definiert den Mauscursor im Textmodus }

PROCEDURE MausGrafikCursor(HotX,HotY:WORD; VAR SCMask);
{ Definiert den Mauscursor im Grafikmodus }

IMPLEMENTATION

USES
  Dos;

VAR
  Reg   : REGISTERS;

FUNCTION  MausOk:BOOLEAN;
BEGIN
  Reg.AX:=0;
  Intr($33,Reg);
	MausOk:=(Reg.AX<>0);
END;

PROCEDURE MausInit;
BEGIN
  Reg.AX:=0;
  Intr($33,Reg);
  IF Reg.AX=0 THEN BEGIN
    WriteLn;
    WriteLn('Maustreiber nicht geladen! Programm abgebrochen',#7);
    HALT(1);
  END;
END;

PROCEDURE ShowMaus;
BEGIN
  Reg.AX:=1;
  Intr($33,Reg);
END;

PROCEDURE HideMaus;
BEGIN
  Reg.AX:=2;
  Intr($33,Reg);
END;

FUNCTION MausButton:BYTE;
BEGIN
  Reg.AX:=3;
  Intr($33,Reg);
	Mausbutton:=Reg.BL;
END;

FUNCTION MausXpos:WORD;
BEGIN
  Reg.AX:=3;
  Intr($33,Reg);
	MausXpos:=Reg.CX Div 2;
END;

FUNCTION MausYpos:WORD;
BEGIN
  Reg.AX:=3;
  Intr($33,Reg);
	MausYpos:=Reg.DX;
END;

PROCEDURE SetMausPos(x,y:WORD);
BEGIN
  Reg.AX:=4;
	Reg.CX:=x * 2;
	Reg.DX:=y;
  Intr($33,Reg);
END;

PROCEDURE MausWindow(x1,y1,x2,y2:WORD);
BEGIN
  Reg.AX:=7;
	Reg.CX:=x1 * 2;
	Reg.DX:=x2 * 2;
	Intr($33,Reg);
	Reg.AX:=8;
	Reg.CX:=y1;
  Reg.DX:=y2;
  Intr($33,Reg);
END;

FUNCTION  MausInWindow(x1,y1,x2,y2:WORD):BOOLEAN;
BEGIN
  Reg.AX:=3;
  Intr($33,Reg);
	MausInWindow:=(x1 * 2<=Reg.CX) AND (Reg.CX<=x2 * 2) AND
								 (y1<=Reg.DX) AND (Reg.DX<=y2);
END;

PROCEDURE MausSetTextCursor(Typ:BYTE;Smask,Cmask:WORD);
BEGIN
  Reg.AX:=10;
  Reg.BX:=Typ;    { Software / Hardware }
  Reg.CX:=Smask;
  Reg.DX:=Cmask;
  Intr($33,Reg);
END;

PROCEDURE MausGrafikCursor(HotX,HotY:WORD; VAR SCMask);
BEGIN
  Reg.AX:=9;
	Reg.BX:=HotX * 2;
  Reg.CX:=HotY;
  Reg.DX:=Ofs(SCMask);
  Reg.ES:=Seg(SCMask);
  Intr($33,Reg);
END;

END.

