/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.simple;

import java.io.PrintStream;

class OutputChoice {
    final OutputChoiceType outputChoiceType;
    final PrintStream targetPrintStream;

    OutputChoice(OutputChoiceType outputChoiceType) {
        if (outputChoiceType == OutputChoiceType.FILE) {
            throw new IllegalArgumentException();
        }
        this.outputChoiceType = outputChoiceType;
        this.targetPrintStream = outputChoiceType == OutputChoiceType.CACHED_SYS_OUT ? System.out : (outputChoiceType == OutputChoiceType.CACHED_SYS_ERR ? System.err : null);
    }

    OutputChoice(PrintStream printStream2) {
        this.outputChoiceType = OutputChoiceType.FILE;
        this.targetPrintStream = printStream2;
    }

    PrintStream getTargetPrintStream() {
        switch (this.outputChoiceType.ordinal()) {
            case 0: {
                return System.out;
            }
            case 2: {
                return System.err;
            }
            case 1: 
            case 3: 
            case 4: {
                return this.targetPrintStream;
            }
        }
        throw new IllegalArgumentException();
    }

    static enum OutputChoiceType {
        SYS_OUT,
        CACHED_SYS_OUT,
        SYS_ERR,
        CACHED_SYS_ERR,
        FILE;

    }
}

