/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.LinearType;
import org.openrndr.shape.internal.BezierQuadraticSamplerTKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 $*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001$B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005Jj\u0010\u0019\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u00142\u001c\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u00142\u001c\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u00142\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J?\u0010\u0019\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u00140\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u00140\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSamplerT;", "T", "Lorg/openrndr/math/EuclideanVector;", "", "<init>", "()V", "recursionLimit", "", "distanceTolerance", "", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "angleToleranceEpsilon", "angleTolerance", "points", "", "Lkotlin/Pair;", "Lorg/openrndr/shape/internal/Tt;", "getPoints$openrndr_shape", "()Ljava/util/List;", "setPoints$openrndr_shape", "(Ljava/util/List;)V", "sample", "", "vt1", "vt2", "vt3", "level", "", "x1", "x2", "x3", "(Lorg/openrndr/math/EuclideanVector;Lorg/openrndr/math/EuclideanVector;Lorg/openrndr/math/EuclideanVector;)Ljava/util/List;", "Companion", "openrndr-shape"})
public final class BezierQuadraticSamplerT<T extends EuclideanVector<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int recursionLimit;
    private double distanceTolerance = 0.5;
    private double distanceToleranceSquare;
    private final double angleToleranceEpsilon;
    private final double angleTolerance;
    @NotNull
    private List<Pair<T, Double>> points = new ArrayList();
    private static final double colinearityEpsilon = 1.0E-30;

    public BezierQuadraticSamplerT() {
        this.recursionLimit = 12;
        this.angleToleranceEpsilon = 0.01;
    }

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final List<Pair<T, Double>> getPoints$openrndr_shape() {
        return this.points;
    }

    public final void setPoints$openrndr_shape(@NotNull List<Pair<T, Double>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.points = list;
    }

    private final void sample(Pair<? extends T, Double> vt1, Pair<? extends T, Double> vt2, Pair<? extends T, Double> vt3, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Pair vt12 = BezierQuadraticSamplerTKt.access$times(BezierQuadraticSamplerTKt.access$plus(vt1, vt2), 0.5);
        Pair vt23 = BezierQuadraticSamplerTKt.access$times(BezierQuadraticSamplerTKt.access$plus(vt2, vt3), 0.5);
        Pair vt123 = BezierQuadraticSamplerTKt.access$times(BezierQuadraticSamplerTKt.access$plus(vt12, vt23), 0.5);
        EuclideanVector x1 = (EuclideanVector)vt1.getFirst();
        EuclideanVector x2 = (EuclideanVector)vt2.getFirst();
        EuclideanVector x3 = (EuclideanVector)vt3.getFirst();
        EuclideanVector d = (EuclideanVector)x3.minus((LinearType)x1);
        double d1 = ((EuclideanVector)x2.minus((LinearType)x3)).areaBetween((EuclideanVector)x3.minus((LinearType)x1));
        if (d1 > 1.0E-30) {
            if (d1 * d1 <= this.distanceToleranceSquare * d.getSquaredLength()) {
                if (this.angleTolerance < this.angleToleranceEpsilon) {
                    if (BezierQuadraticSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt123) > 0.0) {
                        this.points.add(vt123);
                    }
                    return;
                }
                double da = Math.abs(((EuclideanVector)x2.minus((LinearType)x1)).atan2((EuclideanVector)x3.minus((LinearType)x2)));
                if (da >= Math.PI) {
                    da = Math.PI * 2 - da;
                }
                if (da < this.angleTolerance) {
                    if (BezierQuadraticSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), vt123) > 0.0) {
                        this.points.add(vt123);
                    }
                    return;
                }
            }
        } else {
            double da = d.getSquaredLength();
            double dl = 0.0;
            if (da == 0.0) {
                dl = x1.squaredDistanceTo(x2);
            } else {
                dl = ((EuclideanVector)x2.minus((LinearType)x1)).dot(d) / da;
                if (dl > 0.0 && dl < 1.0) {
                    return;
                }
                double d2 = dl <= 0.0 ? x2.squaredDistanceTo(x1) : (dl = dl >= 1.0 ? x2.squaredDistanceTo(x3) : x2.squaredDistanceTo((EuclideanVector)x1.plus(d.times(dl))));
            }
            if (dl < this.distanceToleranceSquare) {
                if (BezierQuadraticSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), x2) > 0.0) {
                    this.points.add(vt2);
                }
                return;
            }
        }
        this.sample(vt1, vt12, vt123, level + 1);
        this.sample(vt123, vt23, vt3, level + 1);
    }

    @NotNull
    public final List<Pair<T, Double>> sample(@NotNull T x1, @NotNull T x2, @NotNull T x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.points.add(TuplesKt.to(x1, 0.0));
        this.sample(TuplesKt.to(x1, 0.0), TuplesKt.to(x2, 0.5), TuplesKt.to(x3, 1.0), 0);
        if (BezierQuadraticSamplerTKt.access$squaredDistanceTo(CollectionsKt.last(this.points), x3) > 0.0) {
            this.points.add(TuplesKt.to(x3, 1.0));
        }
        return this.points;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSamplerT$Companion;", "", "<init>", "()V", "colinearityEpsilon", "", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

